/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.commons.util.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PermRolesMeta {
    Meta role;
    Meta permissions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<ParamMetadata.ParamType, Map<String, ParamMetadata>> paramPermissionsMetadata;

    public Map<ParamMetadata.ParamType, Map<String, ParamMetadata>> getParamPermissionsMetadata() {
        return this.paramPermissionsMetadata;
    }

    public void put(ParamMetadata.ParamType paramType, String name, ParamMetadata paramMetadata) {
        if (this.paramPermissionsMetadata == null) {
            this.paramPermissionsMetadata = new HashMap<ParamMetadata.ParamType, Map<String, ParamMetadata>>();
        }
        this.paramPermissionsMetadata.computeIfAbsent(paramType, r -> new HashMap()).put(name, paramMetadata);
    }

    public boolean non() {
        return !(this.role != null && !this.role.non() || this.permissions != null && !this.permissions.non());
    }

    public boolean nonAll() {
        return !(this.role != null && !this.role.non() || this.permissions != null && !this.permissions.non() || this.paramPermissionsMetadata != null && this.paramPermissionsMetadata.size() != 0 && !this.paramPermissionsMetadata.values().stream().noneMatch(Objects::nonNull));
    }

    public void removeApi() {
        this.role = null;
        this.permissions = null;
    }

    public Set<Set<String>> getRequireRoles() {
        if (this.role != null) {
            return this.role.require;
        }
        return null;
    }

    public void setRequireRoles(Set<Set<String>> requireRoles) {
        if (requireRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.require = requireRoles;
    }

    public Set<Set<String>> getExcludeRoles() {
        if (this.role != null) {
            return this.role.exclude;
        }
        return null;
    }

    public void setExcludeRoles(Set<Set<String>> excludeRoles) {
        if (excludeRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.exclude = excludeRoles;
    }

    public Set<Set<String>> getRequirePermissions() {
        if (this.permissions != null) {
            return this.permissions.require;
        }
        return null;
    }

    public void setRequirePermissions(Set<Set<String>> requirePermissions) {
        if (requirePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.require = requirePermissions;
    }

    public Set<Set<String>> getExcludePermissions() {
        if (this.permissions != null) {
            return this.permissions.exclude;
        }
        return null;
    }

    public void setExcludePermissions(Set<Set<String>> excludePermissions) {
        if (excludePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.exclude = excludePermissions;
    }

    public void setRequireRoles(Collection<String> requireRoles) {
        if (requireRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.require = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])requireRoles.toArray(new String[0]));
    }

    public void setExcludeRoles(Collection<String> excludeRoles) {
        if (excludeRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.exclude = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])excludeRoles.toArray(new String[0]));
    }

    public void setRequirePermissions(Collection<String> requirePermissions) {
        if (requirePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.require = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])requirePermissions.toArray(new String[0]));
    }

    public void setExcludePermissions(Collection<String> excludePermissions) {
        if (excludePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.exclude = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])excludePermissions.toArray(new String[0]));
    }

    public void merge(PermRolesMeta other) {
        this.setExcludePermissions(other.getExcludePermissions());
        this.setRequirePermissions(other.getRequirePermissions());
        this.setRequireRoles(other.getRequireRoles());
        this.setExcludeRoles(other.getExcludeRoles());
    }

    public String toString() {
        return (this.role != null ? "( role> " + this.role + " )" : "") + (this.permissions != null ? "\t, ( permissions> " + this.permissions + " )" : "");
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Meta {
        private Set<Set<String>> require;
        private Set<Set<String>> exclude;
        private Set<String> range;
        private Set<String> resources;

        public boolean non() {
            return !(this.require != null && this.require.size() != 0 || this.exclude != null && this.exclude.size() != 0);
        }

        public String toString() {
            return (this.require != null ? "require: " + this.require : "") + (this.exclude != null ? "\t, exclude: " + this.exclude : "");
        }

        public Set<Set<String>> getRequire() {
            return this.require;
        }

        public Set<Set<String>> getExclude() {
            return this.exclude;
        }

        public Set<String> getRange() {
            return this.range;
        }

        public Set<String> getResources() {
            return this.resources;
        }

        public Meta setRequire(Set<Set<String>> require) {
            this.require = require;
            return this;
        }

        public Meta setExclude(Set<Set<String>> exclude) {
            this.exclude = exclude;
            return this;
        }

        public Meta setRange(Set<String> range) {
            this.range = range;
            return this;
        }

        public Meta setResources(Set<String> resources) {
            this.resources = resources;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta other = (Meta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Set<String>> this$require = this.getRequire();
            Set<Set<String>> other$require = other.getRequire();
            if (this$require == null ? other$require != null : !((Object)this$require).equals(other$require)) {
                return false;
            }
            Set<Set<String>> this$exclude = this.getExclude();
            Set<Set<String>> other$exclude = other.getExclude();
            if (this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude)) {
                return false;
            }
            Set<String> this$range = this.getRange();
            Set<String> other$range = other.getRange();
            if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
                return false;
            }
            Set<String> this$resources = this.getResources();
            Set<String> other$resources = other.getResources();
            return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Meta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Set<String>> $require = this.getRequire();
            result = result * 59 + ($require == null ? 43 : ((Object)$require).hashCode());
            Set<Set<String>> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            Set<String> $range = this.getRange();
            result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
            Set<String> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            return result;
        }
    }
}

