/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.NotLoginException;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenHelper;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.web.utils.HttpUtils;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AuthzDefender {
    private static UserDevicesDict userDevicesDict;
    private static PermLibrary permLibrary;

    public static void init(UserDevicesDict userDevicesDict, PermLibrary permLibrary) {
        if (AuthzDefender.userDevicesDict == null) {
            AuthzDefender.userDevicesDict = userDevicesDict;
        }
        if (AuthzDefender.permLibrary == null) {
            AuthzDefender.permLibrary = permLibrary;
        }
    }

    public static TokenPair grant(Object userId, String deviceType, String deviceId) {
        TokenPair tokenPair = TokenHelper.createTokenPair(userId, deviceType, deviceId);
        HttpServletResponse response = HttpUtils.getCurrentResponse();
        HttpMeta httpMeta = AUtils.getCurrentHttpMeta();
        if (response != null) {
            response.addCookie(TokenHelper.generateCookie(tokenPair.getAccessToken()));
        }
        try {
            if (userDevicesDict.addUser(userId, tokenPair, deviceType, deviceId, httpMeta)) {
                return tokenPair;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TokenPair refreshToken(String refreshToken) {
        try {
            TokenPair tokenPair = TokenHelper.refreshToken(refreshToken);
            if (userDevicesDict.refreshUser(tokenPair)) {
                HttpServletResponse response = HttpUtils.getCurrentResponse();
                if (response != null) {
                    response.addCookie(TokenHelper.generateCookie(tokenPair.getAccessToken()));
                }
                return tokenPair;
            }
            return null;
        }
        catch (ExpiredJwtException e) {
            return null;
        }
    }

    public static void clearCookie() {
        TokenHelper.clearCookie(HttpUtils.getCurrentResponse());
    }

    public static void clearCookie(Object userId) {
        if (userId == null) {
            TokenHelper.clearCookie(HttpUtils.getCurrentResponse());
        } else {
            Token token = AUtils.getCurrentToken();
            if (token == null) {
                return;
            }
            if (ObjectUtils.equals((Object)token.getUserId(), (Object)userId)) {
                TokenHelper.clearCookie(HttpUtils.getCurrentResponse());
            }
        }
    }

    public static void clearCookie(Object userId, String deviceType) {
        Token token = AUtils.getCurrentToken();
        if (token == null) {
            return;
        }
        if (userId == null) {
            userId = token.getUserId();
        }
        if (ObjectUtils.equals((Object)token.getUserId(), (Object)userId) && StringUtils.equals((String)token.getDeviceType(), (String)deviceType)) {
            AuthzDefender.clearCookie(userId);
        }
    }

    public static void clearCookie(Object userId, String deviceType, String deviceId) {
        Token token = AUtils.getCurrentToken();
        if (token == null) {
            return;
        }
        if (userId == null) {
            userId = token.getUserId();
        }
        if (ObjectUtils.equals((Object)token.getUserId(), (Object)userId) && StringUtils.equals((String)token.getDeviceType(), (String)deviceType) && StringUtils.equals((String)token.getDeviceId(), (String)deviceId)) {
            AuthzDefender.clearCookie();
        }
    }

    public static void logout() {
        userDevicesDict.removeCurrentDeviceFromCurrentUser();
        AuthzDefender.clearCookie(null);
    }

    public static void logoutAll() {
        userDevicesDict.removeAllDeviceFromCurrentUser();
        AuthzDefender.clearCookie(null);
    }

    public static void logout(@NonNull String deviceType) {
        userDevicesDict.removeDeviceFromCurrentUserByDeviceType(deviceType);
        AuthzDefender.clearCookie(null, deviceType);
    }

    public static void logout(@NonNull String deviceType, @Nullable String deviceId) {
        userDevicesDict.removeDeviceFromCurrentUserByDeviceTypeAndDeviceId(deviceType, deviceId);
        AuthzDefender.clearCookie(null, deviceType, deviceType);
    }

    public static void logoutAll(@NonNull Object userId) {
        userDevicesDict.removeAllDeviceByUserId(userId);
        AuthzDefender.clearCookie(userId);
    }

    public static void logout(@NonNull Object userId, @NonNull String deviceType) {
        userDevicesDict.removeDeviceByUserIdAndDeviceType(userId, deviceType);
        AuthzDefender.clearCookie(userId, deviceType);
    }

    public static void logout(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        userDevicesDict.removeDeviceByUserIdAndDeviceTypeAndDeviceId(userId, deviceType, deviceId);
        AuthzDefender.clearCookie(userId, deviceType, deviceId);
    }

    public static boolean isLogin() {
        try {
            HttpMeta currentHttpMeta = AUtils.getCurrentHttpMeta();
            Token accessToken = currentHttpMeta.getToken();
            switch (userDevicesDict.userStatus(accessToken.getUserId(), accessToken.getDeviceType(), accessToken.getDeviceId(), accessToken.getTokenId())) {
                case 1: 
                case 2: 
                case 3: {
                    return false;
                }
                case 0: {
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasRoles(@NonNull List<String> roles) throws NotLoginException {
        HttpMeta httpMeta = AUtils.getCurrentHttpMeta();
        Set<String> r = Optional.ofNullable(httpMeta.getRoles()).orElse(permLibrary.getRolesByUserId(httpMeta.getUserId()));
        if (r == null) {
            return false;
        }
        return r.containsAll(roles);
    }

    public static boolean hasPermissions(@NonNull List<String> permissions) throws NotLoginException {
        HttpMeta httpMeta = AUtils.getCurrentHttpMeta();
        Set<String> r = Optional.ofNullable(httpMeta.getRoles()).orElse(permLibrary.getRolesByUserId(httpMeta.getUserId()));
        Set p = Optional.ofNullable(httpMeta.getPermissions()).orElseGet(() -> {
            HashSet perms = new HashSet();
            r.forEach(role -> perms.addAll(permLibrary.getPermissionsByRole((String)role)));
            return perms;
        });
        if (p == null) {
            return false;
        }
        return p.containsAll(permissions);
    }

    public static void logs(String status, HttpMeta httpMeta, PermRolesMeta meta) {
        Token token = httpMeta.getToken();
        if (token == null) {
            httpMeta.log("\u300c{}\u300d\t{}", status, meta);
        } else {
            httpMeta.log("\u300c{}\u300d\t\t{}\t, userId: [{}]\t, deviceType = {}\t, deviceId = {}", status, meta, token.getUserId(), token.getDeviceType(), token.getDeviceId());
        }
    }

    public static void logs(String status, HttpMeta httpMeta) {
        Token token = httpMeta.getToken();
        if (token == null) {
            httpMeta.log("\u300c{}\u300d", status);
        } else {
            httpMeta.log("\u300c{}\u300d\t, userId: [{}]\t, deviceType = {}\t, deviceId = {}", status, token.getUserId(), token.getDeviceType(), token.getDeviceId());
        }
    }
}

