/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.Constants;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class LimitMeta {
    private final long window;
    private final int maxRequests;
    private final long minInterval;
    private final RateLimit.CheckType checkType;
    private final List<AssociatedPattern> associatedPatterns;
    private final List<Long> punishmentTime = new ArrayList<Long>();

    public LimitMeta(String window, int maxRequests, String[] punishmentTime, String minInterval, String[] associatedPatterns, RateLimit.CheckType checkType) {
        this.window = TimeUtils.parseTimeValue((String)window);
        this.maxRequests = maxRequests;
        this.checkType = checkType;
        Arrays.stream(punishmentTime).forEach(val -> this.punishmentTime.add(TimeUtils.parseTimeValue((String)val)));
        Collections.sort(this.punishmentTime);
        this.minInterval = TimeUtils.parseTimeValue((String)minInterval);
        if (associatedPatterns.length > 0) {
            this.associatedPatterns = new ArrayList<AssociatedPattern>();
            for (String info : associatedPatterns) {
                AssociatedPattern associatedPattern = new AssociatedPattern(info);
                int i = this.associatedPatterns.indexOf(associatedPattern);
                if (i == -1) {
                    this.associatedPatterns.add(associatedPattern);
                    continue;
                }
                AssociatedPattern existedAssociatedPattern = this.associatedPatterns.get(i);
                existedAssociatedPattern.mergeMethods(associatedPattern);
            }
        } else {
            this.associatedPatterns = null;
        }
    }

    public List<AssociatedPattern> getAssociatedPatterns() {
        if (this.associatedPatterns == null) {
            return null;
        }
        return Collections.unmodifiableList(this.associatedPatterns);
    }

    public List<Long> getPunishmentTime() {
        return Collections.unmodifiableList(this.punishmentTime);
    }

    public long getWindow() {
        return this.window;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public long getMinInterval() {
        return this.minInterval;
    }

    public RateLimit.CheckType getCheckType() {
        return this.checkType;
    }

    public static class AssociatedPattern {
        private final Set<String> methods;
        private final String pattern;

        public AssociatedPattern(String info) {
            String[] split = info.split(" ");
            if (split.length > 1) {
                this.pattern = split[split.length - 1];
                this.methods = Arrays.stream(Arrays.copyOf(split, split.length - 1)).map(String::toUpperCase).map(this::mtsFn).flatMap(Arrays::stream).collect(Collectors.toSet());
            } else {
                this.pattern = split[0];
                this.methods = CollectionUtils.ofSet((Object[])new String[]{"GET"});
            }
        }

        public String[] mtsFn(String mts) {
            if (mts.equals("*")) {
                return Constants.METHODS;
            }
            return new String[]{mts};
        }

        public void mergeMethods(AssociatedPattern other) {
            this.methods.addAll(other.methods);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssociatedPattern that = (AssociatedPattern)o;
            return Objects.equal((Object)this.pattern, (Object)that.pattern);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.pattern});
        }

        public Set<String> getMethods() {
            return this.methods;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

