/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.auth.AuthzModifiable;
import cn.omisheep.authz.core.auth.AuthzModifier;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.ipf.RequestMeta;
import cn.omisheep.authz.core.callback.RateLimitCallback;
import cn.omisheep.authz.core.msg.RequestMessage;
import cn.omisheep.web.entity.Result;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class Httpd
implements AuthzModifiable {
    private static final HashMap<String, PathPattern> pathMatcherMap = new HashMap();
    private String[] ignoreSuffix;
    private final RequestPools ipRequestPools = new RequestPools();
    private final RequestPools userIdRequestPools = new RequestPools();
    private final Map<String, Map<String, LimitMeta>> rateLimitMetadata = new HashMap<String, Map<String, LimitMeta>>();
    @JsonIgnore
    private final HashMap<LimitMeta, List<RequestPool>> associatedIpPoolsCache = new HashMap();

    public LimitMeta getLimitMetadata(String method, String api) {
        Map<String, LimitMeta> limitMetaMap = this.rateLimitMetadata.get(method);
        if (limitMetaMap == null) {
            return null;
        }
        return limitMetaMap.get(api);
    }

    public void setPathPattern(String pattern) {
        pathMatcherMap.put(pattern, PathPatternParser.defaultInstance.parse(pattern));
    }

    public boolean match(String pattern, String path) {
        PathPattern pathPattern = pathMatcherMap.get(pattern);
        if (pathPattern == null) {
            return false;
        }
        return pathPattern.matches(PathContainer.parsePath((String)path));
    }

    public String getPattern(String path) {
        for (Map.Entry<String, PathPattern> entry : pathMatcherMap.entrySet()) {
            if (!entry.getValue().matches(PathContainer.parsePath((String)path))) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getPattern(String method, String path) {
        if (this.ipRequestPools.get(method) == null) {
            return null;
        }
        for (Map.Entry<String, PathPattern> entry : pathMatcherMap.entrySet()) {
            if (!entry.getValue().matches(PathContainer.parsePath((String)path))) continue;
            RequestPool requestPool = (RequestPool)((ConcurrentHashMap)this.ipRequestPools.get(method)).get(entry.getKey());
            if (requestPool == null) {
                return null;
            }
            return entry.getKey();
        }
        return null;
    }

    public void receive(RequestMessage requestMessage) {
        String api = requestMessage.getApi();
        String method = requestMessage.getMethod();
        String ip = requestMessage.getIp();
        long now = requestMessage.getNow();
        Object userId = requestMessage.getUserId();
        LimitMeta limitMeta = this.getLimitMetadata(method, api);
        if (limitMeta == null) {
            return;
        }
        try {
            RequestMeta requestMeta;
            RateLimit.CheckType checkType = limitMeta.getCheckType();
            if (checkType.equals((Object)RateLimit.CheckType.USER_ID) && userId == null) {
                return;
            }
            RequestPool ipRequestPool = (RequestPool)((ConcurrentHashMap)this.ipRequestPools.get(method)).get(api);
            RequestPool userIdRequestPool = (RequestPool)((ConcurrentHashMap)this.userIdRequestPools.get(method)).get(api);
            RequestMeta requestMeta2 = requestMeta = checkType.equals((Object)RateLimit.CheckType.IP) ? (RequestMeta)ipRequestPool.get(ip) : (RequestMeta)userIdRequestPool.get(userId.toString());
            if (requestMeta == null) {
                if (checkType.equals((Object)RateLimit.CheckType.IP)) {
                    ipRequestPool.put(ip, new RequestMeta(now, ip, null));
                } else {
                    userIdRequestPool.put(userId.toString(), new RequestMeta(now, null, userId));
                }
            } else if (!requestMeta.pushRequest(now, limitMeta)) {
                this.forbid(now, requestMeta, limitMeta, method, api);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<RequestPool> associatedIpPools(LimitMeta limitMeta) {
        List<RequestPool> rps = this.associatedIpPoolsCache.get(limitMeta);
        if (rps != null) {
            return rps;
        }
        List<LimitMeta.AssociatedPattern> associatedPatterns = limitMeta.getAssociatedPatterns();
        RateLimit.CheckType checkType = limitMeta.getCheckType();
        ArrayList<RequestPool> oIpPools = new ArrayList<RequestPool>();
        if (associatedPatterns != null) {
            associatedPatterns.forEach(associatedPattern -> associatedPattern.getMethods().forEach(meth -> {
                RequestPools requestPools = checkType.equals((Object)RateLimit.CheckType.IP) ? this.ipRequestPools : this.userIdRequestPools;
                ConcurrentHashMap map = (ConcurrentHashMap)requestPools.get(meth);
                if (map != null) {
                    map.keySet().stream().filter(path -> this.match(associatedPattern.getPattern(), (String)path)).forEach(path -> oIpPools.add((RequestPool)map.get(path)));
                }
            }));
        }
        this.associatedIpPoolsCache.put(limitMeta, oIpPools);
        return oIpPools;
    }

    public void forbid(long now, RequestMeta requestMeta, LimitMeta limitMeta, String method, String api) {
        requestMeta.forbidden(method, api, limitMeta);
        String ip = requestMeta.getIp();
        Object userId = requestMeta.getUserId();
        for (RequestPool ipPool : this.associatedIpPools(limitMeta)) {
            if (!ipPool.containsKey(ip)) {
                ipPool.put(ip, new RequestMeta(now, ip, userId).forbidden(method, api, limitMeta));
                continue;
            }
            ((RequestMeta)ipPool.get(ip)).forbidden(method, api, limitMeta);
        }
    }

    public void relive(RequestMeta requestMeta, LimitMeta limitMeta, String method, String api) {
        String ip = requestMeta.getIp();
        requestMeta.relive(method, api, limitMeta);
        this.associatedIpPools(limitMeta).forEach(ipPool -> {
            if (ipPool.containsKey(ip)) {
                ((RequestMeta)ipPool.get(ip)).relive(method, api, limitMeta);
            }
        });
    }

    @Override
    @Nullable
    public synchronized Object modify(@NonNull AuthzModifier authzModifier) {
        try {
            switch (authzModifier.getOperate()) {
                case ADD: 
                case MODIFY: 
                case UPDATE: {
                    AuthzModifier.RateLimitInfo rateLimit = authzModifier.getRateLimit();
                    LimitMeta limitMeta = new LimitMeta(rateLimit.getWindow(), rateLimit.getMaxRequests(), rateLimit.getPunishmentTime().toArray(new String[0]), rateLimit.getMinInterval(), rateLimit.getAssociatedPatterns().toArray(new String[0]), rateLimit.getCheckType());
                    this.rateLimitMetadata.get(authzModifier.getMethod()).put(authzModifier.getApi(), limitMeta);
                    return limitMeta;
                }
                case DEL: 
                case DELETE: {
                    return this.rateLimitMetadata.get(authzModifier.getMethod()).remove(authzModifier.getApi());
                }
                case READ: 
                case GET: {
                    return this.rateLimitMetadata.get(authzModifier.getMethod()).get(authzModifier.getApi());
                }
            }
            return Result.FAIL;
        }
        catch (Exception e) {
            return Result.FAIL;
        }
    }

    public static void setRateLimitCallback(RateLimitCallback callback) {
        RequestMeta.setCallback(callback);
    }

    public String[] getIgnoreSuffix() {
        return this.ignoreSuffix;
    }

    public void setIgnoreSuffix(String[] ignoreSuffix) {
        this.ignoreSuffix = ignoreSuffix;
    }

    public RequestPools getIpRequestPools() {
        return this.ipRequestPools;
    }

    public RequestPools getUserIdRequestPools() {
        return this.userIdRequestPools;
    }

    public Map<String, Map<String, LimitMeta>> getRateLimitMetadata() {
        return this.rateLimitMetadata;
    }

    public static class RequestPool
    extends ConcurrentHashMap<String, RequestMeta> {
        private static final long serialVersionUID = -284927742264879191L;
    }

    public static class RequestPools
    extends HashMap<String, ConcurrentHashMap<String, RequestPool>> {
        private static final long serialVersionUID = -1838299980303412207L;
    }
}

