/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.core.AuthzException;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.web.utils.HttpUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.StringUtils;

public class HttpMeta {
    @JsonIgnore
    private final HttpServletRequest request;
    private final String ip;
    private final String uri;
    private final String api;
    private String servletPath;
    private final String method;
    private final String userAgent;
    private final String refer;
    private String body;
    private final Date now;
    private Token token;
    private Object userId;
    private boolean hasToken;
    private Set<String> roles;
    private Set<String> permissions;
    private boolean requireProtect;
    private boolean requireLogin;
    private PermRolesMeta permRolesMeta;
    private boolean ignore = false;
    @JsonIgnore
    private LinkedList<Object> exceptionObjectList = new LinkedList();
    @JsonIgnore
    private LinkedList<ExceptionStatus> exceptionStatusList = new LinkedList();

    public HttpMeta setRoles(Set<String> roles) {
        if (roles == null) {
            return this;
        }
        this.roles = roles;
        return this;
    }

    public HttpMeta setPermissions(Set<String> permissions) {
        if (permissions == null) {
            return this;
        }
        this.permissions = permissions;
        return this;
    }

    public static Token currentToken() {
        try {
            return ((HttpMeta)HttpUtils.getCurrentRequest().getAttribute((String)"AU_HTTP_META")).token;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object currentUserId() {
        try {
            return HttpMeta.currentToken().getUserId();
        }
        catch (Exception e) {
            return null;
        }
    }

    public HttpMeta error(AuthzException authzException) {
        if (authzException == null) {
            return this;
        }
        return this.error(authzException.getExceptionStatus());
    }

    public HttpMeta error(ExceptionStatus exceptionStatus) {
        if (exceptionStatus != null) {
            this.exceptionStatusList.add(exceptionStatus);
        }
        return this;
    }

    public HttpMeta clearError() {
        this.exceptionStatusList.clear();
        return this;
    }

    public void log(String formatMsg, Object ... args) {
        LogUtils.pushLogToRequest(LogLevel.INFO, formatMsg, args);
    }

    public void log(LogLevel logLevel, String formatMsg, Object ... args) {
        LogUtils.pushLogToRequest(logLevel, formatMsg, args);
    }

    public void exportLog() {
        LogUtils.exportLogsFromRequest(this.request);
    }

    public boolean setHasToken(boolean hasToken) {
        this.hasToken = hasToken;
        return hasToken;
    }

    public String getBody() {
        if (!"POST".equals(this.method) || StringUtils.startsWithIgnoreCase((String)this.request.getContentType(), (String)"multipart/")) {
            return null;
        }
        if (this.body == null) {
            try {
                this.body = new BufferedReader(new InputStreamReader((InputStream)this.request.getInputStream())).lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (IOException e) {
                LogUtils.logError("read body error", new Object[0]);
                return null;
            }
        }
        return this.body;
    }

    public void setToken(Token token) {
        if (this.token == null) {
            this.token = token;
            this.userId = token.getUserId();
        }
    }

    public HttpMeta(HttpServletRequest request, String ip, String uri, String api, String method, Date now) {
        this.request = request;
        this.refer = request.getHeader("Referer");
        this.ip = ip;
        this.uri = uri;
        this.api = api;
        this.method = method.toUpperCase();
        this.userAgent = request.getHeader("user-agent");
        this.now = now;
    }

    public boolean isMethod(String method) {
        if (method != null) {
            return this.method.equals(method.toUpperCase());
        }
        return false;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUri() {
        return this.uri;
    }

    public String getApi() {
        return this.api;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRefer() {
        return this.refer;
    }

    public Date getNow() {
        return this.now;
    }

    public Token getToken() {
        return this.token;
    }

    public Object getUserId() {
        return this.userId;
    }

    public boolean isHasToken() {
        return this.hasToken;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public boolean isRequireProtect() {
        return this.requireProtect;
    }

    public boolean isRequireLogin() {
        return this.requireLogin;
    }

    public PermRolesMeta getPermRolesMeta() {
        return this.permRolesMeta;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public LinkedList<Object> getExceptionObjectList() {
        return this.exceptionObjectList;
    }

    public LinkedList<ExceptionStatus> getExceptionStatusList() {
        return this.exceptionStatusList;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setUserId(Object userId) {
        this.userId = userId;
    }

    public void setRequireProtect(boolean requireProtect) {
        this.requireProtect = requireProtect;
    }

    public void setRequireLogin(boolean requireLogin) {
        this.requireLogin = requireLogin;
    }

    public void setPermRolesMeta(PermRolesMeta permRolesMeta) {
        this.permRolesMeta = permRolesMeta;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @JsonIgnore
    public void setExceptionObjectList(LinkedList<Object> exceptionObjectList) {
        this.exceptionObjectList = exceptionObjectList;
    }

    @JsonIgnore
    public void setExceptionStatusList(LinkedList<ExceptionStatus> exceptionStatusList) {
        this.exceptionStatusList = exceptionStatusList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMeta)) {
            return false;
        }
        HttpMeta other = (HttpMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasToken() != other.isHasToken()) {
            return false;
        }
        if (this.isRequireProtect() != other.isRequireProtect()) {
            return false;
        }
        if (this.isRequireLogin() != other.isRequireLogin()) {
            return false;
        }
        if (this.isIgnore() != other.isIgnore()) {
            return false;
        }
        HttpServletRequest this$request = this.getRequest();
        HttpServletRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$servletPath = this.getServletPath();
        String other$servletPath = other.getServletPath();
        if (this$servletPath == null ? other$servletPath != null : !this$servletPath.equals(other$servletPath)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$refer = this.getRefer();
        String other$refer = other.getRefer();
        if (this$refer == null ? other$refer != null : !this$refer.equals(other$refer)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Date this$now = this.getNow();
        Date other$now = other.getNow();
        if (this$now == null ? other$now != null : !((Object)this$now).equals(other$now)) {
            return false;
        }
        Token this$token = this.getToken();
        Token other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Object this$userId = this.getUserId();
        Object other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Set<String> this$permissions = this.getPermissions();
        Set<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        PermRolesMeta this$permRolesMeta = this.getPermRolesMeta();
        PermRolesMeta other$permRolesMeta = other.getPermRolesMeta();
        if (this$permRolesMeta == null ? other$permRolesMeta != null : !this$permRolesMeta.equals(other$permRolesMeta)) {
            return false;
        }
        LinkedList<Object> this$exceptionObjectList = this.getExceptionObjectList();
        LinkedList<Object> other$exceptionObjectList = other.getExceptionObjectList();
        if (this$exceptionObjectList == null ? other$exceptionObjectList != null : !((Object)this$exceptionObjectList).equals(other$exceptionObjectList)) {
            return false;
        }
        LinkedList<ExceptionStatus> this$exceptionStatusList = this.getExceptionStatusList();
        LinkedList<ExceptionStatus> other$exceptionStatusList = other.getExceptionStatusList();
        return !(this$exceptionStatusList == null ? other$exceptionStatusList != null : !((Object)this$exceptionStatusList).equals(other$exceptionStatusList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasToken() ? 79 : 97);
        result = result * 59 + (this.isRequireProtect() ? 79 : 97);
        result = result * 59 + (this.isRequireLogin() ? 79 : 97);
        result = result * 59 + (this.isIgnore() ? 79 : 97);
        HttpServletRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $servletPath = this.getServletPath();
        result = result * 59 + ($servletPath == null ? 43 : $servletPath.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $refer = this.getRefer();
        result = result * 59 + ($refer == null ? 43 : $refer.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Date $now = this.getNow();
        result = result * 59 + ($now == null ? 43 : ((Object)$now).hashCode());
        Token $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Object $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Set<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        PermRolesMeta $permRolesMeta = this.getPermRolesMeta();
        result = result * 59 + ($permRolesMeta == null ? 43 : $permRolesMeta.hashCode());
        LinkedList<Object> $exceptionObjectList = this.getExceptionObjectList();
        result = result * 59 + ($exceptionObjectList == null ? 43 : ((Object)$exceptionObjectList).hashCode());
        LinkedList<ExceptionStatus> $exceptionStatusList = this.getExceptionStatusList();
        result = result * 59 + ($exceptionStatusList == null ? 43 : ((Object)$exceptionStatusList).hashCode());
        return result;
    }

    public String toString() {
        return "HttpMeta(request=" + this.getRequest() + ", ip=" + this.getIp() + ", uri=" + this.getUri() + ", api=" + this.getApi() + ", servletPath=" + this.getServletPath() + ", method=" + this.getMethod() + ", userAgent=" + this.getUserAgent() + ", refer=" + this.getRefer() + ", body=" + this.getBody() + ", now=" + this.getNow() + ", token=" + this.getToken() + ", userId=" + this.getUserId() + ", hasToken=" + this.isHasToken() + ", roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ", requireProtect=" + this.isRequireProtect() + ", requireLogin=" + this.isRequireLogin() + ", permRolesMeta=" + this.getPermRolesMeta() + ", ignore=" + this.isIgnore() + ", exceptionObjectList=" + this.getExceptionObjectList() + ", exceptionStatusList=" + this.getExceptionStatusList() + ")";
    }
}

