/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.util.Utils;
import cn.omisheep.web.utils.BufferedServletRequestWrapper;
import cn.omisheep.web.utils.HttpUtils;
import java.io.IOException;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthzHttpFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthzHttpFilter.class);
    private final Httpd httpd;
    private final boolean isDashboard;
    private final String mappings;
    private static final String UNKNOWN = "unknown";
    private static final String X_FORWARDED_FOR = "x-forwarded-for";
    private static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    private static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
    private static final String HTTP_CLIENT_IP = "HTTP_CLIENT_IP";
    private static final String HTTP_X_FORWARDED_FOR = "HTTP_X_FORWARDED_FOR";
    private static final String X_REAL_IP = "X-Real-IP";

    public AuthzHttpFilter(Httpd httpd, boolean isDashboard, String mappings) {
        this.httpd = httpd;
        this.isDashboard = isDashboard;
        String val = mappings.substring(0, mappings.indexOf("/*"));
        this.mappings = !mappings.startsWith("/") ? "/" + val : val;
    }

    public void doFilterInternal(HttpServletRequest rrequest, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object request = StringUtils.startsWithIgnoreCase((String)rrequest.getContentType(), (String)"multipart/") ? rrequest : new BufferedServletRequestWrapper(rrequest);
        String ip = this.getIp((HttpServletRequest)request);
        String uri = request.getRequestURI();
        String method = request.getMethod();
        long now = new Date().getTime();
        String servletPath = request.getServletPath();
        HttpUtils.request.set(request);
        if (Utils.isIgnoreSuffix(uri, this.httpd.getIgnoreSuffix()) || this.isDashboard && uri.startsWith(this.mappings)) {
            HttpMeta httpMeta = new HttpMeta((HttpServletRequest)request, ip, uri, servletPath, method, new Date());
            httpMeta.setIgnore(true);
            request.setAttribute("AU_HTTP_META", (Object)httpMeta);
            httpMeta.setServletPath(servletPath);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String api = this.httpd.getPattern(method, servletPath);
        HttpMeta httpMeta = new HttpMeta((HttpServletRequest)request, ip, uri, api == null ? servletPath : api, method, new Date());
        if (api == null) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee(uri\u4e0d\u5b58\u5728)\u300d \tmethod: [{}] , ip : [{}] , servletPath: [{}]   ", method, ip, servletPath);
            httpMeta.error(ExceptionStatus.MISMATCHED_URL);
        }
        httpMeta.setServletPath(servletPath);
        request.setAttribute("AU_HTTP_META", (Object)httpMeta);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getIp(HttpServletRequest request) {
        String ip;
        block8: {
            block7: {
                ip = request.getHeader(X_FORWARDED_FOR);
                if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) break block7;
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(PROXY_CLIENT_IP);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(WL_PROXY_CLIENT_IP);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(HTTP_CLIENT_IP);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(HTTP_X_FORWARDED_FOR);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(X_REAL_IP);
                }
                if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) break block8;
                ip = request.getRemoteAddr();
                break block8;
            }
            if (ip.length() > 15) {
                String[] ips;
                for (String strIp : ips = ip.split(",")) {
                    if (UNKNOWN.equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }
}

