/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.deviced;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.deviced.AccessInfo;
import cn.omisheep.authz.core.auth.deviced.DefaultDevice;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.DeviceConfig;
import cn.omisheep.authz.core.auth.deviced.RefreshInfo;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UserDevicesDictByHashMap
extends DeviceConfig
implements UserDevicesDict {
    private final AuthzProperties properties;
    private final Map<Object, Map<String, AccessInfo>> usersAccessInfoHeap = new ConcurrentHashMap<Object, Map<String, AccessInfo>>();
    private final Map<Object, Map<String, RefreshInfo>> usersRefreshInfoHeap = new ConcurrentHashMap<Object, Map<String, RefreshInfo>>();

    public UserDevicesDictByHashMap(AuthzProperties properties) {
        this.properties = properties;
    }

    @Override
    public int userStatus(Object userId, String deviceType, String deviceId, String accessTokenId) {
        this.inertDeletion(userId);
        Map<String, AccessInfo> accessInfoHeap = this.usersAccessInfoHeap.get(userId);
        Map<String, RefreshInfo> refreshInfoHeap = this.usersRefreshInfoHeap.get(userId);
        boolean hasTargetDeviceInfo = false;
        if (refreshInfoHeap != null) {
            hasTargetDeviceInfo = refreshInfoHeap.entrySet().stream().anyMatch(entry -> {
                Device device = (Device)entry.getValue();
                return StringUtils.equals((String)deviceId, (String)device.getId()) && StringUtils.equals((String)deviceType, (String)device.getType());
            });
        }
        if (accessInfoHeap == null || accessInfoHeap.isEmpty()) {
            if (refreshInfoHeap == null || !hasTargetDeviceInfo) {
                return 2;
            }
            return 1;
        }
        Map.Entry d = accessInfoHeap.entrySet().stream().filter(entry -> {
            String refreshTokenId = ((AccessInfo)entry.getValue()).getRefreshTokenId();
            if (refreshInfoHeap != null) {
                Device device = (Device)refreshInfoHeap.get(refreshTokenId);
                return StringUtils.equals((String)deviceId, (String)device.getId()) && StringUtils.equals((String)deviceType, (String)device.getType());
            }
            return false;
        }).findFirst().orElse(null);
        if (d == null) {
            if (!isSupportMultiDevice) {
                return 3;
            }
            if (!hasTargetDeviceInfo) {
                return 2;
            }
            return 1;
        }
        if (!StringUtils.equals((String)((String)d.getKey()), (String)accessTokenId)) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean addUser(Object userId, TokenPair tokenPair, String deviceType, String deviceId, HttpMeta httpMeta) {
        this.inertDeletion(userId);
        Map accessInfoHeap = this.usersAccessInfoHeap.computeIfAbsent(userId, k -> new ConcurrentHashMap());
        Map refreshInfoHeap = this.usersRefreshInfoHeap.computeIfAbsent(userId, k -> new ConcurrentHashMap());
        DefaultDevice device = new DefaultDevice();
        device.setType(deviceType).setId(deviceId).setLastRequestTime(TimeUtils.now()).setIp(httpMeta.getIp());
        if (!isSupportMultiDevice) {
            accessInfoHeap.clear();
            refreshInfoHeap.clear();
        } else {
            if (!isSupportMultiUserForSameDeviceType) {
                accessInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)this.getRefreshInfo(refreshInfoHeap, (AccessInfo)entry.getValue()).getType(), (String)device.getType()));
                refreshInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)((RefreshInfo)entry.getValue()).getType(), (String)device.getType()));
            }
            accessInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)this.getRefreshInfo(refreshInfoHeap, (AccessInfo)entry.getValue()).getId(), (String)device.getId()));
            refreshInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)((RefreshInfo)entry.getValue()).getId(), (String)device.getId()));
        }
        Token accessToken = tokenPair.getAccessToken();
        Token refreshToken = tokenPair.getRefreshToken();
        accessInfoHeap.put(accessToken.getTokenId(), new AccessInfo().setRefreshTokenId(refreshToken.getTokenId()).setExpiration(accessToken.getExpiredTime()));
        refreshInfoHeap.put(refreshToken.getTokenId(), new RefreshInfo().setDevice(device).setExpiration(TimeUtils.datePlus((Date)refreshToken.getExpiredTime(), (String)this.properties.getToken().getLiveTime())));
        return true;
    }

    @Override
    public boolean refreshUser(TokenPair tokenPair) {
        if (tokenPair == null) {
            return false;
        }
        Token accessToken = tokenPair.getAccessToken();
        this.inertDeletion(accessToken.getUserId());
        Token refreshToken = tokenPair.getRefreshToken();
        Map refreshInfoHeap = this.usersRefreshInfoHeap.computeIfAbsent(accessToken.getUserId(), k -> new ConcurrentHashMap());
        if (!refreshInfoHeap.containsKey(refreshToken.getTokenId())) {
            return false;
        }
        Map accessInfoHeap = this.usersAccessInfoHeap.computeIfAbsent(accessToken.getUserId(), k -> new ConcurrentHashMap());
        Map.Entry d = accessInfoHeap.entrySet().stream().filter(entry -> {
            Device device = (Device)refreshInfoHeap.get(((AccessInfo)entry.getValue()).getRefreshTokenId());
            return StringUtils.equals((String)accessToken.getDeviceId(), (String)device.getId()) && StringUtils.equals((String)accessToken.getDeviceType(), (String)device.getType());
        }).findFirst().orElse(null);
        HttpMeta httpMeta = (HttpMeta)((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getAttribute("AU_HTTP_META");
        RefreshInfo refreshInfo = (RefreshInfo)refreshInfoHeap.get(tokenPair.getRefreshToken().getTokenId());
        if (refreshInfo != null) {
            refreshInfo.setIp(httpMeta.getIp());
            refreshInfo.setLastRequestTime(TimeUtils.now());
        }
        if (d != null) {
            accessInfoHeap.remove(d.getKey());
        }
        accessInfoHeap.put(accessToken.getTokenId(), new AccessInfo().setExpiration(accessToken.getExpiredTime()).setRefreshTokenId(refreshToken.getTokenId()));
        return true;
    }

    @Override
    public void removeDeviceByUserIdAndAccessTokenId(Object userId, String accessTokenId) {
        Map<String, AccessInfo> accessInfoHeap = this.usersAccessInfoHeap.get(userId);
        if (accessInfoHeap != null) {
            accessInfoHeap.remove(accessTokenId);
        }
        this.inertDeletion(userId);
    }

    @Override
    public void removeAllDeviceByUserId(Object userId) {
        this.usersAccessInfoHeap.remove(userId);
        this.usersRefreshInfoHeap.remove(userId);
    }

    @Override
    public void removeDeviceByUserIdAndDeviceType(Object userId, String deviceType) {
        this.removeDevice(userId, deviceType);
    }

    @Override
    public void removeDeviceByUserIdAndDeviceTypeAndDeviceId(Object userId, String deviceType, String deviceId) {
        this.removeDevice(userId, deviceType, deviceId);
    }

    @Override
    public void removeAllDeviceFromCurrentUser() {
        try {
            this.removeAllDeviceByUserId(AUtils.getCurrentHttpMeta().getToken().getUserId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeCurrentDeviceFromCurrentUser() {
        try {
            Token token = AUtils.getCurrentHttpMeta().getToken();
            this.removeDevice(token.getUserId(), token.getDeviceType(), token.getDeviceId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeDeviceFromCurrentUserByDeviceType(String deviceType) {
        try {
            this.removeDevice(AUtils.getCurrentHttpMeta().getToken().getUserId(), deviceType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeDeviceFromCurrentUserByDeviceTypeAndDeviceId(String deviceType, String deviceId) {
        try {
            this.removeDevice(AUtils.getCurrentHttpMeta().getToken().getUserId(), deviceType, deviceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeDevice(Object userId, String deviceType) {
        Map accessInfoHeap = this.usersAccessInfoHeap.computeIfAbsent(userId, k -> new ConcurrentHashMap());
        Map refreshInfoHeap = this.usersRefreshInfoHeap.computeIfAbsent(userId, k -> new ConcurrentHashMap());
        if (deviceType != null) {
            accessInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)this.getRefreshInfo(refreshInfoHeap, (AccessInfo)entry.getValue()).getType(), (String)deviceType));
            refreshInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)((RefreshInfo)entry.getValue()).getType(), (String)deviceType));
        }
        this.inertDeletion(userId);
    }

    private void removeDevice(Object userId, String deviceType, String deviceId) {
        Map accessInfoHeap = this.usersAccessInfoHeap.computeIfAbsent(userId, k -> new ConcurrentHashMap());
        Map refreshInfoHeap = this.usersRefreshInfoHeap.computeIfAbsent(userId, k -> new ConcurrentHashMap());
        if (deviceType != null) {
            accessInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)this.getRefreshInfo(refreshInfoHeap, (AccessInfo)entry.getValue()).getType(), (String)deviceType) && StringUtils.equals((String)this.getRefreshInfo(refreshInfoHeap, (AccessInfo)entry.getValue()).getId(), (String)deviceId));
            refreshInfoHeap.entrySet().removeIf(entry -> StringUtils.equals((String)((RefreshInfo)entry.getValue()).getType(), (String)deviceType) && StringUtils.equals((String)((RefreshInfo)entry.getValue()).getId(), (String)deviceId));
        }
        this.inertDeletion(userId);
    }

    @Override
    public Device getDevice(Object userId, String deviceType, String deviceId) {
        Map<String, AccessInfo> accessInfoHeap = this.usersAccessInfoHeap.get(userId);
        Map<String, RefreshInfo> refreshInfoHeap = this.usersRefreshInfoHeap.get(userId);
        if (!this.inertDeletion(userId)) {
            return null;
        }
        Map.Entry d = accessInfoHeap.entrySet().stream().filter(entry -> {
            RefreshInfo device = this.getRefreshInfo(refreshInfoHeap, (AccessInfo)entry.getValue());
            return StringUtils.equals((String)deviceId, (String)device.getId()) && StringUtils.equals((String)deviceType, (String)device.getType());
        }).findFirst().orElse(null);
        if (d != null) {
            return this.getRefreshInfo(refreshInfoHeap, (AccessInfo)d.getValue());
        }
        return null;
    }

    @Override
    public List<Object> listUserId() {
        return new ArrayList<Object>(this.usersAccessInfoHeap.keySet());
    }

    @Override
    public List<Device> listDevicesByUserId(Object userId) {
        if (!this.inertDeletion(userId)) {
            return new ArrayList<Device>();
        }
        Map<String, RefreshInfo> refreshInfoHeap = this.usersRefreshInfoHeap.get(userId);
        if (refreshInfoHeap == null) {
            return new ArrayList<Device>();
        }
        return this.usersAccessInfoHeap.get(userId).values().stream().map(v -> (Device)refreshInfoHeap.get(v.getRefreshTokenId())).collect(Collectors.toList());
    }

    @Override
    public List<Device> listDevicesForCurrentUser() {
        try {
            return this.listDevicesByUserId(AUtils.getCurrentHttpMeta().getToken().getUserId());
        }
        catch (Exception ignored) {
            return new ArrayList<Device>();
        }
    }

    @Override
    public List<Object> listActiveUsers(long ms) {
        long now = TimeUtils.nowTime();
        return this.usersRefreshInfoHeap.keySet().stream().filter(userId -> this.usersRefreshInfoHeap.get(userId).values().stream().anyMatch(device -> now - device.getLastRequestTime().getTime() < ms)).collect(Collectors.toList());
    }

    @Override
    public List<Device> listActiveUserDevices(Object userId, long ms) {
        long now = TimeUtils.nowTime();
        Map<String, RefreshInfo> refreshInfoHeap = this.usersRefreshInfoHeap.get(userId);
        if (refreshInfoHeap == null) {
            return new ArrayList<Device>();
        }
        return refreshInfoHeap.values().stream().filter(refreshInfo -> now - refreshInfo.getLastRequestTime().getTime() < ms).map(RefreshInfo::getDevice).collect(Collectors.toList());
    }

    @Override
    public void request() {
        try {
            HttpMeta currentHttpMeta = AUtils.getCurrentHttpMeta();
            Token token = currentHttpMeta.getToken();
            AccessInfo accessInfo = this.usersAccessInfoHeap.get(token.getUserId()).get(token.getTokenId());
            Device device = this.usersRefreshInfoHeap.get(token.getUserId()).get(accessInfo.getRefreshTokenId());
            if (device != null) {
                device.setLastRequestTime(TimeUtils.now());
                device.setIp(currentHttpMeta.getIp());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanCycle() {
        long now = TimeUtils.nowTime();
        this.usersAccessInfoHeap.entrySet().removeIf(entry -> {
            Map value = (Map)entry.getValue();
            if (value == null) {
                return true;
            }
            value.entrySet().removeIf(device -> ((AccessInfo)device.getValue()).getExpirationVal() < now);
            return value.isEmpty();
        });
        this.usersRefreshInfoHeap.entrySet().removeIf(entry -> {
            Map value = (Map)entry.getValue();
            if (value == null) {
                return true;
            }
            value.entrySet().removeIf(device -> ((RefreshInfo)device.getValue()).getExpirationVal() < now);
            return value.isEmpty();
        });
    }

    private boolean inertDeletion(Object userId) {
        Map<String, AccessInfo> accessInfoHeap = this.usersAccessInfoHeap.get(userId);
        Map<String, RefreshInfo> refreshInfoHeap = this.usersRefreshInfoHeap.get(userId);
        long now = TimeUtils.nowTime();
        if (refreshInfoHeap == null || refreshInfoHeap.isEmpty()) {
            this.usersRefreshInfoHeap.remove(userId);
        } else {
            refreshInfoHeap.entrySet().removeIf(entry -> ((RefreshInfo)entry.getValue()).getExpirationVal() < now);
            if (refreshInfoHeap.isEmpty()) {
                this.usersRefreshInfoHeap.remove(userId);
            }
        }
        if (accessInfoHeap == null || accessInfoHeap.isEmpty()) {
            this.usersAccessInfoHeap.remove(userId);
            return false;
        }
        accessInfoHeap.entrySet().removeIf(entry -> ((AccessInfo)entry.getValue()).getExpirationVal() < now);
        if (accessInfoHeap.isEmpty()) {
            this.usersAccessInfoHeap.remove(userId);
            return false;
        }
        return true;
    }

    private RefreshInfo getRefreshInfo(Map<String, RefreshInfo> refreshInfoHeap, AccessInfo accessInfo) {
        if (refreshInfoHeap == null) {
            return new RefreshInfo();
        }
        return refreshInfoHeap.getOrDefault(accessInfo.getRefreshTokenId(), new RefreshInfo());
    }

    public Map<Object, Map<String, AccessInfo>> getUsersAccessInfoHeap() {
        return this.usersAccessInfoHeap;
    }

    public Map<Object, Map<String, RefreshInfo>> getUsersRefreshInfoHeap() {
        return this.usersRefreshInfoHeap;
    }
}

