/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.deviced;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.Constants;
import cn.omisheep.authz.core.auth.deviced.AccessInfo;
import cn.omisheep.authz.core.auth.deviced.DefaultDevice;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.DeviceConfig;
import cn.omisheep.authz.core.auth.deviced.RefreshInfo;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDevicesDictByCache
implements UserDevicesDict {
    private static final Logger log = LoggerFactory.getLogger(UserDevicesDictByCache.class);
    private final AuthzProperties properties;
    private Cache _cache;
    private final Supplier<Cache> cache = () -> {
        if (this._cache == null) {
            this._cache = AUtils.getBean(Cache.class);
        }
        return this._cache;
    };

    public UserDevicesDictByCache(AuthzProperties properties) {
        this.properties = properties;
    }

    @Override
    public int userStatus(Object userId, String deviceType, String deviceId, String accessTokenId) {
        CompletableFuture acSupply = Async.supply(() -> this.cache.get().keysAndLoad(this.acKey(userId, "*")));
        Set<String> refreshInfoKeys = this.cache.get().keysAndLoad(this.rfKey(userId, "*"));
        boolean hasTargetDeviceInfo = false;
        if (!refreshInfoKeys.isEmpty()) {
            hasTargetDeviceInfo = refreshInfoKeys.stream().anyMatch(rfKey -> {
                Device deviceInfo = (Device)this.cache.get().get((String)rfKey);
                return this.equalsDeviceByTypeAndId(deviceInfo, deviceType, deviceId);
            });
        }
        if (!hasTargetDeviceInfo) {
            return 2;
        }
        Set accessInfoKeys = (Set)acSupply.join();
        if (accessInfoKeys.isEmpty()) {
            if (refreshInfoKeys.isEmpty()) {
                return 2;
            }
            return 1;
        }
        String acKey = accessInfoKeys.stream().filter(key -> {
            AccessInfo accessInfo = (AccessInfo)this.cache.get().get((String)key);
            if (accessInfo == null) {
                return true;
            }
            return this.equalsDeviceByTypeAndId((Device)this.cache.get().get(this.rfKey(userId, accessInfo.getRefreshTokenId())), deviceType, deviceId);
        }).findFirst().orElse(null);
        if (acKey == null) {
            if (!DeviceConfig.isSupportMultiDevice) {
                return 3;
            }
            return 1;
        }
        if (!StringUtils.equals((String)acKey, (String)this.acKey(userId, accessTokenId))) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean addUser(Object userId, TokenPair tokenPair, String deviceType, String deviceId, HttpMeta httpMeta) {
        HashSet<String> accessInfoKeys = new HashSet<String>();
        HashSet<String> refreshInfoKeys = new HashSet<String>();
        DefaultDevice device = new DefaultDevice();
        device.setType(deviceType).setId(deviceId);
        Async.combine(() -> accessInfoKeys.addAll(this.cache.get().keysAndLoad(this.acKey(userId, "*"))), () -> refreshInfoKeys.addAll(this.cache.get().keysAndLoad(this.rfKey(userId, "*")))).join();
        HashSet<String> delKeys = new HashSet<String>();
        if (!DeviceConfig.isSupportMultiDevice) {
            delKeys.addAll(accessInfoKeys);
            delKeys.addAll(refreshInfoKeys);
        } else if (!DeviceConfig.isSupportMultiUserForSameDeviceType) {
            accessInfoKeys.removeIf(key -> {
                AccessInfo accessInfo = (AccessInfo)this.cache.get().get((String)key);
                if (accessInfo == null) {
                    return true;
                }
                String rtid = accessInfo.getRefreshTokenId();
                if (rtid == null) {
                    return false;
                }
                String rfKey = this.rfKey(userId, rtid);
                Device deviceInfo = (Device)this.cache.get().get(rfKey);
                if (deviceInfo != null && !this.equalsDeviceByTypeOrId(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(rfKey);
                refreshInfoKeys.remove(rfKey);
                return true;
            });
            refreshInfoKeys.removeIf(key -> {
                Device deviceInfo = (Device)this.cache.get().get((String)key);
                if (deviceInfo != null && !this.equalsDeviceByTypeOrId(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(this.requestKey(userId, (String)key));
                return true;
            });
        } else {
            accessInfoKeys.removeIf(key -> {
                AccessInfo accessInfo = (AccessInfo)this.cache.get().get((String)key);
                if (accessInfo == null) {
                    return true;
                }
                String rtid = accessInfo.getRefreshTokenId();
                if (rtid == null) {
                    return false;
                }
                String rfKey = this.rfKey(userId, rtid);
                Device deviceInfo = (Device)this.cache.get().get(rfKey);
                if (deviceInfo != null && !this.equalsDeviceById(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(rfKey);
                refreshInfoKeys.remove(rfKey);
                return true;
            });
            refreshInfoKeys.removeIf(key -> {
                Device deviceInfo = (Device)this.cache.get().get((String)key);
                if (deviceInfo != null && !this.equalsDeviceById(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(this.requestKey(userId, (String)key));
                return true;
            });
        }
        if (!delKeys.isEmpty()) {
            Async.run(() -> this.cache.get().del(delKeys));
        }
        AccessInfo accessInfo = new AccessInfo().setRefreshTokenId(tokenPair.getRefreshToken().getTokenId());
        RefreshInfo refreshInfo = new RefreshInfo().setDevice(device);
        refreshInfo.setIp(httpMeta.getIp()).setLastRequestTime(httpMeta.getNow());
        long rfLiveTime = TimeUtils.parseTimeValueTotal((String[])new String[]{this.properties.getToken().getLiveTime(), this.properties.getToken().getRefreshTime(), "10s"});
        Async.run(() -> {
            this.cache.get().del(this.acKey(userId, "*"));
            this.cache.get().del(this.rfKey(userId, "*"));
        });
        return Async.joinAndCheck((CompletableFuture)Async.combine(() -> this.cache.get().set(this.acKey(userId, tokenPair), accessInfo, this.properties.getToken().getLiveTime()), () -> this.cache.get().set(this.rfKey(userId, tokenPair), refreshInfo, rfLiveTime, TimeUnit.MILLISECONDS)));
    }

    @Override
    public boolean refreshUser(TokenPair tokenPair) {
        if (tokenPair == null) {
            return false;
        }
        Token accessToken = tokenPair.getAccessToken();
        Object userId = accessToken.getUserId();
        String rfKey = this.rfKey(userId, tokenPair);
        if (this.cache.get().notKey(rfKey)) {
            return false;
        }
        String k = null;
        for (String key : this.cache.get().keysAndLoad(this.acKey(userId, "*"))) {
            Device deviceInfo = this.getDeviceOe(userId, key);
            if (deviceInfo == null || !StringUtils.equals((String)accessToken.getDeviceType(), (String)deviceInfo.getType()) || !StringUtils.equals((String)accessToken.getDeviceId(), (String)deviceInfo.getId())) continue;
            k = key;
            break;
        }
        if (k != null) {
            this.cache.get().del(k);
        }
        AccessInfo accessInfo = new AccessInfo().setRefreshTokenId(tokenPair.getRefreshToken().getTokenId());
        Async.run(() -> {
            this.cache.get().del(this.acKey(userId, "*"));
            this.cache.get().del(this.rfKey(userId, "*"));
        });
        this.cache.get().set(this.acKey(userId, tokenPair), accessInfo, this.properties.getToken().getLiveTime());
        return true;
    }

    @Override
    public void removeDeviceByUserIdAndAccessTokenId(Object userId, String accessTokenId) {
        this.cache.get().del(this.acKey(userId, accessTokenId), this.acKey(userId, "*"));
    }

    @Override
    public void removeAllDeviceByUserId(Object userId) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.cache.get().keys(this.acKey(userId, "*")));
        keys.addAll(this.cache.get().keys(this.rfKey(userId, "*")));
        keys.add(this.acKey(userId, "*"));
        keys.add(this.rfKey(userId, "*"));
        this.cache.get().del(keys);
    }

    @Override
    public void removeDeviceByUserIdAndDeviceType(Object userId, String deviceType) {
        this.removeDevice(userId, deviceType);
    }

    @Override
    public void removeDeviceByUserIdAndDeviceTypeAndDeviceId(Object userId, String deviceType, String deviceId) {
        this.removeDevice(userId, deviceType, deviceId);
    }

    @Override
    public void removeAllDeviceFromCurrentUser() {
        try {
            this.removeAllDeviceByUserId(AUtils.getCurrentHttpMeta().getToken().getUserId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeCurrentDeviceFromCurrentUser() {
        try {
            Token token = AUtils.getCurrentHttpMeta().getToken();
            this.removeDevice(token.getUserId(), token.getDeviceType(), token.getDeviceId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeDeviceFromCurrentUserByDeviceType(String deviceType) {
        try {
            this.removeDevice(AUtils.getCurrentHttpMeta().getToken().getUserId(), deviceType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeDeviceFromCurrentUserByDeviceTypeAndDeviceId(String deviceType, String deviceId) {
        try {
            this.removeDevice(AUtils.getCurrentHttpMeta().getToken().getUserId(), deviceType, deviceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeDevice(Object userId, String deviceType) {
        Set<String> acKeys = this.cache.get().keysAndLoad(this.acKey(userId, "*"));
        Set<String> rfKeys = this.cache.get().keysAndLoad(this.rfKey(userId, "*"));
        HashSet<String> keys = new HashSet<String>();
        keys.add(this.acKey(userId, "*"));
        keys.add(this.rfKey(userId, "*"));
        if (deviceType != null) {
            acKeys.removeIf(acKey -> {
                Device deviceOe = this.getDeviceOe(userId, (String)acKey);
                if (deviceOe != null) {
                    if (this.equalsDeviceByType(deviceOe, deviceType)) {
                        keys.add((String)acKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
            rfKeys.removeIf(rfKey -> {
                Device device = (Device)this.cache.get().get((String)rfKey);
                if (device == null || !device.isEmpty()) {
                    if (this.equalsDeviceByType(device, deviceType)) {
                        keys.add((String)rfKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
        }
        this.cache.get().del(keys);
    }

    private void removeDevice(Object userId, String deviceType, String deviceId) {
        Set<String> acKeys = this.cache.get().keysAndLoad(this.acKey(userId, "*"));
        Set<String> rfKeys = this.cache.get().keysAndLoad(this.rfKey(userId, "*"));
        HashSet<String> keys = new HashSet<String>();
        keys.add(this.acKey(userId, "*"));
        keys.add(this.rfKey(userId, "*"));
        if (deviceType != null) {
            acKeys.removeIf(acKey -> {
                Device deviceOe = this.getDeviceOe(userId, (String)acKey);
                if (deviceOe != null) {
                    if (this.equalsDeviceByTypeAndId(deviceOe, deviceType, deviceId)) {
                        keys.add((String)acKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
            rfKeys.removeIf(rfKey -> {
                Device device = (Device)this.cache.get().get((String)rfKey);
                if (device == null || !device.isEmpty()) {
                    if (this.equalsDeviceByTypeAndId(device, deviceType, deviceId)) {
                        keys.add((String)rfKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
        }
        this.cache.get().del(keys);
    }

    private Device getDeviceOe(Object userId, String acKey) {
        AccessInfo accessInfo = (AccessInfo)this.cache.get().get(acKey);
        if (accessInfo == null) {
            return null;
        }
        String rtid = accessInfo.getRefreshTokenId();
        if (rtid != null) {
            String rfKey = this.rfKey(userId, rtid);
            return (Device)this.cache.get().get(rfKey);
        }
        return null;
    }

    @Override
    public Device getDevice(Object userId, String deviceType, String deviceId) {
        Set<String> acKeys = this.cache.get().keysAndLoad(this.acKey(userId, "*"));
        if (CollectionUtils.isNotEmpty(acKeys)) {
            for (String acKey : acKeys) {
                Device deviceOe = this.getDeviceOe(userId, acKey);
                if (deviceOe == null || !this.equalsDeviceByTypeAndId(deviceOe, deviceType, deviceId)) continue;
                return deviceOe;
            }
        }
        return null;
    }

    @Override
    public List<Object> listUserId() {
        Set<String> keys = this.cache.get().keys(this.acKey((Object)"*", "*"));
        return keys.stream().map(key -> key.split(":")[2]).distinct().collect(Collectors.toList());
    }

    @Override
    public List<Device> listDevicesByUserId(Object userId) {
        Set<String> keys = this.cache.get().keysAndLoad(this.acKey(userId, "*"));
        return keys.stream().map(key -> this.getDeviceOe(userId, (String)key)).collect(Collectors.toList());
    }

    @Override
    public List<Device> listDevicesForCurrentUser() {
        try {
            return this.listDevicesByUserId(AUtils.getCurrentHttpMeta().getToken().getUserId());
        }
        catch (Exception ignored) {
            return new ArrayList<Device>();
        }
    }

    @Override
    public List<Object> listActiveUsers(long ms) {
        long now = TimeUtils.nowTime();
        Set<String> rfKeys = this.cache.get().keysAndLoad(this.rfKey((Object)"*", "*"));
        return rfKeys.stream().filter(rfKey -> {
            Device device = (Device)this.cache.get().get((String)rfKey);
            if (device != null) {
                return now - device.getLastRequestTime().getTime() < ms;
            }
            return false;
        }).map(key -> key.split(":")[2]).distinct().collect(Collectors.toList());
    }

    @Override
    public List<Device> listActiveUserDevices(Object userId, long ms) {
        long now = TimeUtils.nowTime();
        Set<String> rfKeys = this.cache.get().keysAndLoad(this.rfKey(userId, "*"));
        return rfKeys.stream().map(rfKey -> (Device)this.cache.get().get((String)rfKey)).filter(device -> device != null && now - device.getLastRequestTime().getTime() < ms).collect(Collectors.toList());
    }

    @Override
    public void request() {
        try {
            HttpMeta currentHttpMeta = AUtils.getCurrentHttpMeta();
            Token token = currentHttpMeta.getToken();
            String acKey = this.acKey(token.getUserId(), token.getTokenId());
            Object o = this.cache.get().get(acKey);
            if (o == null) {
                return;
            }
            String rtid = ((AccessInfo)o).getRefreshTokenId();
            if (rtid != null) {
                Async.run(() -> {
                    String rfKey = this.rfKey(token.getUserId(), rtid);
                    Device d = (Device)this.cache.get().get(rfKey);
                    if (d != null) {
                        d.setLastRequestTime(currentHttpMeta.getNow());
                        d.setIp(currentHttpMeta.getIp());
                        this.cache.get().set(rfKey, d);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String requestKey(Object userId, String rfKey) {
        return Constants.DEVICE_REQUEST_INFO_KEY_PREFIX.get() + userId + ":" + rfKey.split(":")[3];
    }

    private String acKey(Object userId, String tokenId) {
        return Constants.ACCESS_INFO_KEY_PREFIX.get() + userId + ":" + tokenId;
    }

    private String rfKey(Object userId, String tokenId) {
        return Constants.REFRESH_INFO_KEY_PREFIX.get() + userId + ":" + tokenId;
    }

    private String acKey(Object userId, TokenPair tokenPair) {
        return this.acKey(userId, tokenPair.getAccessToken().getTokenId());
    }

    private String rfKey(Object userId, TokenPair tokenPair) {
        return this.rfKey(userId, tokenPair.getRefreshToken().getTokenId());
    }

    private boolean equalsDeviceByTypeOrId(Device device, Device otherDevice) {
        if (device == null) {
            return false;
        }
        return StringUtils.equals((String)device.getType(), (String)otherDevice.getType()) || device.getId() != null && StringUtils.equals((String)device.getId(), (String)otherDevice.getId());
    }

    private boolean equalsDeviceByTypeAndId(Device device, String deviceType, String deviceId) {
        if (device == null) {
            return false;
        }
        return StringUtils.equals((String)device.getType(), (String)deviceType) && StringUtils.equals((String)device.getId(), (String)deviceId);
    }

    private boolean equalsDeviceById(Device device, Device otherDevice) {
        if (device == null) {
            return false;
        }
        return this.equalsDeviceById(device, otherDevice.getId());
    }

    private boolean equalsDeviceById(Device device, String deviceId) {
        if (device == null) {
            return false;
        }
        return device.getId() != null && StringUtils.equals((String)device.getId(), (String)deviceId);
    }

    private boolean equalsDeviceByType(Device device, String deviceType) {
        if (device == null) {
            return false;
        }
        return StringUtils.equals((String)device.getType(), (String)deviceType);
    }
}

