/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth;

import cn.omisheep.authz.core.Authz;
import cn.omisheep.authz.core.auth.AuthzModifier;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.support.util.IPAddress;
import cn.omisheep.authz.support.util.IPRange;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.web.entity.Result;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import orestes.bloomfilter.CountingBloomFilter;
import orestes.bloomfilter.FilterBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.lang.Nullable;

public class Blacklist {
    private static final List<IP> ipBlacklist = new CopyOnWriteArrayList<IP>();
    private static final CountingBloomFilter<String> ipBlacklistBloomFilter = new FilterBuilder(1000, 0.001).countingBits(8).buildCountingBloomFilter();
    private static final List<User> userBlacklist = new CopyOnWriteArrayList<User>();
    private static final CountingBloomFilter<String> userBlacklistBloomFilter = new FilterBuilder(1000, 0.001).countingBits(8).buildCountingBloomFilter();
    private static final List<IPRangeDeny> ipRangeBlacklist = new CopyOnWriteArrayList<IPRangeDeny>();

    public static boolean check(String ip, Object userId, @Nullable String deviceType, @Nullable String deviceId) {
        return IP.check(ip) && IPRangeDeny.check(ip) && User.check(userId, deviceType, deviceId);
    }

    public static boolean check(String ip, @Nullable Token token) {
        if (token == null) {
            return Blacklist.check(ip);
        }
        return IP.check(ip) && IPRangeDeny.check(ip) && User.check(token.getUserId(), token.getDeviceType(), token.getDeviceId());
    }

    public static boolean check(String ip) {
        return IP.check(ip) && IPRangeDeny.check(ip);
    }

    public static Object modify(AuthzModifier modifier) {
        AuthzModifier.BlacklistInfo blacklistInfo = modifier.getBlacklistInfo();
        String time = blacklistInfo.getTime();
        Long start = blacklistInfo.getStart();
        block0 : switch (blacklistInfo.getType()) {
            case IP: {
                String ip = blacklistInfo.getIp();
                switch (blacklistInfo.getOp()) {
                    case ADD: {
                        IP._add(ip, time, start);
                        break;
                    }
                    case CHANGE: {
                        IP._change(ip, time);
                        break;
                    }
                    case REMOVE: {
                        IP.remove(ip);
                    }
                }
                break;
            }
            case IP_RANGE: {
                String ipRange = blacklistInfo.getIpRange();
                switch (blacklistInfo.getOp()) {
                    case ADD: {
                        IPRangeDeny._add(ipRange, time, start);
                        break;
                    }
                    case CHANGE: {
                        IPRangeDeny._change(ipRange, time);
                        break;
                    }
                    case REMOVE: {
                        IPRangeDeny.remove(ipRange);
                    }
                }
                break;
            }
            case USER: {
                Object userId = blacklistInfo.getUserId();
                String deviceType = blacklistInfo.getDeviceType();
                String deviceId = blacklistInfo.getDeviceId();
                switch (blacklistInfo.getOp()) {
                    case ADD: {
                        User._add(userId, deviceType, deviceId, time, start);
                        break block0;
                    }
                    case CHANGE: {
                        User._change(userId, deviceType, deviceId, time);
                        break block0;
                    }
                    case REMOVE: {
                        User._remove(userId, deviceType, deviceId);
                    }
                }
            }
        }
        return Result.SUCCESS;
    }

    public static class TimeMeta {
        final long start;
        long time;
        long end;

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public Date getStart() {
            return new Date(this.start);
        }

        public String getTime() {
            return TimeUtils.parseTime((long)this.time);
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public Date getEnd() {
            return new Date(this.end);
        }

        private TimeMeta(String time, long now) {
            this.start = now;
            this.time = TimeUtils.parseTimeValue((String)time);
            this.end = this.start + this.time;
        }

        private static TimeMeta of(String time, long now) {
            return new TimeMeta(time, now);
        }

        private void changeTime(String time) {
            this.time = TimeUtils.parseTimeValue((String)time);
            this.end = this.start + this.time;
        }

        private boolean relive() {
            return TimeUtils.nowTime() >= this.end;
        }
    }

    public static class IPRangeDeny {
        final String _value;
        final IPRange ipRange;
        final TimeMeta timeMeta;

        public IPRangeDeny(String ipRange, TimeMeta timeMeta) {
            this._value = ipRange;
            this.ipRange = new IPRange(ipRange);
            this.timeMeta = timeMeta;
        }

        private static void _add(String ipRange, String time, long now) {
            ipRangeBlacklist.add(new IPRangeDeny(ipRange, TimeMeta.of(time, now)));
        }

        public static void add(String ipRange, String time) {
            long nowTime = TimeUtils.nowTime();
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.IP_RANGE).setOp(AuthzModifier.BlacklistInfo.OP.ADD).setIpRange(ipRange).setTime(time).setStart(nowTime);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        private static void _change(String ipRange, String time) {
            Optional<IPRangeDeny> v = ipRangeBlacklist.stream().filter(o -> o._value.equals(ipRange)).findFirst();
            if (v.isPresent()) {
                IPRangeDeny i = v.get();
                i.timeMeta.changeTime(time);
            }
        }

        public static void change(String ipRange, String time) {
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.IP_RANGE).setOp(AuthzModifier.BlacklistInfo.OP.CHANGE).setIpRange(ipRange).setTime(time);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        private static void _remove(String ipRange) {
            ipRangeBlacklist.removeIf(o -> o._value.equals(ipRange));
        }

        public static void remove(String ipRange) {
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.IP_RANGE).setOp(AuthzModifier.BlacklistInfo.OP.REMOVE).setIpRange(ipRange);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        public static boolean check(String ip) {
            AtomicBoolean hit = new AtomicBoolean(false);
            ipRangeBlacklist.removeIf(v -> {
                if (v.ipRange.isIPAddressInRange(new IPAddress(ip))) {
                    hit.set(true);
                }
                return v.timeMeta.relive();
            });
            return !hit.get();
        }

        public static List<IPRangeDeny> list() {
            return Collections.unmodifiableList(ipRangeBlacklist);
        }

        public String get_value() {
            return this._value;
        }

        public IPRange getIpRange() {
            return this.ipRange;
        }

        public TimeMeta getTimeMeta() {
            return this.timeMeta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IPRangeDeny)) {
                return false;
            }
            IPRangeDeny other = (IPRangeDeny)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$_value = this.get_value();
            String other$_value = other.get_value();
            if (this$_value == null ? other$_value != null : !this$_value.equals(other$_value)) {
                return false;
            }
            IPRange this$ipRange = this.getIpRange();
            IPRange other$ipRange = other.getIpRange();
            if (this$ipRange == null ? other$ipRange != null : !((Object)this$ipRange).equals(other$ipRange)) {
                return false;
            }
            TimeMeta this$timeMeta = this.getTimeMeta();
            TimeMeta other$timeMeta = other.getTimeMeta();
            return !(this$timeMeta == null ? other$timeMeta != null : !this$timeMeta.equals(other$timeMeta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IPRangeDeny;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $_value = this.get_value();
            result = result * 59 + ($_value == null ? 43 : $_value.hashCode());
            IPRange $ipRange = this.getIpRange();
            result = result * 59 + ($ipRange == null ? 43 : ((Object)$ipRange).hashCode());
            TimeMeta $timeMeta = this.getTimeMeta();
            result = result * 59 + ($timeMeta == null ? 43 : $timeMeta.hashCode());
            return result;
        }

        public String toString() {
            return "Blacklist.IPRangeDeny(_value=" + this.get_value() + ", ipRange=" + this.getIpRange() + ", timeMeta=" + this.getTimeMeta() + ")";
        }
    }

    public static class IP {
        final String ip;
        final TimeMeta timeMeta;

        public IP(String ip, TimeMeta timeMeta) {
            this.ip = ip;
            this.timeMeta = timeMeta;
        }

        private static void _add(String ip, String time, long now) {
            ipBlacklist.add(new IP(ip, TimeMeta.of(time, now)));
            ipBlacklistBloomFilter.add((Object)ip);
        }

        public static void add(String ip, String time) {
            long nowTime = TimeUtils.nowTime();
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.IP).setOp(AuthzModifier.BlacklistInfo.OP.ADD).setIp(ip).setTime(time).setStart(nowTime);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        private static void _change(String ip, String time) {
            Optional<IP> v = ipBlacklist.stream().filter(o -> o.ip.equals(ip)).findFirst();
            if (v.isPresent()) {
                IP i = v.get();
                i.timeMeta.changeTime(time);
            }
        }

        public static void change(String ip, String time) {
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.IP).setOp(AuthzModifier.BlacklistInfo.OP.CHANGE).setIp(ip).setTime(time);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        private static void _remove(String ip) {
            ipBlacklist.removeIf(o -> o.ip.equals(ip));
            ipBlacklistBloomFilter.remove((Object)ip);
        }

        public static void remove(String ip) {
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.IP).setOp(AuthzModifier.BlacklistInfo.OP.REMOVE).setIp(ip);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        @Nullable
        public static IP get(String ip) {
            AtomicReference i = new AtomicReference();
            ipBlacklist.removeIf(o -> {
                if (o.ip.equals(ip)) {
                    i.set(o);
                }
                return o.timeMeta.relive();
            });
            return (IP)i.get();
        }

        public static boolean check(String ip) {
            if (ipBlacklistBloomFilter.contains((Object)ip)) {
                IP _ip = IP.get(ip);
                if (_ip == null) {
                    return true;
                }
                if (_ip.timeMeta.relive()) {
                    ipBlacklistBloomFilter.remove((Object)ip);
                    ipBlacklist.remove(_ip);
                    return true;
                }
                return false;
            }
            return true;
        }

        public static List<IP> list() {
            return Collections.unmodifiableList(ipBlacklist);
        }

        public String getIp() {
            return this.ip;
        }

        public TimeMeta getTimeMeta() {
            return this.timeMeta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IP)) {
                return false;
            }
            IP other = (IP)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            TimeMeta this$timeMeta = this.getTimeMeta();
            TimeMeta other$timeMeta = other.getTimeMeta();
            return !(this$timeMeta == null ? other$timeMeta != null : !this$timeMeta.equals(other$timeMeta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IP;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            TimeMeta $timeMeta = this.getTimeMeta();
            result = result * 59 + ($timeMeta == null ? 43 : $timeMeta.hashCode());
            return result;
        }

        public String toString() {
            return "Blacklist.IP(ip=" + this.getIp() + ", timeMeta=" + this.getTimeMeta() + ")";
        }
    }

    public static class User {
        final Object userId;
        @Nullable
        final String deviceType;
        @Nullable
        final String deviceId;
        final TimeMeta timeMeta;

        public User(Object userId, @Nullable String deviceType, @Nullable String deviceId, TimeMeta timeMeta) {
            this.userId = userId;
            this.deviceId = deviceId;
            this.deviceType = deviceType;
            this.timeMeta = timeMeta;
        }

        private static void _add(Object userId, @Nullable String deviceType, @Nullable String deviceId, String time, long now) {
            User user = new User(userId, deviceType, deviceId, TimeMeta.of(time, now));
            userBlacklist.add(user);
            userBlacklistBloomFilter.add((Object)userId.toString());
        }

        public static void add(Object userId, @Nullable String deviceType, @Nullable String deviceId, String time) {
            long nowTime = TimeUtils.nowTime();
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.USER).setOp(AuthzModifier.BlacklistInfo.OP.ADD).setUserId(userId).setDeviceType(deviceType).setDeviceId(deviceId).setTime(time).setStart(nowTime);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        private static void _change(Object userId, @Nullable String deviceType, @Nullable String deviceId, String time) {
            Optional<User> v = userBlacklist.stream().filter(u -> u.userId.equals(userId) && StringUtils.equals((String)u.deviceType, (String)deviceType) && StringUtils.equals((String)u.deviceId, (String)deviceId)).findFirst();
            if (v.isPresent()) {
                User user = v.get();
                user.timeMeta.changeTime(time);
            }
        }

        public static void change(Object userId, @Nullable String deviceType, @Nullable String deviceId, String time) {
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.USER).setOp(AuthzModifier.BlacklistInfo.OP.CHANGE).setUserId(userId).setDeviceType(deviceType).setDeviceId(deviceId).setTime(time);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        private static void _remove(Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            userBlacklist.removeIf(u -> u.userId.equals(userId) && StringUtils.equals((String)u.deviceType, (String)deviceType) && StringUtils.equals((String)u.deviceId, (String)deviceId));
            if (userBlacklist.stream().noneMatch(u -> u.userId.equals(userId))) {
                userBlacklistBloomFilter.remove((Object)userId.toString());
            }
        }

        public static void remove(Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            AuthzModifier.BlacklistInfo blacklistInfo = new AuthzModifier.BlacklistInfo().setType(AuthzModifier.BlacklistInfo.TYPE.USER).setOp(AuthzModifier.BlacklistInfo.OP.REMOVE).setUserId(userId).setDeviceType(deviceType).setDeviceId(deviceId);
            AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
            Authz.operate(authzModifier);
        }

        @Nullable
        public static User get(Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            return userBlacklist.stream().filter(u -> u.userId.equals(userId) && StringUtils.equals((String)u.deviceType, (String)deviceType) && StringUtils.equals((String)u.deviceId, (String)deviceId)).findFirst().orElse(null);
        }

        public static List<User> list(Object userId) {
            ArrayList<User> users = new ArrayList<User>();
            userBlacklist.removeIf(u -> {
                if (u.userId.equals(userId)) {
                    users.add((User)u);
                }
                return u.timeMeta.relive();
            });
            return users;
        }

        public static List<User> list() {
            return Collections.unmodifiableList(userBlacklist);
        }

        public static boolean check(Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            if (userBlacklistBloomFilter.contains((Object)userId.toString())) {
                List<User> list = User.list(userId);
                boolean hit = list.stream().anyMatch(user -> {
                    if (user.timeMeta.relive()) {
                        return false;
                    }
                    if (user.deviceType == null && user.deviceId == null) {
                        return true;
                    }
                    if (user.deviceType != null && user.deviceId != null) {
                        return StringUtils.equals((String)user.deviceType, (String)deviceType) && StringUtils.equals((String)user.deviceId, (String)deviceId);
                    }
                    if (user.deviceType != null) {
                        return StringUtils.equals((String)user.deviceType, (String)deviceType);
                    }
                    return false;
                });
                for (User user2 : list) {
                    if (!user2.timeMeta.relive()) continue;
                    userBlacklist.remove(user2);
                }
                if (list.isEmpty()) {
                    userBlacklistBloomFilter.remove((Object)userId.toString());
                }
                return !hit;
            }
            return true;
        }

        public Object getUserId() {
            return this.userId;
        }

        @Nullable
        public String getDeviceType() {
            return this.deviceType;
        }

        @Nullable
        public String getDeviceId() {
            return this.deviceId;
        }

        public TimeMeta getTimeMeta() {
            return this.timeMeta;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$userId = this.getUserId();
            Object other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$deviceType = this.getDeviceType();
            String other$deviceType = other.getDeviceType();
            if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
                return false;
            }
            String this$deviceId = this.getDeviceId();
            String other$deviceId = other.getDeviceId();
            if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
                return false;
            }
            TimeMeta this$timeMeta = this.getTimeMeta();
            TimeMeta other$timeMeta = other.getTimeMeta();
            return !(this$timeMeta == null ? other$timeMeta != null : !this$timeMeta.equals(other$timeMeta));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $deviceType = this.getDeviceType();
            result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
            String $deviceId = this.getDeviceId();
            result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
            TimeMeta $timeMeta = this.getTimeMeta();
            result = result * 59 + ($timeMeta == null ? 43 : $timeMeta.hashCode());
            return result;
        }

        public String toString() {
            return "Blacklist.User(userId=" + this.getUserId() + ", deviceType=" + this.getDeviceType() + ", deviceId=" + this.getDeviceId() + ", timeMeta=" + this.getTimeMeta() + ")";
        }
    }
}

