/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.Rule;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AuthzModifier {
    private Operate operate;
    private Target target;
    private String method;
    private String api;
    private String value;
    private Integer index;
    private List<String> range;
    private List<String> resources;
    private String className;
    private String fieldName;
    private String condition;
    private Rule rule;
    private Map<String, List<String>> argsMap;
    private Role role;
    private Permission permission;
    private RateLimitInfo rateLimit;
    private BlacklistInfo blacklistInfo;

    public AuthzModifier setTarget(Target target) {
        this.target = target;
        return this;
    }

    public AuthzModifier setTarget(String target) {
        try {
            this.target = Target.valueOf(target.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            this.target = Target.NON;
        }
        return this;
    }

    public AuthzModifier setOp(Operate operate) {
        this.operate = operate;
        return this;
    }

    public AuthzModifier setOp(String operate) {
        try {
            this.operate = Operate.valueOf(operate.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            this.operate = Operate.EMPTY;
        }
        return this;
    }

    public AuthzModifier setOperate(Operate operate) {
        this.operate = operate;
        return this;
    }

    public AuthzModifier setOperate(String operate) {
        try {
            this.operate = Operate.valueOf(operate.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            this.operate = Operate.EMPTY;
        }
        return this;
    }

    public AuthzModifier setMethod(String method) {
        try {
            this.method = method.toUpperCase(Locale.ROOT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public AuthzModifier setParamName(String paramName) {
        this.value = paramName;
        return this;
    }

    public PermRolesMeta build() {
        PermRolesMeta permRolesMeta = new PermRolesMeta();
        try {
            permRolesMeta.setRequireRoles(this.role.require);
            permRolesMeta.setExcludeRoles(this.role.exclude);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            permRolesMeta.setRequirePermissions(this.permission.require);
            permRolesMeta.setExcludePermissions(this.permission.exclude);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return permRolesMeta;
    }

    public static PermRolesMeta build(List<String> requireRoles, List<String> excludeRoles, List<String> requirePermissions, List<String> excludePermissions) {
        PermRolesMeta permRolesMeta = new PermRolesMeta();
        permRolesMeta.setRequireRoles(requireRoles);
        permRolesMeta.setExcludeRoles(excludeRoles);
        permRolesMeta.setRequirePermissions(requirePermissions);
        permRolesMeta.setExcludePermissions(excludePermissions);
        return permRolesMeta;
    }

    public Operate getOperate() {
        return this.operate;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getMethod() {
        return this.method;
    }

    public String getApi() {
        return this.api;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getIndex() {
        return this.index;
    }

    public List<String> getRange() {
        return this.range;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getCondition() {
        return this.condition;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Map<String, List<String>> getArgsMap() {
        return this.argsMap;
    }

    public Role getRole() {
        return this.role;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public RateLimitInfo getRateLimit() {
        return this.rateLimit;
    }

    public BlacklistInfo getBlacklistInfo() {
        return this.blacklistInfo;
    }

    public AuthzModifier setApi(String api) {
        this.api = api;
        return this;
    }

    public AuthzModifier setValue(String value) {
        this.value = value;
        return this;
    }

    public AuthzModifier setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public AuthzModifier setRange(List<String> range) {
        this.range = range;
        return this;
    }

    public AuthzModifier setResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public AuthzModifier setClassName(String className) {
        this.className = className;
        return this;
    }

    public AuthzModifier setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public AuthzModifier setCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public AuthzModifier setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public AuthzModifier setArgsMap(Map<String, List<String>> argsMap) {
        this.argsMap = argsMap;
        return this;
    }

    public AuthzModifier setRole(Role role) {
        this.role = role;
        return this;
    }

    public AuthzModifier setPermission(Permission permission) {
        this.permission = permission;
        return this;
    }

    public AuthzModifier setRateLimit(RateLimitInfo rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    public AuthzModifier setBlacklistInfo(BlacklistInfo blacklistInfo) {
        this.blacklistInfo = blacklistInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthzModifier)) {
            return false;
        }
        AuthzModifier other = (AuthzModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Operate this$operate = this.getOperate();
        Operate other$operate = other.getOperate();
        if (this$operate == null ? other$operate != null : !((Object)((Object)this$operate)).equals((Object)other$operate)) {
            return false;
        }
        Target this$target = this.getTarget();
        Target other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)((Object)this$target)).equals((Object)other$target)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<String> this$range = this.getRange();
        List<String> other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        List<String> this$resources = this.getResources();
        List<String> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        Map<String, List<String>> this$argsMap = this.getArgsMap();
        Map<String, List<String>> other$argsMap = other.getArgsMap();
        if (this$argsMap == null ? other$argsMap != null : !((Object)this$argsMap).equals(other$argsMap)) {
            return false;
        }
        Role this$role = this.getRole();
        Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)this$role).equals(other$role)) {
            return false;
        }
        Permission this$permission = this.getPermission();
        Permission other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !((Object)this$permission).equals(other$permission)) {
            return false;
        }
        RateLimitInfo this$rateLimit = this.getRateLimit();
        RateLimitInfo other$rateLimit = other.getRateLimit();
        if (this$rateLimit == null ? other$rateLimit != null : !((Object)this$rateLimit).equals(other$rateLimit)) {
            return false;
        }
        BlacklistInfo this$blacklistInfo = this.getBlacklistInfo();
        BlacklistInfo other$blacklistInfo = other.getBlacklistInfo();
        return !(this$blacklistInfo == null ? other$blacklistInfo != null : !((Object)this$blacklistInfo).equals(other$blacklistInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthzModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Operate $operate = this.getOperate();
        result = result * 59 + ($operate == null ? 43 : ((Object)((Object)$operate)).hashCode());
        Target $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)((Object)$target)).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<String> $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        List<String> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        Map<String, List<String>> $argsMap = this.getArgsMap();
        result = result * 59 + ($argsMap == null ? 43 : ((Object)$argsMap).hashCode());
        Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)$role).hashCode());
        Permission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : ((Object)$permission).hashCode());
        RateLimitInfo $rateLimit = this.getRateLimit();
        result = result * 59 + ($rateLimit == null ? 43 : ((Object)$rateLimit).hashCode());
        BlacklistInfo $blacklistInfo = this.getBlacklistInfo();
        result = result * 59 + ($blacklistInfo == null ? 43 : ((Object)$blacklistInfo).hashCode());
        return result;
    }

    public String toString() {
        return "AuthzModifier(operate=" + (Object)((Object)this.getOperate()) + ", target=" + (Object)((Object)this.getTarget()) + ", method=" + this.getMethod() + ", api=" + this.getApi() + ", value=" + this.getValue() + ", index=" + this.getIndex() + ", range=" + this.getRange() + ", resources=" + this.getResources() + ", className=" + this.getClassName() + ", fieldName=" + this.getFieldName() + ", condition=" + this.getCondition() + ", rule=" + this.getRule() + ", argsMap=" + this.getArgsMap() + ", role=" + this.getRole() + ", permission=" + this.getPermission() + ", rateLimit=" + this.getRateLimit() + ", blacklistInfo=" + this.getBlacklistInfo() + ")";
    }

    public static enum Operate {
        ADD,
        DELETE,
        DEL,
        MODIFY,
        UPDATE,
        GET,
        READ,
        EMPTY,
        NON;

    }

    public static enum Target {
        API(1, "role", "permission"),
        PATH_VARIABLE_ROLE(2, "role"),
        PATH_VAR_ROLE(2, "role"),
        PATH_VARIABLE_PERMISSION(3, "permission"),
        PATH_VAR_PERMISSION(3, "permission"),
        REQUEST_PARAM_ROLE(4, "role"),
        PARAM_ROLE(4, "role"),
        REQUEST_PARAM_PERMISSION(5, "permission"),
        PARAM_PERMISSION(5, "permission"),
        DATA_ROW(6, "role", "permission"),
        DATA_COL(7, "role", "permission"),
        PATH(8, "role", "permission"),
        PARAM(9, "role", "permission"),
        RATE(10, new String[0]),
        BLACKLIST(11, new String[0]),
        NON(0, new String[0]);

        public final int i;
        final String[] with;

        private Target(int i, String ... with) {
            this.i = i;
            this.with = with;
        }

        public boolean contains(String ... with) {
            return Arrays.asList(this.with).containsAll(Arrays.asList(with));
        }
    }

    public static class BlacklistInfo {
        private TYPE type;
        private OP op;
        private Long start;
        private String ip;
        private String ipRange;
        private Object userId;
        private String deviceType;
        private String deviceId;
        private String time;

        public TYPE getType() {
            return this.type;
        }

        public OP getOp() {
            return this.op;
        }

        public Long getStart() {
            return this.start;
        }

        public String getIp() {
            return this.ip;
        }

        public String getIpRange() {
            return this.ipRange;
        }

        public Object getUserId() {
            return this.userId;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public String getTime() {
            return this.time;
        }

        public BlacklistInfo setType(TYPE type) {
            this.type = type;
            return this;
        }

        public BlacklistInfo setOp(OP op) {
            this.op = op;
            return this;
        }

        public BlacklistInfo setStart(Long start) {
            this.start = start;
            return this;
        }

        public BlacklistInfo setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public BlacklistInfo setIpRange(String ipRange) {
            this.ipRange = ipRange;
            return this;
        }

        public BlacklistInfo setUserId(Object userId) {
            this.userId = userId;
            return this;
        }

        public BlacklistInfo setDeviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public BlacklistInfo setDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public BlacklistInfo setTime(String time) {
            this.time = time;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlacklistInfo)) {
                return false;
            }
            BlacklistInfo other = (BlacklistInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$start = this.getStart();
            Long other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            TYPE this$type = this.getType();
            TYPE other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            OP this$op = this.getOp();
            OP other$op = other.getOp();
            if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$ipRange = this.getIpRange();
            String other$ipRange = other.getIpRange();
            if (this$ipRange == null ? other$ipRange != null : !this$ipRange.equals(other$ipRange)) {
                return false;
            }
            Object this$userId = this.getUserId();
            Object other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$deviceType = this.getDeviceType();
            String other$deviceType = other.getDeviceType();
            if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
                return false;
            }
            String this$deviceId = this.getDeviceId();
            String other$deviceId = other.getDeviceId();
            if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
                return false;
            }
            String this$time = this.getTime();
            String other$time = other.getTime();
            return !(this$time == null ? other$time != null : !this$time.equals(other$time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlacklistInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            TYPE $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            OP $op = this.getOp();
            result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $ipRange = this.getIpRange();
            result = result * 59 + ($ipRange == null ? 43 : $ipRange.hashCode());
            Object $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $deviceType = this.getDeviceType();
            result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
            String $deviceId = this.getDeviceId();
            result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
            String $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : $time.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.BlacklistInfo(type=" + (Object)((Object)this.getType()) + ", op=" + (Object)((Object)this.getOp()) + ", start=" + this.getStart() + ", ip=" + this.getIp() + ", ipRange=" + this.getIpRange() + ", userId=" + this.getUserId() + ", deviceType=" + this.getDeviceType() + ", deviceId=" + this.getDeviceId() + ", time=" + this.getTime() + ")";
        }

        static enum TYPE {
            IP,
            USER,
            IP_RANGE;

        }

        static enum OP {
            ADD,
            CHANGE,
            REMOVE;

        }
    }

    public static class RateLimitInfo {
        private String window;
        private int maxRequests;
        private List<String> punishmentTime;
        private String minInterval;
        private List<String> associatedPatterns;
        private RateLimit.CheckType checkType;

        public String getWindow() {
            return this.window;
        }

        public int getMaxRequests() {
            return this.maxRequests;
        }

        public List<String> getPunishmentTime() {
            return this.punishmentTime;
        }

        public String getMinInterval() {
            return this.minInterval;
        }

        public List<String> getAssociatedPatterns() {
            return this.associatedPatterns;
        }

        public RateLimit.CheckType getCheckType() {
            return this.checkType;
        }

        public RateLimitInfo setWindow(String window) {
            this.window = window;
            return this;
        }

        public RateLimitInfo setMaxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        public RateLimitInfo setPunishmentTime(List<String> punishmentTime) {
            this.punishmentTime = punishmentTime;
            return this;
        }

        public RateLimitInfo setMinInterval(String minInterval) {
            this.minInterval = minInterval;
            return this;
        }

        public RateLimitInfo setAssociatedPatterns(List<String> associatedPatterns) {
            this.associatedPatterns = associatedPatterns;
            return this;
        }

        public RateLimitInfo setCheckType(RateLimit.CheckType checkType) {
            this.checkType = checkType;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RateLimitInfo)) {
                return false;
            }
            RateLimitInfo other = (RateLimitInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxRequests() != other.getMaxRequests()) {
                return false;
            }
            String this$window = this.getWindow();
            String other$window = other.getWindow();
            if (this$window == null ? other$window != null : !this$window.equals(other$window)) {
                return false;
            }
            List<String> this$punishmentTime = this.getPunishmentTime();
            List<String> other$punishmentTime = other.getPunishmentTime();
            if (this$punishmentTime == null ? other$punishmentTime != null : !((Object)this$punishmentTime).equals(other$punishmentTime)) {
                return false;
            }
            String this$minInterval = this.getMinInterval();
            String other$minInterval = other.getMinInterval();
            if (this$minInterval == null ? other$minInterval != null : !this$minInterval.equals(other$minInterval)) {
                return false;
            }
            List<String> this$associatedPatterns = this.getAssociatedPatterns();
            List<String> other$associatedPatterns = other.getAssociatedPatterns();
            if (this$associatedPatterns == null ? other$associatedPatterns != null : !((Object)this$associatedPatterns).equals(other$associatedPatterns)) {
                return false;
            }
            RateLimit.CheckType this$checkType = this.getCheckType();
            RateLimit.CheckType other$checkType = other.getCheckType();
            return !(this$checkType == null ? other$checkType != null : !((Object)((Object)this$checkType)).equals((Object)other$checkType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RateLimitInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxRequests();
            String $window = this.getWindow();
            result = result * 59 + ($window == null ? 43 : $window.hashCode());
            List<String> $punishmentTime = this.getPunishmentTime();
            result = result * 59 + ($punishmentTime == null ? 43 : ((Object)$punishmentTime).hashCode());
            String $minInterval = this.getMinInterval();
            result = result * 59 + ($minInterval == null ? 43 : $minInterval.hashCode());
            List<String> $associatedPatterns = this.getAssociatedPatterns();
            result = result * 59 + ($associatedPatterns == null ? 43 : ((Object)$associatedPatterns).hashCode());
            RateLimit.CheckType $checkType = this.getCheckType();
            result = result * 59 + ($checkType == null ? 43 : ((Object)((Object)$checkType)).hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.RateLimitInfo(window=" + this.getWindow() + ", maxRequests=" + this.getMaxRequests() + ", punishmentTime=" + this.getPunishmentTime() + ", minInterval=" + this.getMinInterval() + ", associatedPatterns=" + this.getAssociatedPatterns() + ", checkType=" + (Object)((Object)this.getCheckType()) + ")";
        }
    }

    public static class Permission {
        private List<String> require;
        private List<String> exclude;

        public List<String> getRequire() {
            return this.require;
        }

        public List<String> getExclude() {
            return this.exclude;
        }

        public Permission setRequire(List<String> require) {
            this.require = require;
            return this;
        }

        public Permission setExclude(List<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Permission)) {
                return false;
            }
            Permission other = (Permission)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$require = this.getRequire();
            List<String> other$require = other.getRequire();
            if (this$require == null ? other$require != null : !((Object)this$require).equals(other$require)) {
                return false;
            }
            List<String> this$exclude = this.getExclude();
            List<String> other$exclude = other.getExclude();
            return !(this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Permission;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $require = this.getRequire();
            result = result * 59 + ($require == null ? 43 : ((Object)$require).hashCode());
            List<String> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.Permission(require=" + this.getRequire() + ", exclude=" + this.getExclude() + ")";
        }
    }

    public static class Role {
        private List<String> require;
        private List<String> exclude;

        public List<String> getRequire() {
            return this.require;
        }

        public List<String> getExclude() {
            return this.exclude;
        }

        public Role setRequire(List<String> require) {
            this.require = require;
            return this;
        }

        public Role setExclude(List<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Role)) {
                return false;
            }
            Role other = (Role)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$require = this.getRequire();
            List<String> other$require = other.getRequire();
            if (this$require == null ? other$require != null : !((Object)this$require).equals(other$require)) {
                return false;
            }
            List<String> this$exclude = this.getExclude();
            List<String> other$exclude = other.getExclude();
            return !(this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Role;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $require = this.getRequire();
            result = result * 59 + ($require == null ? 43 : ((Object)$require).hashCode());
            List<String> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.Role(require=" + this.getRequire() + ", exclude=" + this.getExclude() + ")";
        }
    }
}

