/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import cn.omisheep.authz.core.Authz;
import cn.omisheep.authz.core.auth.AuthzModifier;
import cn.omisheep.authz.core.msg.VersionMessage;
import cn.omisheep.authz.core.util.MD5Utils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Assert;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.TaskBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class VersionInfo {
    public static final AtomicInteger version = new AtomicInteger(0);
    public static final ArrayList<AuthzModifier> changeLog = new ArrayList();
    public static final ArrayList<AuthzModifier> cache = new ArrayList();
    private static final Map<String, String> _values = new HashMap<String, String>();
    public static final Map<String, String> values = Collections.unmodifiableMap(_values);
    private static String md5;
    private static boolean md5check;
    private static String projectPath;
    public static String APPLICATION_NAME;
    public static String APP_NAME;
    private static boolean loading;
    public static String host;
    public static String port;
    public static String path;
    public static String prefix;

    public static void init(String app) {
        Assert.state((!_values.containsKey("APP") ? 1 : 0) != 0, (String)"APP\u5df2\u521d\u59cb\u5316");
        _values.put("APP", app);
        _values.put("ACCESS_INFO_KEY_PREFIX", "au:" + app + ":usersAccessInfo:");
        _values.put("REFRESH_INFO_KEY_PREFIX", "au:" + app + ":usersRefreshInfo:");
        _values.put("DEVICE_REQUEST_INFO_KEY_PREFIX", "au:" + app + ":requestInfo:");
        _values.put("PERMISSIONS_BY_ROLE_KEY_PREFIX", "au:" + app + ":permissionsByRole:");
        _values.put("USER_ROLES_KEY_PREFIX", "au:" + app + ":userRoles:");
    }

    public static String getProjectPath() {
        return projectPath;
    }

    public static void setProjectPath(String projectPath) {
        if (VersionInfo.projectPath == null) {
            VersionInfo.projectPath = projectPath;
        }
    }

    public static boolean isMd5check() {
        return md5check;
    }

    public static void setMd5check(boolean md5check) {
        VersionInfo.md5check = md5check;
    }

    public static String getMd5() {
        return md5;
    }

    public static void compute() {
        md5 = MD5Utils.compute(projectPath);
    }

    public static HashMap<String, String> getVersion() {
        HashMap<String, String> v = new HashMap<String, String>();
        v.put("version", version + "");
        v.put("name", APP_NAME);
        v.put("application", APPLICATION_NAME);
        v.put("host", host);
        v.put("port", port);
        v.put("path", path);
        v.put("prefix", prefix);
        return v;
    }

    public static void receive(VersionMessage versionMessage) {
        if (versionMessage.isTag()) {
            List<AuthzModifier> authzModifierList;
            if (version.get() == 0 && (authzModifierList = versionMessage.getAuthzModifierList()) != null && versionMessage.getVersion() == authzModifierList.size()) {
                loading = true;
                for (AuthzModifier modifier : authzModifierList) {
                    VersionInfo.receiveCut(modifier);
                    version.incrementAndGet();
                }
                loading = false;
            }
            return;
        }
        if (versionMessage.getVersion() == -1 && !loading) {
            VersionInfo.send();
            return;
        }
        AuthzModifier authzModifier = versionMessage.getAuthzModifier();
        if (authzModifier != null) {
            if (loading) {
                cache.add(authzModifier);
                TaskBuilder.scheduleOnceDelay((Runnable)VersionInfo.task(), (String)"10s");
                return;
            }
            VersionInfo.receiveCut(authzModifier);
            version.incrementAndGet();
            changeLog.add(versionMessage.getAuthzModifier());
        }
    }

    public static Runnable task() {
        return () -> {
            if (loading) {
                TaskBuilder.schedule((Runnable)VersionInfo.task(), (String)"10s");
            } else {
                cache.forEach(VersionInfo::receiveCut);
                cache.clear();
            }
        };
    }

    public static void receiveCut(AuthzModifier authzModifier) {
        AuthzModifier.Operate operate = authzModifier.getOperate();
        if (AuthzModifier.Operate.READ != operate && AuthzModifier.Operate.GET != operate) {
            Authz.op(authzModifier);
        }
    }

    public static void born() {
        Async.run(() -> RedisUtils.publish(VersionMessage.CHANNEL, new VersionMessage(-1, md5)));
    }

    public static void send(AuthzModifier authzModifier) {
        changeLog.add(authzModifier);
        int v = version.incrementAndGet();
        Async.run(() -> RedisUtils.publish(VersionMessage.CHANNEL, new VersionMessage(authzModifier, v, md5)));
    }

    public static void send() {
        Async.run(() -> RedisUtils.publish(VersionMessage.CHANNEL, new VersionMessage(changeLog, version.get(), md5).setTag(true)));
    }

    static {
        md5check = false;
        projectPath = null;
        loading = false;
    }
}

