/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import org.springframework.http.HttpStatus;

public enum ExceptionStatus {
    UNKNOWN(-99999, "unknown", false, HttpStatus.INTERNAL_SERVER_ERROR),
    MISMATCHED_URL(-100, "URL matching failed", false, HttpStatus.NOT_FOUND),
    REQUIRE_LOGIN(-101, "Require login", true, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    ACCESS_TOKEN_OVERDUE(-102, "AccessToken overdue", true, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    PERM_EXCEPTION(-103, "Insufficient permissions", false, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    TOKEN_EXCEPTION(-201, "Token exception", true, HttpStatus.FORBIDDEN),
    REQUEST_REPEAT(-202, "Request repeat error", false, HttpStatus.TOO_MANY_REQUESTS),
    LOGIN_EXCEPTION(-203, "You are offline, or you may have logged in elsewhere", true, HttpStatus.FORBIDDEN),
    REQUEST_EXCEPTION(-204, "Request error", false, HttpStatus.FORBIDDEN),
    CONTENT_TYPE_ERROR(-301, "Content type not supported, must be json", false, HttpStatus.INTERNAL_SERVER_ERROR),
    PAGE_NOT_SUPPORT(-302, "Page not support, check database type, only mysql and oracle", false, HttpStatus.INTERNAL_SERVER_ERROR);

    private final int code;
    private final String message;
    private final boolean clearToken;
    private final HttpStatus httpStatus;

    private ExceptionStatus(int code, String message, boolean clearToken, HttpStatus httpStatus) {
        this.code = code;
        this.message = message;
        this.clearToken = clearToken;
        this.httpStatus = httpStatus;
    }

    private ExceptionStatus(int code, String message, HttpStatus httpStatus) {
        this.code = code;
        this.message = message;
        this.clearToken = false;
        this.httpStatus = httpStatus;
    }

    private ExceptionStatus(HttpStatus httpStatus) {
        this.code = httpStatus.value();
        this.message = httpStatus.getReasonPhrase();
        this.clearToken = false;
        this.httpStatus = httpStatus;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public boolean isClearToken() {
        return this.clearToken;
    }
}

