/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import cn.omisheep.authz.core.codec.Decryptor;
import cn.omisheep.authz.core.codec.RSADecryptor;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogLevel;

@ConfigurationProperties(prefix="authz")
public class AuthzProperties {
    private String app = "defaultApp";
    private TokenConfig token = new TokenConfig();
    private UserConfig user = new UserConfig();
    private CacheConfig cache = new CacheConfig();
    private RSAConfig rsa = new RSAConfig();
    private IpRangeConfig globalIpRange = new IpRangeConfig();
    private DashboardConfig dashboard = new DashboardConfig();
    private Class<? extends Decryptor> defaultDecryptor = RSADecryptor.class;
    private String userBufferRefreshWithPeriod = "10s";
    private String gcPeriod;
    private LogLevel log = LogLevel.INFO;
    private boolean md5check = false;
    private ORM orm;
    private String[] ignoreSuffix = new String[]{".css", ".js", ".html", ".png", ".jpg", ".gif", ".svg"};

    public String getApp() {
        return this.app;
    }

    public TokenConfig getToken() {
        return this.token;
    }

    public UserConfig getUser() {
        return this.user;
    }

    public CacheConfig getCache() {
        return this.cache;
    }

    public RSAConfig getRsa() {
        return this.rsa;
    }

    public IpRangeConfig getGlobalIpRange() {
        return this.globalIpRange;
    }

    public DashboardConfig getDashboard() {
        return this.dashboard;
    }

    public Class<? extends Decryptor> getDefaultDecryptor() {
        return this.defaultDecryptor;
    }

    public String getUserBufferRefreshWithPeriod() {
        return this.userBufferRefreshWithPeriod;
    }

    public String getGcPeriod() {
        return this.gcPeriod;
    }

    public LogLevel getLog() {
        return this.log;
    }

    public boolean isMd5check() {
        return this.md5check;
    }

    public ORM getOrm() {
        return this.orm;
    }

    public String[] getIgnoreSuffix() {
        return this.ignoreSuffix;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setToken(TokenConfig token) {
        this.token = token;
    }

    public void setUser(UserConfig user) {
        this.user = user;
    }

    public void setCache(CacheConfig cache) {
        this.cache = cache;
    }

    public void setRsa(RSAConfig rsa) {
        this.rsa = rsa;
    }

    public void setGlobalIpRange(IpRangeConfig globalIpRange) {
        this.globalIpRange = globalIpRange;
    }

    public void setDashboard(DashboardConfig dashboard) {
        this.dashboard = dashboard;
    }

    public void setDefaultDecryptor(Class<? extends Decryptor> defaultDecryptor) {
        this.defaultDecryptor = defaultDecryptor;
    }

    public void setUserBufferRefreshWithPeriod(String userBufferRefreshWithPeriod) {
        this.userBufferRefreshWithPeriod = userBufferRefreshWithPeriod;
    }

    public void setGcPeriod(String gcPeriod) {
        this.gcPeriod = gcPeriod;
    }

    public void setLog(LogLevel log) {
        this.log = log;
    }

    public void setMd5check(boolean md5check) {
        this.md5check = md5check;
    }

    public void setOrm(ORM orm) {
        this.orm = orm;
    }

    public void setIgnoreSuffix(String[] ignoreSuffix) {
        this.ignoreSuffix = ignoreSuffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthzProperties)) {
            return false;
        }
        AuthzProperties other = (AuthzProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMd5check() != other.isMd5check()) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        TokenConfig this$token = this.getToken();
        TokenConfig other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        UserConfig this$user = this.getUser();
        UserConfig other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        CacheConfig this$cache = this.getCache();
        CacheConfig other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        RSAConfig this$rsa = this.getRsa();
        RSAConfig other$rsa = other.getRsa();
        if (this$rsa == null ? other$rsa != null : !((Object)this$rsa).equals(other$rsa)) {
            return false;
        }
        IpRangeConfig this$globalIpRange = this.getGlobalIpRange();
        IpRangeConfig other$globalIpRange = other.getGlobalIpRange();
        if (this$globalIpRange == null ? other$globalIpRange != null : !((Object)this$globalIpRange).equals(other$globalIpRange)) {
            return false;
        }
        DashboardConfig this$dashboard = this.getDashboard();
        DashboardConfig other$dashboard = other.getDashboard();
        if (this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard)) {
            return false;
        }
        Class<? extends Decryptor> this$defaultDecryptor = this.getDefaultDecryptor();
        Class<? extends Decryptor> other$defaultDecryptor = other.getDefaultDecryptor();
        if (this$defaultDecryptor == null ? other$defaultDecryptor != null : !this$defaultDecryptor.equals(other$defaultDecryptor)) {
            return false;
        }
        String this$userBufferRefreshWithPeriod = this.getUserBufferRefreshWithPeriod();
        String other$userBufferRefreshWithPeriod = other.getUserBufferRefreshWithPeriod();
        if (this$userBufferRefreshWithPeriod == null ? other$userBufferRefreshWithPeriod != null : !this$userBufferRefreshWithPeriod.equals(other$userBufferRefreshWithPeriod)) {
            return false;
        }
        String this$gcPeriod = this.getGcPeriod();
        String other$gcPeriod = other.getGcPeriod();
        if (this$gcPeriod == null ? other$gcPeriod != null : !this$gcPeriod.equals(other$gcPeriod)) {
            return false;
        }
        LogLevel this$log = this.getLog();
        LogLevel other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        ORM this$orm = this.getOrm();
        ORM other$orm = other.getOrm();
        if (this$orm == null ? other$orm != null : !((Object)((Object)this$orm)).equals((Object)other$orm)) {
            return false;
        }
        return Arrays.deepEquals(this.getIgnoreSuffix(), other.getIgnoreSuffix());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthzProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMd5check() ? 79 : 97);
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        TokenConfig $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        UserConfig $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        CacheConfig $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        RSAConfig $rsa = this.getRsa();
        result = result * 59 + ($rsa == null ? 43 : ((Object)$rsa).hashCode());
        IpRangeConfig $globalIpRange = this.getGlobalIpRange();
        result = result * 59 + ($globalIpRange == null ? 43 : ((Object)$globalIpRange).hashCode());
        DashboardConfig $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
        Class<? extends Decryptor> $defaultDecryptor = this.getDefaultDecryptor();
        result = result * 59 + ($defaultDecryptor == null ? 43 : $defaultDecryptor.hashCode());
        String $userBufferRefreshWithPeriod = this.getUserBufferRefreshWithPeriod();
        result = result * 59 + ($userBufferRefreshWithPeriod == null ? 43 : $userBufferRefreshWithPeriod.hashCode());
        String $gcPeriod = this.getGcPeriod();
        result = result * 59 + ($gcPeriod == null ? 43 : $gcPeriod.hashCode());
        LogLevel $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        ORM $orm = this.getOrm();
        result = result * 59 + ($orm == null ? 43 : ((Object)((Object)$orm)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIgnoreSuffix());
        return result;
    }

    public String toString() {
        return "AuthzProperties(app=" + this.getApp() + ", token=" + this.getToken() + ", user=" + this.getUser() + ", cache=" + this.getCache() + ", rsa=" + this.getRsa() + ", globalIpRange=" + this.getGlobalIpRange() + ", dashboard=" + this.getDashboard() + ", defaultDecryptor=" + this.getDefaultDecryptor() + ", userBufferRefreshWithPeriod=" + this.getUserBufferRefreshWithPeriod() + ", gcPeriod=" + this.getGcPeriod() + ", log=" + this.getLog() + ", md5check=" + this.isMd5check() + ", orm=" + (Object)((Object)this.getOrm()) + ", ignoreSuffix=" + Arrays.deepToString(this.getIgnoreSuffix()) + ")";
    }

    public static class DashboardConfig {
        private boolean enabled = false;
        private String username;
        private String password;
        private String allow;
        private String deny;
        private String remoteAddress;
        private String mappings = "/authz-dashboard/*";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getAllow() {
            return this.allow;
        }

        public String getDeny() {
            return this.deny;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public String getMappings() {
            return this.mappings;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setAllow(String allow) {
            this.allow = allow;
        }

        public void setDeny(String deny) {
            this.deny = deny;
        }

        public void setRemoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public void setMappings(String mappings) {
            this.mappings = mappings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DashboardConfig)) {
                return false;
            }
            DashboardConfig other = (DashboardConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$allow = this.getAllow();
            String other$allow = other.getAllow();
            if (this$allow == null ? other$allow != null : !this$allow.equals(other$allow)) {
                return false;
            }
            String this$deny = this.getDeny();
            String other$deny = other.getDeny();
            if (this$deny == null ? other$deny != null : !this$deny.equals(other$deny)) {
                return false;
            }
            String this$remoteAddress = this.getRemoteAddress();
            String other$remoteAddress = other.getRemoteAddress();
            if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
                return false;
            }
            String this$mappings = this.getMappings();
            String other$mappings = other.getMappings();
            return !(this$mappings == null ? other$mappings != null : !this$mappings.equals(other$mappings));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DashboardConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $allow = this.getAllow();
            result = result * 59 + ($allow == null ? 43 : $allow.hashCode());
            String $deny = this.getDeny();
            result = result * 59 + ($deny == null ? 43 : $deny.hashCode());
            String $remoteAddress = this.getRemoteAddress();
            result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
            String $mappings = this.getMappings();
            result = result * 59 + ($mappings == null ? 43 : $mappings.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.DashboardConfig(enabled=" + this.isEnabled() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", allow=" + this.getAllow() + ", deny=" + this.getDeny() + ", remoteAddress=" + this.getRemoteAddress() + ", mappings=" + this.getMappings() + ")";
        }
    }

    public static enum ORM {
        MYBATIS,
        JPA;

    }

    public static class RSAConfig {
        private boolean auto = true;
        private String rsaKeyRefreshWithPeriod = "7d";
        private String customPublicKey;
        private String customPrivateKey;

        public boolean isAuto() {
            return this.auto;
        }

        public String getRsaKeyRefreshWithPeriod() {
            return this.rsaKeyRefreshWithPeriod;
        }

        public String getCustomPublicKey() {
            return this.customPublicKey;
        }

        public String getCustomPrivateKey() {
            return this.customPrivateKey;
        }

        public void setAuto(boolean auto) {
            this.auto = auto;
        }

        public void setRsaKeyRefreshWithPeriod(String rsaKeyRefreshWithPeriod) {
            this.rsaKeyRefreshWithPeriod = rsaKeyRefreshWithPeriod;
        }

        public void setCustomPublicKey(String customPublicKey) {
            this.customPublicKey = customPublicKey;
        }

        public void setCustomPrivateKey(String customPrivateKey) {
            this.customPrivateKey = customPrivateKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RSAConfig)) {
                return false;
            }
            RSAConfig other = (RSAConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAuto() != other.isAuto()) {
                return false;
            }
            String this$rsaKeyRefreshWithPeriod = this.getRsaKeyRefreshWithPeriod();
            String other$rsaKeyRefreshWithPeriod = other.getRsaKeyRefreshWithPeriod();
            if (this$rsaKeyRefreshWithPeriod == null ? other$rsaKeyRefreshWithPeriod != null : !this$rsaKeyRefreshWithPeriod.equals(other$rsaKeyRefreshWithPeriod)) {
                return false;
            }
            String this$customPublicKey = this.getCustomPublicKey();
            String other$customPublicKey = other.getCustomPublicKey();
            if (this$customPublicKey == null ? other$customPublicKey != null : !this$customPublicKey.equals(other$customPublicKey)) {
                return false;
            }
            String this$customPrivateKey = this.getCustomPrivateKey();
            String other$customPrivateKey = other.getCustomPrivateKey();
            return !(this$customPrivateKey == null ? other$customPrivateKey != null : !this$customPrivateKey.equals(other$customPrivateKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RSAConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAuto() ? 79 : 97);
            String $rsaKeyRefreshWithPeriod = this.getRsaKeyRefreshWithPeriod();
            result = result * 59 + ($rsaKeyRefreshWithPeriod == null ? 43 : $rsaKeyRefreshWithPeriod.hashCode());
            String $customPublicKey = this.getCustomPublicKey();
            result = result * 59 + ($customPublicKey == null ? 43 : $customPublicKey.hashCode());
            String $customPrivateKey = this.getCustomPrivateKey();
            result = result * 59 + ($customPrivateKey == null ? 43 : $customPrivateKey.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.RSAConfig(auto=" + this.isAuto() + ", rsaKeyRefreshWithPeriod=" + this.getRsaKeyRefreshWithPeriod() + ", customPublicKey=" + this.getCustomPublicKey() + ", customPrivateKey=" + this.getCustomPrivateKey() + ")";
        }
    }

    public static class UserConfig {
        private boolean supportMultiDevice = true;
        private boolean supportMultiUserForSameDeviceType = false;

        public boolean isSupportMultiDevice() {
            return this.supportMultiDevice;
        }

        public boolean isSupportMultiUserForSameDeviceType() {
            return this.supportMultiUserForSameDeviceType;
        }

        public void setSupportMultiDevice(boolean supportMultiDevice) {
            this.supportMultiDevice = supportMultiDevice;
        }

        public void setSupportMultiUserForSameDeviceType(boolean supportMultiUserForSameDeviceType) {
            this.supportMultiUserForSameDeviceType = supportMultiUserForSameDeviceType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserConfig)) {
                return false;
            }
            UserConfig other = (UserConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSupportMultiDevice() != other.isSupportMultiDevice()) {
                return false;
            }
            return this.isSupportMultiUserForSameDeviceType() == other.isSupportMultiUserForSameDeviceType();
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSupportMultiDevice() ? 79 : 97);
            result = result * 59 + (this.isSupportMultiUserForSameDeviceType() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AuthzProperties.UserConfig(supportMultiDevice=" + this.isSupportMultiDevice() + ", supportMultiUserForSameDeviceType=" + this.isSupportMultiUserForSameDeviceType() + ")";
        }
    }

    public static class TokenConfig {
        private String key;
        private String cookieName = "atkn";
        private String headerName = "Authorization";
        private String headerPrefix = "Bearer";
        private String liveTime = "7d";
        private String refreshTime = "30d";
        private String issuer = "au";

        public String getKey() {
            return this.key;
        }

        public String getCookieName() {
            return this.cookieName;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public String getHeaderPrefix() {
            return this.headerPrefix;
        }

        public String getLiveTime() {
            return this.liveTime;
        }

        public String getRefreshTime() {
            return this.refreshTime;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public void setHeaderPrefix(String headerPrefix) {
            this.headerPrefix = headerPrefix;
        }

        public void setLiveTime(String liveTime) {
            this.liveTime = liveTime;
        }

        public void setRefreshTime(String refreshTime) {
            this.refreshTime = refreshTime;
        }

        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenConfig)) {
                return false;
            }
            TokenConfig other = (TokenConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$cookieName = this.getCookieName();
            String other$cookieName = other.getCookieName();
            if (this$cookieName == null ? other$cookieName != null : !this$cookieName.equals(other$cookieName)) {
                return false;
            }
            String this$headerName = this.getHeaderName();
            String other$headerName = other.getHeaderName();
            if (this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName)) {
                return false;
            }
            String this$headerPrefix = this.getHeaderPrefix();
            String other$headerPrefix = other.getHeaderPrefix();
            if (this$headerPrefix == null ? other$headerPrefix != null : !this$headerPrefix.equals(other$headerPrefix)) {
                return false;
            }
            String this$liveTime = this.getLiveTime();
            String other$liveTime = other.getLiveTime();
            if (this$liveTime == null ? other$liveTime != null : !this$liveTime.equals(other$liveTime)) {
                return false;
            }
            String this$refreshTime = this.getRefreshTime();
            String other$refreshTime = other.getRefreshTime();
            if (this$refreshTime == null ? other$refreshTime != null : !this$refreshTime.equals(other$refreshTime)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            return !(this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $cookieName = this.getCookieName();
            result = result * 59 + ($cookieName == null ? 43 : $cookieName.hashCode());
            String $headerName = this.getHeaderName();
            result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
            String $headerPrefix = this.getHeaderPrefix();
            result = result * 59 + ($headerPrefix == null ? 43 : $headerPrefix.hashCode());
            String $liveTime = this.getLiveTime();
            result = result * 59 + ($liveTime == null ? 43 : $liveTime.hashCode());
            String $refreshTime = this.getRefreshTime();
            result = result * 59 + ($refreshTime == null ? 43 : $refreshTime.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.TokenConfig(key=" + this.getKey() + ", cookieName=" + this.getCookieName() + ", headerName=" + this.getHeaderName() + ", headerPrefix=" + this.getHeaderPrefix() + ", liveTime=" + this.getLiveTime() + ", refreshTime=" + this.getRefreshTime() + ", issuer=" + this.getIssuer() + ")";
        }
    }

    public static class CacheConfig {
        private boolean enableRedis = false;
        private boolean enableRedisActuator = false;
        private int redisScanCount = 10000;
        private Long cacheMaximumSize;
        private String expireAfterReadOrUpdateTime = "10m";

        public boolean isEnableRedis() {
            return this.enableRedis;
        }

        public boolean isEnableRedisActuator() {
            return this.enableRedisActuator;
        }

        public int getRedisScanCount() {
            return this.redisScanCount;
        }

        public Long getCacheMaximumSize() {
            return this.cacheMaximumSize;
        }

        public String getExpireAfterReadOrUpdateTime() {
            return this.expireAfterReadOrUpdateTime;
        }

        public void setEnableRedis(boolean enableRedis) {
            this.enableRedis = enableRedis;
        }

        public void setEnableRedisActuator(boolean enableRedisActuator) {
            this.enableRedisActuator = enableRedisActuator;
        }

        public void setRedisScanCount(int redisScanCount) {
            this.redisScanCount = redisScanCount;
        }

        public void setCacheMaximumSize(Long cacheMaximumSize) {
            this.cacheMaximumSize = cacheMaximumSize;
        }

        public void setExpireAfterReadOrUpdateTime(String expireAfterReadOrUpdateTime) {
            this.expireAfterReadOrUpdateTime = expireAfterReadOrUpdateTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheConfig)) {
                return false;
            }
            CacheConfig other = (CacheConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnableRedis() != other.isEnableRedis()) {
                return false;
            }
            if (this.isEnableRedisActuator() != other.isEnableRedisActuator()) {
                return false;
            }
            if (this.getRedisScanCount() != other.getRedisScanCount()) {
                return false;
            }
            Long this$cacheMaximumSize = this.getCacheMaximumSize();
            Long other$cacheMaximumSize = other.getCacheMaximumSize();
            if (this$cacheMaximumSize == null ? other$cacheMaximumSize != null : !((Object)this$cacheMaximumSize).equals(other$cacheMaximumSize)) {
                return false;
            }
            String this$expireAfterReadOrUpdateTime = this.getExpireAfterReadOrUpdateTime();
            String other$expireAfterReadOrUpdateTime = other.getExpireAfterReadOrUpdateTime();
            return !(this$expireAfterReadOrUpdateTime == null ? other$expireAfterReadOrUpdateTime != null : !this$expireAfterReadOrUpdateTime.equals(other$expireAfterReadOrUpdateTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableRedis() ? 79 : 97);
            result = result * 59 + (this.isEnableRedisActuator() ? 79 : 97);
            result = result * 59 + this.getRedisScanCount();
            Long $cacheMaximumSize = this.getCacheMaximumSize();
            result = result * 59 + ($cacheMaximumSize == null ? 43 : ((Object)$cacheMaximumSize).hashCode());
            String $expireAfterReadOrUpdateTime = this.getExpireAfterReadOrUpdateTime();
            result = result * 59 + ($expireAfterReadOrUpdateTime == null ? 43 : $expireAfterReadOrUpdateTime.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.CacheConfig(enableRedis=" + this.isEnableRedis() + ", enableRedisActuator=" + this.isEnableRedisActuator() + ", redisScanCount=" + this.getRedisScanCount() + ", cacheMaximumSize=" + this.getCacheMaximumSize() + ", expireAfterReadOrUpdateTime=" + this.getExpireAfterReadOrUpdateTime() + ")";
        }
    }

    public static class IpRangeConfig {
        private String allow = "";
        private String deny = "";
        private boolean supportNative = true;

        public String getAllow() {
            return this.allow;
        }

        public String getDeny() {
            return this.deny;
        }

        public boolean isSupportNative() {
            return this.supportNative;
        }

        public void setAllow(String allow) {
            this.allow = allow;
        }

        public void setDeny(String deny) {
            this.deny = deny;
        }

        public void setSupportNative(boolean supportNative) {
            this.supportNative = supportNative;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IpRangeConfig)) {
                return false;
            }
            IpRangeConfig other = (IpRangeConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSupportNative() != other.isSupportNative()) {
                return false;
            }
            String this$allow = this.getAllow();
            String other$allow = other.getAllow();
            if (this$allow == null ? other$allow != null : !this$allow.equals(other$allow)) {
                return false;
            }
            String this$deny = this.getDeny();
            String other$deny = other.getDeny();
            return !(this$deny == null ? other$deny != null : !this$deny.equals(other$deny));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IpRangeConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSupportNative() ? 79 : 97);
            String $allow = this.getAllow();
            result = result * 59 + ($allow == null ? 43 : $allow.hashCode());
            String $deny = this.getDeny();
            result = result * 59 + ($deny == null ? 43 : $deny.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.IpRangeConfig(allow=" + this.getAllow() + ", deny=" + this.getDeny() + ", supportNative=" + this.isSupportNative() + ")";
        }
    }
}

