/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import cn.omisheep.authz.core.VersionInfo;
import cn.omisheep.authz.core.auth.AuthzModifier;
import cn.omisheep.authz.core.auth.Blacklist;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.cache.L2Cache;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.web.entity.Result;
import cn.omisheep.web.entity.ResultCode;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class Authz {
    public static final PermissionDict permissionDict = PermissionDict.self();
    public static final UserDevicesDict userDevicesDict = AUtils.getBean(UserDevicesDict.class);
    public static final Cache cache = AUtils.getBean(Cache.class);
    public static final Httpd httpd = AUtils.getBean(Httpd.class);

    @Nullable
    public static Object op(@NonNull AuthzModifier authzModifier) {
        if (authzModifier.getTarget() == AuthzModifier.Target.RATE) {
            return httpd.modify(authzModifier);
        }
        if (authzModifier.getTarget() == AuthzModifier.Target.BLACKLIST) {
            return Blacklist.modify(authzModifier);
        }
        return permissionDict.modify(authzModifier);
    }

    @Nullable
    public static Object modify(@NonNull AuthzModifier authzModifier) {
        try {
            Object object = Authz.op(authzModifier);
            return object;
        }
        finally {
            if (cache instanceof L2Cache) {
                VersionInfo.send(authzModifier);
            }
        }
    }

    @NonNull
    public static Result operate(@NonNull AuthzModifier authzModifier) {
        Object res = Authz.modify(authzModifier);
        if (res == null) {
            return Result.SUCCESS.data(null);
        }
        if (res instanceof Result) {
            return (Result)res;
        }
        if (res instanceof ResultCode) {
            return ((ResultCode)res).data();
        }
        return Result.SUCCESS.data(res);
    }
}

