/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz;

import cn.omisheep.authz.core.Authz;
import cn.omisheep.authz.core.NotLoginException;
import cn.omisheep.authz.core.auth.AuthzModifier;
import cn.omisheep.authz.core.auth.Blacklist;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.callback.RateLimitCallback;
import cn.omisheep.authz.core.codec.AuthzRSAManager;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public final class AuHelper {
    @Nullable
    public static TokenPair login(@NonNull Object userId) {
        return AuHelper.login(userId, "unknown", null);
    }

    @Nullable
    public static TokenPair login(@NonNull Object userId, @NonNull String deviceType) {
        return AuHelper.login(userId, deviceType, null);
    }

    @Nullable
    public static TokenPair login(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        return AuthzDefender.grant(userId, deviceType, deviceId);
    }

    public static void logout() {
        AuthzDefender.logout();
    }

    public static void logoutAll() {
        AuthzDefender.logoutAll();
    }

    public static void logout(@NonNull String deviceType) {
        AuthzDefender.logout(deviceType);
    }

    public static void logout(@NonNull String deviceType, @Nullable String deviceId) {
        AuthzDefender.logout(deviceType, deviceId);
    }

    public static void logoutAll(@NonNull Object userId) {
        AuthzDefender.logoutAll(userId);
    }

    public static void logout(@NonNull Object userId, @NonNull String deviceType) {
        AuthzDefender.logout(userId, deviceType);
    }

    public static void logout(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        AuthzDefender.logout(userId, deviceType, deviceId);
    }

    @Nullable
    public static TokenPair refreshToken(@NonNull String refreshToken) {
        return AuthzDefender.refreshToken(refreshToken);
    }

    @NonNull
    public static Map<Object, List<Device>> queryAllUsersDevices() {
        HashMap<Object, List<Device>> map = new HashMap<Object, List<Device>>();
        AuHelper.queryAllUserId().forEach(userId -> map.put(userId, AuHelper.queryAllDeviceByUserId(userId)));
        return map;
    }

    @Nullable
    public static Device queryDeviceByUserIdAndDeviceTypeAndDeviceId(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        return Authz.userDevicesDict.getDevice(userId, deviceType, deviceId);
    }

    @NonNull
    public static List<Device> queryAllDeviceFromCurrentUser() {
        return Authz.userDevicesDict.listDevicesForCurrentUser();
    }

    @NonNull
    public static List<Object> queryAllUserId() {
        return Authz.userDevicesDict.listUserId();
    }

    @NonNull
    public static List<Device> queryAllDeviceByUserId(@NonNull Object userId) {
        return Authz.userDevicesDict.listDevicesByUserId(userId);
    }

    @NonNull
    public static List<Device> queryAllDeviceByUserIdAndDeviceType(@NonNull Object userId, @NonNull String deviceType) {
        return Authz.userDevicesDict.listDevicesByUserId(userId).stream().filter(device -> device.getType().equals(deviceType)).collect(Collectors.toList());
    }

    public static boolean isLogin() {
        return AuthzDefender.isLogin();
    }

    public static HttpMeta getHttpMeta() {
        return AUtils.getCurrentHttpMeta();
    }

    public static Token getToken() throws NotLoginException {
        return AUtils.getCurrentToken();
    }

    public static Object getUserId() throws NotLoginException {
        return AUtils.getCurrentToken().getUserId();
    }

    public static String getDeviceType() throws NotLoginException {
        return AUtils.getCurrentToken().getDeviceType();
    }

    public static String getDeviceId() throws NotLoginException {
        return AUtils.getCurrentToken().getDeviceId();
    }

    public static boolean hasRole(String role) throws NotLoginException {
        return AuthzDefender.hasRoles(Collections.singletonList(role));
    }

    public static boolean hasRoles(List<String> roles) throws NotLoginException {
        return AuthzDefender.hasRoles(roles);
    }

    public static boolean hasPermission(String permission) throws NotLoginException {
        return AuthzDefender.hasPermissions(Collections.singletonList(permission));
    }

    public static boolean hasPermissions(List<String> permissions) throws NotLoginException {
        return AuthzDefender.hasPermissions(permissions);
    }

    public static boolean checkUserIsActive(@NonNull Object userId) {
        return AuHelper.checkUserIsActive(userId, 60000L);
    }

    public static boolean checkUserIsActive(@NonNull Object userId, @NonNull String time) {
        return Authz.userDevicesDict.listActiveUserDevices(userId, TimeUtils.parseTimeValue((String)time)).size() > 0;
    }

    public static boolean checkUserIsActive(@NonNull Object userId, long ms) {
        return Authz.userDevicesDict.listActiveUserDevices(userId, ms).size() > 0;
    }

    public static int queryNumberOfActiveUsers() {
        return Authz.userDevicesDict.listActiveUsers(60000L).size();
    }

    public static int queryNumberOfActiveUsers(@NonNull String time) {
        return Authz.userDevicesDict.listActiveUsers(TimeUtils.parseTimeValue((String)time)).size();
    }

    public static int queryNumberOfActiveUsers(long ms) {
        return Authz.userDevicesDict.listActiveUsers(ms).size();
    }

    @NonNull
    public static List<Object> queryActiveUsers() {
        return Authz.userDevicesDict.listActiveUsers(60000L);
    }

    @NonNull
    public static List<Object> queryActiveUsers(@NonNull String time) {
        return Authz.userDevicesDict.listActiveUsers(TimeUtils.parseTimeValue((String)time));
    }

    @NonNull
    public static List<Object> queryActiveUsers(long ms) {
        return Authz.userDevicesDict.listActiveUsers(ms);
    }

    public static void denyIP(@NonNull String ip, @NonNull String time) {
        Blacklist.IP.add(ip, time);
    }

    public static void denyIPRange(@NonNull String ipRange, @NonNull String time) {
        Blacklist.IPRangeDeny.add(ipRange, time);
    }

    public static void denyUser(@NonNull Object userId, @NonNull String time) {
        Blacklist.User.add(userId, null, null, time);
    }

    public static void denyUser(@NonNull Object userId, @NonNull String deviceType, @NonNull String time) {
        Blacklist.User.add(userId, deviceType, null, time);
    }

    public static void denyUser(@NonNull Object userId, @NonNull String deviceType, @NonNull String deviceId, @NonNull String time) {
        Blacklist.User.add(userId, deviceType, deviceId, time);
    }

    @NonNull
    public static List<Blacklist.IP> getDenyIPInfo() {
        return Blacklist.IP.list();
    }

    @NonNull
    public static List<Blacklist.IPRangeDeny> getDenyIPRangeInfo() {
        return Blacklist.IPRangeDeny.list();
    }

    @NonNull
    public static List<Blacklist.User> getDenyUserInfo() {
        return Blacklist.User.list();
    }

    @NonNull
    public static List<Blacklist.User> getDenyUserInfo(@NonNull Object userId) {
        return Blacklist.User.list(userId);
    }

    @Nullable
    public static Blacklist.User getDenyUserInfo(@NonNull Object userId, @Nullable String deviceType, @Nullable String deviceId) {
        return Blacklist.User.get(userId, deviceType, deviceId);
    }

    public static void changeDenyIP(@NonNull String ip, @NonNull String time) {
        Blacklist.IP.change(ip, time);
    }

    public static void changeDenyIPRange(@NonNull String ipRange, @NonNull String time) {
        Blacklist.IPRangeDeny.change(ipRange, time);
    }

    public static void changeDenyUser(@NonNull Object userId, @NonNull String time) {
        Blacklist.User.change(userId, null, null, time);
    }

    public static void changeDenyUser(@NonNull Object userId, @NonNull String deviceType, @NonNull String time) {
        Blacklist.User.change(userId, deviceType, null, time);
    }

    public static void changeDenyUser(@NonNull Object userId, @NonNull String deviceType, @NonNull String deviceId, @NonNull String time) {
        Blacklist.User.change(userId, deviceType, deviceId, time);
    }

    public static void removeDenyIP(@NonNull String ip) {
        Blacklist.IP.remove(ip);
    }

    public static void removeDenyIPRange(@NonNull String ipRange) {
        Blacklist.IPRangeDeny.remove(ipRange);
    }

    public static void removeDenyUser(@NonNull Object userId) {
        Blacklist.User.remove(userId, null, null);
    }

    public static void removeDenyUser(@NonNull Object userId, @NonNull String deviceType) {
        Blacklist.User.remove(userId, deviceType, null);
    }

    public static void removeDenyUser(@NonNull Object userId, @NonNull String deviceType, @NonNull String deviceId) {
        Blacklist.User.remove(userId, deviceType, deviceId);
    }

    @NonNull
    public static String getRSAPublicKey() {
        return AuthzRSAManager.getPublicKeyString();
    }

    @NonNull
    public static String getRSAPrivateKey() {
        return AuthzRSAManager.getPrivateKeyString();
    }

    public static String encrypt(String plaintext) {
        return AuthzRSAManager.encrypt(plaintext);
    }

    public static String decrypt(String encryptText) {
        return AuthzRSAManager.decrypt(encryptText);
    }

    public static void openAutoRefresh() {
        AuthzRSAManager.setAuto(true);
    }

    public static void closeAutoRefreshAndSetup(String publicKey, String privateKey) {
        AuthzRSAManager.setAuKeyPair(publicKey, privateKey);
    }

    public static void reloadCache() {
        Authz.cache.reload();
    }

    public static void reloadCache(String ... keys) {
        Authz.cache.reload(keys);
    }

    @SafeVarargs
    public static void reloadCache(Collection<String> ... keys) {
        Authz.cache.reload(keys);
    }

    @Nullable
    public static Object authzModify(@NonNull AuthzModifier authzModifier) {
        return Authz.modify(authzModifier);
    }

    private AuHelper() {
    }

    public static class Callback {
        public static void setRateLimitCallback(RateLimitCallback rateLimitCallback) {
            Httpd.setRateLimitCallback(rateLimitCallback);
        }
    }
}

