/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.auth.rpd.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class RuleParser {
    public static String parseRuleToString(Rule rule) {
        String parse = RuleParser.parseRuleToStringNotTrim(rule);
        if (parse.startsWith("(") && parse.endsWith(")")) {
            return parse.substring(2, parse.length() - 2);
        }
        return parse;
    }

    private static String parseRuleToStringNotTrim(Rule rule) {
        if (rule == null) {
            return "";
        }
        String op = rule.getOp();
        if (op.equals("AND") || op.equals("OR")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("( ");
            Iterator<Rule> iterator = rule.getRules().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(RuleParser.parseRuleToStringNotTrim(iterator.next()));
                if (iterator.hasNext()) {
                    stringBuilder.append(" ").append(op).append(" ");
                    continue;
                }
                stringBuilder.append(" ");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return rule.valueShow();
    }

    public static Rule parseStringToRule(String rule) {
        Stack<String> stack = new Stack<String>();
        char[] chars = rule.toCharArray();
        int start = 0;
        HashMap<String, Rule> km = new HashMap<String, Rule>();
        int n = 1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '(') {
                stack.push(String.valueOf(chars, start, i - start).trim());
                stack.push("(");
                start = i + 1;
                continue;
            }
            if (chars[i] == ')') {
                stack.push(String.valueOf(chars, start, i - start).trim());
                StringBuilder sb = new StringBuilder();
                String p = (String)stack.pop();
                while (!p.equals("(")) {
                    sb.insert(0, " ").insert(0, p).insert(0, " ");
                    p = (String)stack.pop();
                }
                Rule to = RuleParser.to(km, sb, n);
                if (to == null) {
                    stack.push((String)stack.pop() + "(" + sb.substring(1, sb.length() - 1) + ")");
                } else {
                    stack.push("@" + n++);
                }
                start = i + 1;
                continue;
            }
            if (i != chars.length - 1) continue;
            stack.push(String.valueOf(chars, start, i - start + 1).trim());
        }
        StringBuilder sb = new StringBuilder();
        for (String s : stack) {
            sb.append(" ").append(s).append(" ");
        }
        return RuleParser.to(km, sb, n);
    }

    private static Rule to(Map<String, Rule> map, StringBuilder info, int n) {
        String[] or = info.toString().split(" [oO][rR] ");
        or = (String[])Arrays.stream(or).map(String::trim).toArray(String[]::new);
        Rule rr = new Rule();
        if (or.length >= 2) {
            rr.setOp("or");
            ArrayList<Rule> rrules = new ArrayList<Rule>();
            for (String s : or) {
                String[] and = s.split(" [aA][nN][dD] ");
                if ((and = (String[])Arrays.stream(and).map(String::trim).toArray(String[]::new)).length >= 2) {
                    Rule r = new Rule().setOp("and");
                    ArrayList<Rule> rules = new ArrayList<Rule>();
                    for (String v : and) {
                        if (v.startsWith("@")) {
                            rules.add(map.get(v));
                            continue;
                        }
                        Rule of = Rule.of(v);
                        if (of == null) continue;
                        rules.add(of);
                    }
                    r.setRules(rules);
                    rrules.add(r);
                    continue;
                }
                if (and[0].startsWith("@")) {
                    rrules.add(map.get(and[0]));
                    continue;
                }
                Rule of = Rule.of(and[0]);
                if (of == null) continue;
                rrules.add(of);
            }
            rr.setRules(rrules);
        } else {
            rr.setOp("and");
            String[] and = or[0].split(" [aA][nN][dD] ");
            and = (String[])Arrays.stream(and).map(String::trim).toArray(String[]::new);
            if (and.length >= 2) {
                rr.setOp("and");
                ArrayList<Rule> rules = new ArrayList<Rule>();
                for (String v : and) {
                    if (v.startsWith("@")) {
                        rules.add(map.get(v));
                        continue;
                    }
                    Rule of = Rule.of(v);
                    if (of == null) continue;
                    rules.add(of);
                }
                rr.setRules(rules);
            } else {
                rr = and[0].startsWith("@") ? map.get(and[0]) : Rule.of(and[0]);
            }
        }
        String key = "@" + n;
        if (rr != null) {
            map.put(key, rr);
        }
        return rr;
    }
}

