/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.web.utils.HttpUtils;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"authz.global.log");
    private static LogLevel logLevel;
    private static final String AU_LOGS = "au_logs";
    private static final Marker MARKER;

    public static void logInfo(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.INFO.ordinal()) {
            log.info(MARKER, msg, args);
        }
    }

    public static void logError(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.ERROR.ordinal()) {
            log.error(MARKER, msg, args);
        }
    }

    public static void logError(String msg, Throwable throwable) {
        if (logLevel.ordinal() <= LogLevel.ERROR.ordinal()) {
            log.error(msg, throwable);
        }
    }

    public static void logWarn(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.WARN.ordinal()) {
            log.warn(MARKER, msg, args);
        }
    }

    public static void logDebug(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.DEBUG.ordinal()) {
            log.info(MARKER, "[DEBUG]  " + msg, args);
        }
    }

    public static void pushLogToRequest(String formatMsg, Object ... args) {
        LogUtils.pushLogToRequest(LogLevel.INFO, formatMsg, args);
    }

    public static void pushLogToRequest(LogLevel logLevel, String formatMsg, Object ... args) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        ArrayList<LogMeta> au_logs = (ArrayList<LogMeta>)request.getAttribute(AU_LOGS);
        if (au_logs == null) {
            au_logs = new ArrayList<LogMeta>();
            request.setAttribute(AU_LOGS, au_logs);
        }
        au_logs.add(new LogMeta(logLevel, LogUtils.format(formatMsg, args)));
    }

    public static void exportLogsFromRequest() {
        LogUtils.exportLogsFromRequest(HttpUtils.getCurrentRequest());
    }

    public static void exportLogsFromRequest(HttpServletRequest request) {
        ArrayList logs = (ArrayList)request.getAttribute(AU_LOGS);
        if (logLevel.equals((Object)LogLevel.OFF) || logs == null) {
            return;
        }
        StringBuilder info = new StringBuilder();
        StringBuilder warn = new StringBuilder();
        StringBuilder debug = new StringBuilder();
        StringBuilder error = new StringBuilder();
        logs.forEach(logMeta -> {
            switch (((LogMeta)logMeta).logLevel) {
                case INFO: {
                    info.append("\n").append(logMeta.getMsg());
                    break;
                }
                case WARN: {
                    warn.append("\n").append(logMeta.getMsg());
                    break;
                }
                case DEBUG: {
                    debug.append("\n").append(logMeta.getMsg());
                    break;
                }
                case ERROR: {
                    error.append("\n").append(logMeta.getMsg());
                }
            }
        });
        if (info.length() > 0) {
            LogUtils.logInfo(info.append("\n").toString(), new Object[0]);
        }
        if (warn.length() > 0) {
            LogUtils.logWarn(warn.append("\n").toString(), new Object[0]);
        }
        if (debug.length() > 0) {
            LogUtils.logDebug(debug.append("\n").toString(), new Object[0]);
        }
        if (error.length() > 0) {
            LogUtils.logError(error.append("\n").toString(), new Object[0]);
        }
        logs.clear();
    }

    private static String format(String formatMsg, Object ... args) {
        for (Object arg : args) {
            formatMsg = formatMsg.replaceFirst("\\{}", String.valueOf(arg));
        }
        return formatMsg;
    }

    public static void setLogLevel(LogLevel logLevel) {
        LogUtils.logLevel = logLevel;
    }

    static {
        MARKER = MarkerFactory.getMarker((String)"cn.omisheep.au");
    }

    public static class LogMeta {
        private final LogLevel logLevel;
        private final String msg;

        public LogMeta(LogLevel logLevel, String msg) {
            if (logLevel == null) {
                logLevel = LogLevel.INFO;
            }
            this.logLevel = logLevel;
            this.msg = msg;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

