/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.web.utils.HttpUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AUtils.class);
    private static ApplicationContext ctx;
    private static final Pattern JSON_RSA_PATTERN;

    public static String parse_RSA_JSON(String json) {
        Matcher matcher = JSON_RSA_PATTERN.matcher(json);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String beautifulJson(Object o) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            log.error("JsonProcessingException => {}", (Object)e.getMessage());
            return "";
        }
    }

    public static <T> T getBean(Class<T> clz) {
        return (T)ctx.getBean(clz);
    }

    public static <T> T getBean(String name, Class<T> clz) {
        return (T)ctx.getBean(name, clz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clz) {
        return ctx.getBeansOfType(clz);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ctx = applicationContext;
    }

    public static HttpMeta getCurrentHttpMeta() {
        HttpMeta currentHttpMeta = (HttpMeta)HttpUtils.getCurrentRequest().getAttribute("AU_HTTP_META");
        return currentHttpMeta;
    }

    static {
        JSON_RSA_PATTERN = Pattern.compile("\\{.*\".*\".*:.*\"(.*)\".*}");
    }
}

