/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.tk;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.Assert;
import cn.omisheep.commons.util.TimeUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.TextCodec;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenHelper {
    private static final Logger log = LoggerFactory.getLogger(TokenHelper.class);
    private static final Long liveTime;
    private static final Long refreshTime;
    private static final String issuer;
    private static final int expire;
    private static final String cookieName;
    private static final byte[] keyBytes;
    private static final SignatureAlgorithm alg;

    private TokenHelper() {
    }

    private static Claims generateClaims(Object userId, String deviceType, String deviceId, Token.Type type) {
        Claims claims = Jwts.claims().setSubject(userId.toString());
        claims.put((Object)"userId", userId);
        claims.put((Object)"deviceId", (Object)deviceId);
        claims.put((Object)"deviceType", (Object)deviceType);
        claims.put((Object)"type", (Object)type);
        return claims;
    }

    public static TokenPair createTokenPair(Object userId, String deviceType, String deviceId) {
        Date fromNow = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date toAccessExpiredTime = Date.from(LocalDateTime.now().plus(liveTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant());
        Date toRefreshExpiredTime = Date.from(LocalDateTime.now().plus(refreshTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant());
        Token refreshToken = TokenHelper.createToken(userId, deviceType, deviceId, Token.Type.refresh, fromNow, toRefreshExpiredTime);
        Token accessToken = TokenHelper.createToken(userId, deviceType, deviceId, Token.Type.access, fromNow, toAccessExpiredTime);
        return new TokenPair(accessToken, refreshToken);
    }

    public static Token createToken(Object userId, String deviceType, String deviceId, Token.Type type, Date from, Date to) {
        Claims claims = TokenHelper.generateClaims(userId, deviceType, deviceId, type);
        String tokenId = UUID.randomUUID().toString();
        String tokenVal = Jwts.builder().signWith(alg, keyBytes).setClaims(claims).setId(tokenId).setIssuer(issuer).setIssuedAt(from).setExpiration(to).compact();
        return new Token(tokenVal, userId, tokenId, from, to, deviceType, deviceId, type);
    }

    public static TokenPair refreshToken(String refreshTokenVal) {
        return TokenHelper.refreshToken(TokenHelper.parseToken(refreshTokenVal));
    }

    public static TokenPair refreshToken(Token refreshToken) {
        if (refreshToken == null || !refreshToken.getType().equals((Object)Token.Type.refresh)) {
            return null;
        }
        Token accessToken = TokenHelper.createToken(refreshToken.getUserId(), refreshToken.getDeviceType(), refreshToken.getDeviceId(), Token.Type.access, TimeUtils.now(), Date.from(LocalDateTime.now().plus(liveTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant()));
        return new TokenPair(accessToken, refreshToken);
    }

    public static Cookie generateCookie(Token token) {
        Cookie cookie = new Cookie(cookieName, token.getTokenVal());
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(expire);
        return cookie;
    }

    public static Token parseToken(String tokenVal) {
        if (tokenVal == null || tokenVal.equals("")) {
            return null;
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey(keyBytes).parseClaimsJws(tokenVal).getBody();
        return new Token(tokenVal, claims.get((Object)"userId"), claims.getId(), claims.getIssuedAt(), claims.getExpiration(), (String)claims.get("deviceType", String.class), (String)claims.get("deviceId", String.class), Token.Type.valueOf((String)claims.get("type", String.class)));
    }

    public static Long getLiveTime() {
        return liveTime;
    }

    static {
        AuthzProperties properties = AUtils.getBean(AuthzProperties.class);
        Assert.hasText((String)properties.getToken().getKey(), (String)"token\u914d\u7f6e\u5f02\u5e38,\u8bf7\u5728yml\u4e2d\u914d\u7f6ekey");
        keyBytes = TextCodec.BASE64.decode(properties.getToken().getKey());
        issuer = properties.getToken().getIssuer();
        expire = (int)(TimeUtils.parseTimeValue((String)properties.getToken().getRefreshTime()) / 1000L);
        cookieName = properties.getToken().getCookieName();
        alg = SignatureAlgorithm.HS256;
        liveTime = TimeUtils.parseTimeValue((String)properties.getToken().getLiveTime());
        refreshTime = TimeUtils.parseTimeValue((String)properties.getToken().getRefreshTime());
    }
}

