/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.ValueMatcher;
import cn.omisheep.commons.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

@Order(value=40)
public class ParameterPermSlot
implements Slot {
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;

    public ParameterPermSlot(PermissionDict permissionDict, PermLibrary permLibrary) {
        this.permissionDict = permissionDict;
        this.permLibrary = permLibrary;
    }

    @Override
    public boolean chain(HttpMeta httpMeta, HandlerMethod handler) throws Exception {
        PermRolesMeta permRolesMeta = this.permissionDict.getAuthzMetadata().get(httpMeta.getMethod()).get(httpMeta.getApi());
        Set<String> roles = null;
        Set<String> permissions = null;
        for (MethodParameter parameter : handler.getMethodParameters()) {
            boolean bl;
            Object role2;
            Set<String> perms;
            List<PermRolesMeta.Meta> permissionsMetaList;
            ParamMetadata paramMetadata;
            String value;
            Class<?> paramType;
            block20: {
                block21: {
                    RequestParam requestParam = (RequestParam)AnnotationUtils.getAnnotation((AnnotatedElement)parameter.getParameter(), RequestParam.class);
                    PathVariable pathVariable = (PathVariable)AnnotationUtils.getAnnotation((AnnotatedElement)parameter.getParameter(), PathVariable.class);
                    String paramName = parameter.getParameter().getName();
                    paramType = parameter.getParameter().getType();
                    ParamMetadata.ParamType type = null;
                    value = null;
                    if (pathVariable != null) {
                        type = ParamMetadata.ParamType.PATH_VARIABLE;
                        if (!pathVariable.name().equals("")) {
                            paramName = pathVariable.name();
                        }
                        Map pathVariables = (Map)httpMeta.getRequest().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
                        value = (String)pathVariables.get(paramName);
                    } else if (requestParam != null) {
                        type = ParamMetadata.ParamType.REQUEST_PARAM;
                        if (!requestParam.name().equals("")) {
                            paramName = requestParam.name();
                        }
                        value = httpMeta.getRequest().getParameter(paramName);
                    }
                    if (type == null || value == null) continue;
                    paramMetadata = null;
                    try {
                        paramMetadata = permRolesMeta.getParamPermissionsMetadata().get((Object)type).get(paramName);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (paramMetadata == null) continue;
                    List<PermRolesMeta.Meta> rolesMetaList = paramMetadata.getRolesMetaList();
                    if (rolesMetaList == null || rolesMetaList.isEmpty()) break block20;
                    if (httpMeta.getToken() == null) {
                        AuthzDefender.logs("Require Login", httpMeta, permRolesMeta);
                        httpMeta.error(ExceptionStatus.REQUIRE_LOGIN);
                        return false;
                    }
                    roles = Optional.ofNullable(httpMeta.getRoles()).orElse(this.permLibrary.getRolesByUserId(httpMeta.getToken().getUserId()));
                    httpMeta.setRoles(roles);
                    boolean next = false;
                    for (PermRolesMeta.Meta meta2 : rolesMetaList) {
                        if (!ValueMatcher.match(meta2.getResources(), value, paramType) || !CollectionUtils.containsSub(meta2.getRequire(), roles)) continue;
                        next = true;
                        break;
                    }
                    if (next) break block20;
                    if (rolesMetaList.stream().filter(meta -> meta.getResources().contains("*")).count() != 0L) break block21;
                    String finalValue = value;
                    if (!rolesMetaList.stream().anyMatch(meta -> ValueMatcher.match(meta.getResources(), finalValue, paramType))) break block20;
                }
                AuthzDefender.logs("Forbid : permissions exception by request parameter", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.PERM_EXCEPTION);
                return false;
            }
            if ((permissionsMetaList = paramMetadata.getPermissionsMetaList()) == null || permissionsMetaList.isEmpty()) continue;
            if (httpMeta.getToken() == null) {
                AuthzDefender.logs("Require Login", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.REQUIRE_LOGIN);
                return false;
            }
            if (roles == null) {
                roles = Optional.ofNullable(httpMeta.getRoles()).orElse(this.permLibrary.getRolesByUserId(httpMeta.getToken().getUserId()));
                httpMeta.setRoles(roles);
            }
            if ((perms = httpMeta.getPermissions()) != null) {
                permissions = perms;
            } else {
                for (Object role2 : roles) {
                    Set<String> permissionsByRole = this.permLibrary.getPermissionsByRole((String)role2);
                    permissions.addAll(permissionsByRole);
                }
                httpMeta.setPermissions(permissions);
            }
            boolean bl2 = false;
            role2 = permissionsMetaList.iterator();
            while (role2.hasNext()) {
                PermRolesMeta.Meta meta3 = (PermRolesMeta.Meta)role2.next();
                if (!ValueMatcher.match(meta3.getResources(), value, paramType) || !CollectionUtils.containsSub(meta3.getRequire(), permissions)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (permissionsMetaList.stream().filter(meta -> meta.getResources().contains("*")).count() == 0L) {
                String finalValue = value;
                if (!permissionsMetaList.stream().anyMatch(meta -> ValueMatcher.match(meta.getResources(), finalValue, paramType))) continue;
            }
            AuthzDefender.logs("Forbid : permissions exception by request parameter", httpMeta, permRolesMeta);
            httpMeta.error(ExceptionStatus.PERM_EXCEPTION);
            return false;
        }
        return true;
    }
}

