/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.tk.Token;
import org.springframework.web.method.HandlerMethod;

@Order(value=10)
public class DeviceSlot
implements Slot {
    private final PermissionDict permissionDict;
    private final UserDevicesDict userDevicesDict;

    public DeviceSlot(PermissionDict permissionDict, UserDevicesDict userDevicesDict) {
        this.permissionDict = permissionDict;
        this.userDevicesDict = userDevicesDict;
    }

    @Override
    public boolean chain(HttpMeta httpMeta, HandlerMethod handler) {
        PermRolesMeta permRolesMeta = this.permissionDict.getAuthzMetadata().get(httpMeta.getMethod()).get(httpMeta.getApi());
        if (permRolesMeta.nonAll()) {
            return true;
        }
        if (!httpMeta.isHasToken()) {
            AuthzDefender.logs("Require Login", httpMeta, permRolesMeta);
            httpMeta.error(ExceptionStatus.REQUIRE_LOGIN);
            return false;
        }
        if (httpMeta.getTokenException() != null) {
            switch (httpMeta.getTokenException()) {
                case ExpiredJwtException: {
                    AuthzDefender.logs("Forbid : expired token exception", httpMeta, permRolesMeta);
                    httpMeta.error(ExceptionStatus.ACCESS_TOKEN_OVERDUE);
                    return false;
                }
                case MalformedJwtException: {
                    AuthzDefender.logs("Forbid : malformed token exception", httpMeta, permRolesMeta);
                    httpMeta.error(ExceptionStatus.TOKEN_EXCEPTION);
                    return false;
                }
                case SignatureException: {
                    AuthzDefender.logs("Forbid : signature exception", httpMeta, permRolesMeta);
                    httpMeta.error(ExceptionStatus.TOKEN_EXCEPTION);
                    return false;
                }
            }
        }
        Token accessToken = httpMeta.getToken();
        switch (this.userDevicesDict.userStatus(accessToken.getUserId(), accessToken.getDeviceType(), accessToken.getDeviceId(), accessToken.getTokenId())) {
            case 1: {
                AuthzDefender.logs("Forbid : expired token exception", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.ACCESS_TOKEN_OVERDUE);
                return false;
            }
            case 2: {
                AuthzDefender.logs("Require Login", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.REQUIRE_LOGIN);
                return false;
            }
            case 3: {
                AuthzDefender.logs("forbid : may have logged in elsewhere", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.LOGIN_EXCEPTION);
                return false;
            }
        }
        return true;
    }
}

