/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenHelper;
import cn.omisheep.commons.util.Async;
import cn.omisheep.web.utils.HttpUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.springframework.web.method.HandlerMethod;

@Order(value=0)
public class CookieAndRequestSlot
implements Slot {
    private final UserDevicesDict userDevicesDict;
    private final boolean isEnableRedis;
    private final String cookieName;
    private final String headerName;
    private final String headerPrefix;

    public CookieAndRequestSlot(UserDevicesDict userDevicesDict, PermLibrary permLibrary, AuthzProperties properties) {
        this.userDevicesDict = userDevicesDict;
        this.isEnableRedis = properties.getCache().isEnableRedis();
        this.cookieName = properties.getToken().getCookieName();
        this.headerName = properties.getToken().getHeaderName().toLowerCase(Locale.ROOT);
        this.headerPrefix = properties.getToken().getHeaderPrefix();
    }

    @Override
    public boolean chain(HttpMeta httpMeta, HandlerMethod handler) throws Exception {
        String tokenValue;
        block5: {
            Cookie cookie = HttpUtils.readSingleCookieInRequestByName((String)this.cookieName);
            tokenValue = null;
            String s = (String)HttpUtils.getCurrentRequestHeaders().get(this.headerName);
            if (s != null && s.startsWith(this.headerPrefix)) {
                tokenValue = s.substring(this.headerPrefix.length());
            }
            if (tokenValue == null && cookie != null) {
                tokenValue = cookie.getValue();
            }
            if (tokenValue != null) {
                try {
                    Token token = TokenHelper.parseToken(tokenValue);
                    httpMeta.setToken(token);
                    Async.run(this.userDevicesDict::request);
                }
                catch (Exception e) {
                    httpMeta.setTokenException(HttpMeta.TokenException.valueOf(e.getClass().getSimpleName()));
                    if (this.isEnableRedis || !(e instanceof ExpiredJwtException)) break block5;
                    Claims claims = ((ExpiredJwtException)((Object)e)).getClaims();
                    this.userDevicesDict.removeDeviceByUserIdAndAccessTokenId(claims.get((Object)"userId"), claims.getId());
                }
            }
        }
        httpMeta.setHasToken(tokenValue != null);
        return true;
    }
}

