/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.AuthzException;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.ExceptionUtils;
import java.util.Map;
import org.springframework.web.method.HandlerMethod;

@Order(value=1)
public class CheckerSlot
implements Slot {
    private final PermissionDict permissionDict;

    public CheckerSlot(PermissionDict permissionDict) {
        this.permissionDict = permissionDict;
    }

    @Override
    public boolean chain(HttpMeta httpMeta, HandlerMethod handler) {
        if (httpMeta == null || httpMeta.isMethod("OPTIONS")) {
            return false;
        }
        AuthzException exception = ExceptionUtils.get(httpMeta.getRequest());
        if (exception != null) {
            return false;
        }
        return this.requireProtect(httpMeta.getMethod(), httpMeta.getApi());
    }

    private boolean requireProtect(String method, String api) {
        Map<String, PermRolesMeta> map = this.permissionDict.getAuthzMetadata().get(method);
        if (map == null) {
            return false;
        }
        return map.get(api) != null;
    }
}

