/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;

@Order(value=30)
public class APIPermSlot
implements Slot {
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;

    public APIPermSlot(PermissionDict permissionDict, PermLibrary permLibrary) {
        this.permissionDict = permissionDict;
        this.permLibrary = permLibrary;
    }

    @Override
    public boolean chain(HttpMeta httpMeta, HandlerMethod handler) {
        PermRolesMeta permRolesMeta = this.permissionDict.getAuthzMetadata().get(httpMeta.getMethod()).get(httpMeta.getApi());
        if (permRolesMeta.non()) {
            return true;
        }
        Token accessToken = httpMeta.getToken();
        Set<String> roles = null;
        boolean e1 = CollectionUtils.isEmpty(permRolesMeta.getRequireRoles());
        boolean e2 = CollectionUtils.isEmpty(permRolesMeta.getExcludeRoles());
        if (!e1 || !e2) {
            long nowTime = TimeUtils.nowTime();
            roles = this.permLibrary.getRolesByUserId(accessToken.getUserId());
            httpMeta.setRoles(roles);
            LogUtils.logDebug("permLibrary.getRolesByUserId({})  {}", accessToken.getUserId(), TimeUtils.diff((long)nowTime));
            if (!e1 && !CollectionUtils.containsSub(permRolesMeta.getRequireRoles(), roles) || !e2 && CollectionUtils.containsSub(permRolesMeta.getExcludeRoles(), roles)) {
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.PERM_EXCEPTION);
                return false;
            }
        }
        boolean e3 = CollectionUtils.isEmpty(permRolesMeta.getRequirePermissions());
        boolean e4 = CollectionUtils.isEmpty(permRolesMeta.getExcludePermissions());
        if (!e3 || !e4) {
            if (e1 && e2) {
                long nowTime = TimeUtils.nowTime();
                roles = this.permLibrary.getRolesByUserId(accessToken.getUserId());
                httpMeta.setRoles(roles);
                LogUtils.logDebug("e1 && e2 permLibrary.getRolesByUserId({})  {}", accessToken.getUserId(), TimeUtils.diff((long)nowTime));
            }
            HashSet<String> perms = new HashSet<String>();
            for (String role : (Set)Optional.ofNullable(roles).orElse(new HashSet())) {
                long nowTime = TimeUtils.nowTime();
                Set<String> permissionsByRole = this.permLibrary.getPermissionsByRole(role);
                LogUtils.logDebug("permLibrary.getPermissionsByRole({}) {}", role, TimeUtils.diff((long)nowTime));
                perms.addAll(permissionsByRole);
                if (e4 || !CollectionUtils.containsSub(permRolesMeta.getExcludePermissions(), permissionsByRole)) continue;
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.PERM_EXCEPTION);
                return false;
            }
            if (!e3 && !CollectionUtils.containsSub(permRolesMeta.getRequirePermissions(), perms)) {
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                httpMeta.error(ExceptionStatus.PERM_EXCEPTION);
                return false;
            }
            httpMeta.setPermissions(perms);
        }
        AuthzDefender.logs("Success", httpMeta, permRolesMeta);
        return true;
    }
}

