/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.interceptor.mybatis;

import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.rpd.DataPermMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.interceptor.DataFinderSecurityInterceptor;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.ReflectUtils;
import java.sql.Connection;
import java.util.List;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataSecurityInterceptorForMybatis
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataSecurityInterceptorForMybatis.class);
    private ThreadLocal<ResultMap> resultMapThreadLocal = new ThreadLocal();
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;
    private final DataFinderSecurityInterceptor dataFinderSecurityInterceptor;

    public DataSecurityInterceptorForMybatis(PermissionDict permissionDict, PermLibrary permLibrary, DataFinderSecurityInterceptor dataFinderSecurityInterceptor) {
        this.permissionDict = permissionDict;
        this.permLibrary = permLibrary;
        this.dataFinderSecurityInterceptor = dataFinderSecurityInterceptor;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        if (target instanceof Executor) {
            MappedStatement ms = (MappedStatement)args[0];
            ResultMap resultMap = (ResultMap)ms.getResultMaps().get(0);
            this.resultMapThreadLocal.set(resultMap);
        } else {
            try {
                ResultMap resultMap = this.resultMapThreadLocal.get();
                StatementHandler rsh = (StatementHandler)target;
                BoundSql boundSql = rsh.getBoundSql();
                Class type = resultMap.getType();
                List<DataPermMeta> dataPermMetaList = this.permissionDict.getDataPermMetadata().get(type.getTypeName());
                String change = this.dataFinderSecurityInterceptor.change(AUtils.getCurrentHttpMeta(), this.permLibrary, dataPermMetaList, type, boundSql.getSql());
                System.out.println(change);
                ReflectUtils.setFieldValue((Object)boundSql, (String)"sql", (String)change);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("sql\u89e3\u6790\u5f02\u5e38\u6216\u5219\u53ef\u80fd\u5904\u4e8e\u975eweb\u73af\u5883");
                return invocation.proceed();
            }
        }
        return invocation.proceed();
    }
}

