/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.interceptor;

import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.DataPermMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.interceptor.DataFinderSecurityInterceptor;
import cn.omisheep.authz.core.util.ArgsParser;
import cn.omisheep.commons.util.CollectionUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;

public class DefaultDataSecurityInterceptor
implements DataFinderSecurityInterceptor {
    @Override
    public String change(HttpMeta httpMeta, PermLibrary permLibrary, List<DataPermMeta> dataPermMetaList, Class<?> resultType, String sql) throws JSQLParserException {
        if (dataPermMetaList.size() == 0) {
            return sql;
        }
        Set<String> rolesByUserId = Optional.ofNullable(httpMeta.getRoles()).orElse(permLibrary.getRolesByUserId(httpMeta.getUserId()));
        Set permissionsByRole = Optional.ofNullable(httpMeta.getPermissions()).orElseGet(() -> {
            HashSet perms = new HashSet();
            rolesByUserId.forEach(role -> perms.addAll(permLibrary.getPermissionsByRole((String)role)));
            return perms;
        });
        Iterator iterator = dataPermMetaList.stream().filter(dataPermMeta -> {
            PermRolesMeta.Meta roles = dataPermMeta.getRoles();
            if (roles != null) {
                return CollectionUtils.containsSub(roles.getRequire(), (Set)rolesByUserId);
            }
            PermRolesMeta.Meta permissions = dataPermMeta.getPermissions();
            if (permissions == null) {
                return false;
            }
            return CollectionUtils.containsSub(permissions.getRequire(), (Set)permissionsByRole);
        }).map(d -> ArgsParser.parse(d)).iterator();
        if (!iterator.hasNext()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next()).append(" AND ");
        }
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        PlainSelect selectBody = (PlainSelect)select.getSelectBody();
        sb.append(selectBody.getWhere());
        Expression securityWhere = CCJSqlParserUtil.parseCondExpression((String)sb.toString());
        return selectBody.withWhere(securityWhere).toString();
    }
}

