/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.interceptor;

import cn.omisheep.authz.annotation.Decrypt;
import cn.omisheep.authz.core.tk.AuKey;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.RsaHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestBodyAdvice.class);

    public boolean supports(MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return parameter.hasMethodAnnotation(Decrypt.class) || parameter.hasParameterAnnotation(Decrypt.class);
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return new DecryptRequestBodyHandler(inputMessage, AuKey.getPrivateKeyString());
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public class DecryptRequestBodyHandler
    implements HttpInputMessage {
        private final HttpHeaders headers;
        private final InputStream body;

        public DecryptRequestBodyHandler(HttpInputMessage inputMessage, String privateKey) throws IOException {
            this.headers = inputMessage.getHeaders();
            String content = new BufferedReader(new InputStreamReader(inputMessage.getBody())).lines().collect(Collectors.joining(System.lineSeparator()));
            String decrypt = RsaHelper.decrypt((String)AUtils.parse_RSA_JSON(content), (String)privateKey);
            if (decrypt == null) {
                decrypt = "{}";
            }
            this.body = new ByteArrayInputStream(decrypt.getBytes());
        }

        public InputStream getBody() {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

