/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.interceptor;

import cn.omisheep.authz.core.AuthzException;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.interceptor.AuthzExceptionHandler;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.Collection;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthzSlotCoreInterceptor
implements HandlerInterceptor {
    private final AuthzExceptionHandler authzExceptionHandler;
    private final LinkedList<Slot> slots = new LinkedList();

    public AuthzSlotCoreInterceptor(AuthzExceptionHandler authzExceptionHandler, Collection<Slot> slots) {
        this.authzExceptionHandler = authzExceptionHandler;
        slots.stream().sorted((v1, v2) -> {
            Order orderV1 = (Order)AnnotationUtils.getAnnotation(v1.getClass(), Order.class);
            Order orderV2 = (Order)AnnotationUtils.getAnnotation(v2.getClass(), Order.class);
            return (orderV1 != null ? orderV1.order() : v1.order()) - (orderV2 != null ? orderV2.order() : v2.order());
        }).forEach(this.slots::offer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean bl;
        long nowTime;
        block8: {
            HttpMeta httpMeta = (HttpMeta)request.getAttribute("AU_HTTP_META");
            AuthzException httpException = httpMeta.getAuthzException();
            if (httpException != null) {
                LogUtils.exportLogsFromRequest(request);
                return this.authzExceptionHandler.handle(request, response, httpException);
            }
            if (!(handler instanceof HandlerMethod)) {
                return false;
            }
            nowTime = TimeUtils.nowTime();
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            boolean next = true;
            for (Slot slot : this.slots) {
                if (!next && !slot.must()) continue;
                next = slot.chain(httpMeta, handlerMethod);
            }
            AuthzException exception = httpMeta.getAuthzException();
            if (exception == null) break block8;
            boolean bl2 = this.authzExceptionHandler.handle(request, response, exception);
            LogUtils.logDebug("preHandle {}", TimeUtils.diff((long)nowTime));
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                e.printStackTrace();
                LogUtils.logError(e.getMessage(), e.getCause());
                bl3 = this.authzExceptionHandler.handle(request, response, new AuthzException(e.getCause(), ExceptionStatus.UNKNOWN));
            }
            catch (Throwable throwable) {
                LogUtils.logDebug("preHandle {}", TimeUtils.diff((long)nowTime));
                throw throwable;
            }
            LogUtils.logDebug("preHandle {}", TimeUtils.diff((long)nowTime));
            return bl3;
        }
        LogUtils.logDebug("preHandle {}", TimeUtils.diff((long)nowTime));
        return bl;
    }
}

