/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.init;

import cn.omisheep.authz.annotation.Arg;
import cn.omisheep.authz.annotation.ArgResource;
import cn.omisheep.authz.annotation.AuthzResourcesScan;
import cn.omisheep.authz.annotation.BatchAuthority;
import cn.omisheep.authz.annotation.Perms;
import cn.omisheep.authz.annotation.Roles;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.DataPermMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.init.AuCoreInitialization;
import cn.omisheep.commons.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.NonNull;

public class AuthzResourcesInit
implements ImportSelector {
    private DataPermMeta generateDataPermMeta(Perms perms) {
        Arg[] conditionArgs;
        DataPermMeta dataPermMeta = DataPermMeta.of(perms.condition());
        for (Arg arg : conditionArgs = perms.conditionArgs()) {
            String resource = arg.resource();
            String[] resourceArgs = arg.args();
            dataPermMeta.addArg(resource, resourceArgs);
        }
        dataPermMeta.setPermissions(AuCoreInitialization.generatePermMeta(perms, false).setResources(null));
        return dataPermMeta;
    }

    private DataPermMeta generateDataRolesMeta(Roles roles) {
        Arg[] conditionArgs;
        DataPermMeta dataPermMeta = DataPermMeta.of(roles.condition());
        for (Arg arg : conditionArgs = roles.conditionArgs()) {
            String resource = arg.resource();
            String[] resourceArgs = arg.args();
            dataPermMeta.addArg(resource, resourceArgs);
        }
        dataPermMeta.setRoles(AuCoreInitialization.generateRolesMeta(roles, false).setResources(null));
        return dataPermMeta;
    }

    private Object[] dataPerm(String className) {
        try {
            Class<?> aClass = Class.forName(className);
            ArrayList<Roles> rolesList = new ArrayList<Roles>();
            ArrayList<Perms> permsList = new ArrayList<Perms>();
            Roles roles = (Roles)AnnotationUtils.getAnnotation(aClass, Roles.class);
            Perms perms = (Perms)AnnotationUtils.getAnnotation(aClass, Perms.class);
            BatchAuthority batchAuthority = (BatchAuthority)AnnotationUtils.getAnnotation(aClass, BatchAuthority.class);
            rolesList.add(roles);
            permsList.add(perms);
            if (batchAuthority != null) {
                rolesList.addAll(Arrays.asList(batchAuthority.roles()));
                permsList.addAll(Arrays.asList(batchAuthority.perms()));
            }
            List dataPermMetaList = Stream.concat(rolesList.stream().filter(Objects::nonNull).map(this::generateDataRolesMeta), permsList.stream().filter(Objects::nonNull).map(this::generateDataPermMeta)).collect(Collectors.toList());
            return new Object[]{className, dataPermMetaList};
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NonNull
    public String[] selectImports(AnnotationMetadata annotationMetadata) {
        Map annotationAttributes = annotationMetadata.getAnnotationAttributes(AuthzResourcesScan.class.getName());
        String[] entityBasePackages = new String[]{};
        if (annotationAttributes != null) {
            entityBasePackages = (String[])annotationAttributes.get("entity");
        }
        ClassPathScanningCandidateComponentProvider scannerEntity = new ClassPathScanningCandidateComponentProvider(false);
        scannerEntity.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Object.class));
        HashSet<String> entityClasses = new HashSet<String>();
        Arrays.stream(entityBasePackages).forEach(basePackage -> scannerEntity.findCandidateComponents(basePackage).stream().map(BeanDefinition::getBeanClassName).forEach(entityClasses::add));
        PermissionDict.addAuthzResourcesNames(entityClasses);
        HashMap<String, List<DataPermMeta>> map = new HashMap<String, List<DataPermMeta>>();
        entityClasses.stream().map(this::dataPerm).filter(Objects::nonNull).forEach(o -> map.put((String)o[0], (List)o[1]));
        PermissionDict.initDataPerm(map);
        String[] argsBasePackages = new String[]{};
        if (annotationAttributes != null) {
            argsBasePackages = (String[])annotationAttributes.get("args");
        }
        HashMap<String, PermissionDict.ArgsMeta> argMap = new HashMap<String, PermissionDict.ArgsMeta>();
        Arrays.stream(argsBasePackages).forEach(basePackage -> ClassUtils.getClassSet((String)basePackage).forEach(type -> Arrays.stream(type.getMethods()).filter(method -> method.isAnnotationPresent(ArgResource.class)).forEach(method -> {
            String name = ((ArgResource)AnnotationUtils.getAnnotation((Method)method, ArgResource.class)).name();
            if (Objects.equals(name, "")) {
                name = method.getName();
            }
            argMap.put(name, PermissionDict.ArgsMeta.of(type, method));
        })));
        argMap.put("token", PermissionDict.ArgsMeta.of(HttpMeta.class, "currentToken", new Class[0]));
        argMap.put("userId", PermissionDict.ArgsMeta.of(HttpMeta.class, "currentUserId", new Class[0]));
        PermissionDict.initArgs(argMap);
        return new String[0];
    }
}

