/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.init;

import cn.omisheep.authz.annotation.BatchAuthority;
import cn.omisheep.authz.annotation.Perms;
import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.annotation.Roles;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.Pelcron;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.DeviceConfig;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.init.AuInit;
import cn.omisheep.authz.core.msg.Message;
import cn.omisheep.authz.core.tk.AuKey;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.authz.core.util.ValueMatcher;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TaskBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class AuCoreInitialization
implements ApplicationContextAware {
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    private final AuthzProperties properties;
    private final Httpd httpd;
    private final UserDevicesDict userDevicesDict;
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;
    private final Cache cache;
    private ApplicationContext ctx;

    public AuCoreInitialization(AuthzProperties properties, Httpd httpd, UserDevicesDict userDevicesDict, PermissionDict permissionDict, PermLibrary permLibrary, Cache cache) {
        this.properties = properties;
        this.httpd = httpd;
        this.userDevicesDict = userDevicesDict;
        this.permissionDict = permissionDict;
        this.cache = cache;
        this.permLibrary = permLibrary;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.ctx = applicationContext;
        AbstractHandlerMethodMapping methodMapping = (AbstractHandlerMethodMapping)applicationContext.getBean("requestMappingHandlerMapping");
        Map mapRet = methodMapping.getHandlerMethods();
        this.initPermissionDict(applicationContext, mapRet);
        LogUtils.logDebug("\u2b07 PermissionDict init success \u2b07\n{}\n", AUtils.beautifulJson(this.permissionDict));
        this.initHttpd(applicationContext, mapRet);
        LogUtils.logDebug("\u2b07 Httpd init success \u2b07\n{}\n", AUtils.beautifulJson(this.httpd));
        this.initUserDevicesDict();
        LogUtils.logDebug("UserDevicesDict init success", new Object[0]);
        TaskBuilder.schedule(AuKey::refreshKeyGroup, (String)this.properties.getRsaKeyRefreshWithPeriod());
        if (!this.properties.getCache().isEnableRedis()) {
            TaskBuilder.schedule(Pelcron::activeExpireCycle, (String)this.properties.getUserBufferRefreshWithPeriod());
        }
        TaskBuilder.schedule(Pelcron::GC, (String)this.properties.getGcPeriod());
        AuInit.log.info("Started Authz  Message id: {}", (Object)Message.uuid);
    }

    private void initPermissionDict(ApplicationContext applicationContext, Map<RequestMappingInfo, HandlerMethod> mapRet) {
        PermissionDict.setPermSeparator(",");
        HashSet toBeLoadedRoles = new HashSet();
        HashMap<String, Map<String, PermRolesMeta>> authzMetadata = new HashMap<String, Map<String, PermRolesMeta>>();
        HashMap pMap = new HashMap();
        HashMap rMap = new HashMap();
        applicationContext.getBeansWithAnnotation(Perms.class).forEach((key, value) -> pMap.put(value.getClass().getName(), AuCoreInitialization.generatePermRolesMeta((Perms)AnnotationUtils.getAnnotation(value.getClass(), Perms.class), null)));
        applicationContext.getBeansWithAnnotation(Roles.class).forEach((key, value) -> rMap.put(value.getClass().getName(), AuCoreInitialization.generatePermRolesMeta(null, (Roles)AnnotationUtils.getAnnotation(value.getClass(), Roles.class))));
        mapRet.forEach((key, value) -> {
            PermRolesMeta pFc = (PermRolesMeta)pMap.get(value.getBeanType().getName());
            PermRolesMeta rFc = (PermRolesMeta)rMap.get(value.getBeanType().getName());
            PermRolesMeta permRolesMeta = AuCoreInitialization.generatePermRolesMeta((Perms)value.getMethodAnnotation(Perms.class), (Roles)value.getMethodAnnotation(Roles.class));
            if (rFc != null) {
                if (permRolesMeta.getRequireRoles() != null) {
                    permRolesMeta.getRequireRoles().addAll(rFc.getRequireRoles());
                } else {
                    permRolesMeta.setExcludeRoles(rFc.getRequireRoles());
                }
                if (permRolesMeta.getExcludeRoles() != null) {
                    permRolesMeta.getExcludeRoles().addAll(rFc.getExcludeRoles());
                } else {
                    permRolesMeta.setExcludeRoles(rFc.getExcludeRoles());
                }
            }
            if (pFc != null) {
                if (permRolesMeta.getRequirePermissions() != null) {
                    permRolesMeta.getRequirePermissions().addAll(pFc.getRequirePermissions());
                } else {
                    permRolesMeta.setRequirePermissions(rFc.getRequirePermissions());
                }
                if (permRolesMeta.getExcludePermissions() != null) {
                    permRolesMeta.getExcludePermissions().addAll(pFc.getExcludePermissions());
                } else {
                    permRolesMeta.setExcludePermissions(rFc.getExcludePermissions());
                }
            }
            if (permRolesMeta != null) {
                Set<Set<String>> requireRoles = permRolesMeta.getRequireRoles();
                Set<Set<String>> excludeRoles = permRolesMeta.getExcludeRoles();
                if (requireRoles != null) {
                    requireRoles.forEach(toBeLoadedRoles::addAll);
                }
                if (excludeRoles != null) {
                    excludeRoles.forEach(toBeLoadedRoles::addAll);
                }
                key.getMethodsCondition().getMethods().forEach(method -> key.getPatternsCondition().getPatterns().forEach(patternValue -> authzMetadata.computeIfAbsent(method.toString(), r -> new HashMap()).put(this.contextPath + patternValue, permRolesMeta)));
            }
            key.getMethodsCondition().getMethods().forEach(method -> key.getPatternsCondition().getPatterns().forEach(patternValue -> {
                for (MethodParameter param : value.getMethodParameters()) {
                    Class<?> paramType = param.getParameter().getType();
                    if (ValueMatcher.checkType(paramType).isOther()) continue;
                    Roles rolesByParam = (Roles)param.getParameterAnnotation(Roles.class);
                    Perms permsByParam = (Perms)param.getParameterAnnotation(Perms.class);
                    BatchAuthority batchAuthority = (BatchAuthority)param.getParameterAnnotation(BatchAuthority.class);
                    if (rolesByParam == null && permsByParam == null && batchAuthority == null) continue;
                    RequestParam requestParam = (RequestParam)param.getParameterAnnotation(RequestParam.class);
                    PathVariable pathVariable = (PathVariable)param.getParameterAnnotation(PathVariable.class);
                    String paramName = param.getParameter().getName();
                    ParamMetadata.ParamType type = null;
                    if (pathVariable != null) {
                        type = ParamMetadata.ParamType.PATH_VARIABLE;
                        if (!pathVariable.name().equals("")) {
                            paramName = pathVariable.name();
                        }
                    } else if (requestParam != null) {
                        type = ParamMetadata.ParamType.REQUEST_PARAM;
                        if (!requestParam.name().equals("")) {
                            paramName = requestParam.name();
                        }
                    }
                    ArrayList<PermRolesMeta.Meta> rolesMetaList = new ArrayList<PermRolesMeta.Meta>();
                    ArrayList<PermRolesMeta.Meta> permsMetaList = new ArrayList<PermRolesMeta.Meta>();
                    PermRolesMeta.Meta vr = AuCoreInitialization.generateRolesMeta(rolesByParam, true);
                    PermRolesMeta.Meta vp = AuCoreInitialization.generatePermMeta(permsByParam, true);
                    if (vr != null) {
                        rolesMetaList.add(vr);
                    }
                    if (vp != null) {
                        permsMetaList.add(vp);
                    }
                    if (batchAuthority != null) {
                        Perms[] ps;
                        Roles[] rs;
                        for (Roles r2 : rs = batchAuthority.roles()) {
                            PermRolesMeta.Meta v = AuCoreInitialization.generateRolesMeta(r2, true);
                            if (v == null) continue;
                            rolesMetaList.add(v);
                            if (v.getRequire() != null) {
                                v.getRequire().forEach(toBeLoadedRoles::addAll);
                            }
                            if (v.getExclude() == null) continue;
                            v.getExclude().forEach(toBeLoadedRoles::addAll);
                        }
                        for (Perms p : ps = batchAuthority.perms()) {
                            PermRolesMeta.Meta v = AuCoreInitialization.generatePermMeta(p, true);
                            if (v == null) continue;
                            permsMetaList.add(v);
                        }
                    }
                    if (type == null) continue;
                    PermRolesMeta meta = authzMetadata.computeIfAbsent(method.toString(), r -> new HashMap()).computeIfAbsent(this.contextPath + patternValue, r -> new PermRolesMeta());
                    meta.put(type, paramName, new ParamMetadata().setParamType(paramType).setRolesMetaList(rolesMetaList).setPermissionsMetaList(permsMetaList));
                }
            }));
        });
        try {
            PermissionDict.initAuthzMetadata(authzMetadata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PermissionDict.init(this.permissionDict);
        Async.run(() -> {
            List collect = toBeLoadedRoles.stream().collect(Collectors.toList());
            List rolesPerms = RedisUtils.Obj.get(collect.stream().map(role -> "au:permissionsByRole:" + role).collect(Collectors.toList()));
            Iterator iterator = collect.iterator();
            HashMap<String, Set> map = new HashMap<String, Set>();
            rolesPerms.forEach(perms -> map.put((String)iterator.next(), (Set)perms));
            map.forEach((role, v) -> {
                Set<String> permissions = this.permLibrary.getPermissionsByRole((String)role);
                this.cache.setSneaky("au:permissionsByRole:" + role, permissions, Integer.MAX_VALUE);
            });
        });
    }

    public static PermRolesMeta.Meta generatePermMeta(Perms p, boolean hasDefault) {
        if (p == null) {
            return null;
        }
        PermRolesMeta.Meta permsMeta = new PermRolesMeta.Meta();
        boolean flag = false;
        if (p.require() != null && p.require().length != 0) {
            permsMeta.setRequire(CollectionUtils.splitStrValsToSets((String)",", (String[])p.require()));
            flag = true;
        }
        if (p.exclude() != null && p.exclude().length != 0) {
            permsMeta.setExclude(CollectionUtils.splitStrValsToSets((String)",", (String[])p.exclude()));
            flag = true;
        }
        if (p.resources().length == 0) {
            if (hasDefault) {
                permsMeta.setResources(CollectionUtils.newSet((Object[])new String[]{"*"}));
            }
        } else {
            permsMeta.setResources(CollectionUtils.newSet((Object[])p.resources()));
        }
        return flag ? permsMeta : null;
    }

    public static PermRolesMeta.Meta generateRolesMeta(Roles r, boolean hasDefault) {
        if (r == null) {
            return null;
        }
        PermRolesMeta.Meta rolesMeta = new PermRolesMeta.Meta();
        boolean flag = false;
        if (r.require() != null && r.require().length != 0) {
            rolesMeta.setRequire(CollectionUtils.splitStrValsToSets((String)",", (String[])r.require()));
            flag = true;
        }
        if (r.exclude() != null && r.exclude().length != 0) {
            rolesMeta.setExclude(CollectionUtils.splitStrValsToSets((String)",", (String[])r.exclude()));
            flag = true;
        }
        if (r.resources().length == 0) {
            if (hasDefault) {
                rolesMeta.setResources(CollectionUtils.newSet((Object[])new String[]{"*"}));
            }
        } else {
            rolesMeta.setResources(CollectionUtils.newSet((Object[])r.resources()));
        }
        return flag ? rolesMeta : null;
    }

    public static PermRolesMeta generatePermRolesMeta(Perms p, Roles r) {
        PermRolesMeta prm = new PermRolesMeta();
        boolean flag = false;
        if (p != null) {
            if (p.require() != null && p.require().length != 0) {
                prm.setRequirePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])p.require()));
            }
            if (p.exclude() != null && p.exclude().length != 0) {
                prm.setExcludePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])p.exclude()));
            }
            flag = true;
        }
        if (r != null) {
            if (r.require() != null && r.require().length != 0) {
                prm.setRequireRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.require()));
            }
            if (r.exclude() != null && r.exclude().length != 0) {
                prm.setExcludeRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.exclude()));
            }
            flag = true;
        }
        return flag ? prm : null;
    }

    private void initHttpd(ApplicationContext applicationContext, Map<RequestMappingInfo, HandlerMethod> mapRet) {
        Map<String, Map<String, LimitMeta>> httpdLimitedMetaMap = this.httpd.getRateLimitMetadata();
        HashMap cMap = new HashMap();
        applicationContext.getBeansWithAnnotation(RateLimit.class).forEach((key, value) -> {
            Class aClass = AopUtils.getTargetClass((Object)value);
            RateLimit rateLimit = aClass.getAnnotation(RateLimit.class);
            if (rateLimit != null) {
                cMap.put(aClass.getName(), new LimitMeta(rateLimit.window(), rateLimit.maxRequests(), rateLimit.punishmentTime(), rateLimit.minInterval(), rateLimit.associatedPatterns(), rateLimit.bannedType()));
            }
        });
        mapRet.forEach((key, value) -> {
            Set methods = key.getMethodsCondition().getMethods();
            Set patternValues = key.getPatternsCondition().getPatterns();
            RateLimit rateLimit = (RateLimit)value.getMethodAnnotation(RateLimit.class);
            if (rateLimit != null) {
                LimitMeta limitMeta = new LimitMeta(rateLimit.window(), rateLimit.maxRequests(), rateLimit.punishmentTime(), rateLimit.minInterval(), rateLimit.associatedPatterns(), rateLimit.bannedType());
                methods.forEach(method -> patternValues.forEach(patternValue -> httpdLimitedMetaMap.computeIfAbsent(method.toString(), r -> new HashMap()).put(this.contextPath + patternValue, limitMeta)));
            } else {
                methods.forEach(method -> patternValues.forEach(patternValue -> {
                    LimitMeta limitMeta = (LimitMeta)cMap.get(value.getBeanType().getName());
                    if (limitMeta != null) {
                        httpdLimitedMetaMap.computeIfAbsent(method.toString(), r -> new HashMap()).put(this.contextPath + patternValue, limitMeta);
                    }
                }));
            }
            HashMap requestPool = new HashMap();
            key.getMethodsCondition().getMethods().forEach(method -> {
                key.getPatternsCondition().getPatterns().forEach(patternValue -> requestPool.put(this.contextPath + patternValue, new Httpd.RequestPool()));
                this.httpd.getRequestPools().computeIfAbsent(method.toString(), r -> new ConcurrentHashMap()).putAll(requestPool);
            });
        });
    }

    private void initUserDevicesDict() {
        DeviceConfig.isSupportMultiDevice = this.properties.getUser().isSupportMultiDevice();
        DeviceConfig.isSupportMultiUserForSameDeviceType = this.properties.getUser().isSupportMultiUserForSameDeviceType();
    }
}

