/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache;

import cn.omisheep.authz.core.cache.Cache;
import java.util.HashSet;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class PermLibraryCache {
    private static final Logger log = LoggerFactory.getLogger(PermLibraryCache.class);
    private final Cache cache;

    public PermLibraryCache(Cache cache) {
        this.cache = cache;
    }

    @Around(value="execution(* cn.omisheep.authz.core.auth.PermLibrary+.getRolesByUserId(..))")
    public Object Before(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        if (args.length != 1) {
            return joinPoint.proceed();
        }
        return this.handle("au:userRoles:" + args[0], joinPoint);
    }

    @Around(value="execution(* cn.omisheep.authz.core.auth.PermLibrary+.getPermissionsByRole(..))")
    public Object Before2(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Class[] parameterTypes = methodSignature.getParameterTypes();
        if (parameterTypes.length != 1 || parameterTypes[0] != String.class) {
            return joinPoint.proceed();
        }
        return this.handle("au:permissionsByRole:" + args[0], joinPoint);
    }

    private Object handle(String key, ProceedingJoinPoint joinPoint) throws Throwable {
        Object o = this.cache.get(key);
        if (o != null) {
            return o;
        }
        if (this.cache.notKey(key)) {
            Object result = joinPoint.proceed();
            this.cache.set(key, result, Integer.MAX_VALUE);
            if (result == null) {
                return new HashSet();
            }
            return result;
        }
        return new HashSet();
    }
}

