/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.msg.CacheMessage;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.commons.util.Utils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.collections.UnmodifiableObservableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javafx.collections.ObservableMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class L2Cache
implements Cache {
    private final LoadingCache<String, Cache.CacheItem> cache;

    public L2Cache(AuthzProperties properties) {
        Caffeine caffeine = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry(TimeUtils.parseTimeValue((String)properties.getCache().getExpireAfterReadOrUpdateTime()), TimeUnit.MILLISECONDS));
        Long cacheMaximumSize = properties.getCache().getCacheMaximumSize();
        if (cacheMaximumSize != null) {
            caffeine.maximumSize(cacheMaximumSize.longValue());
        }
        this.cache = caffeine.build((CacheLoader)new CacheLoader<String, Cache.CacheItem>(){

            public @Nullable Cache.CacheItem load(@NonNull String key) {
                boolean b;
                Object o = RedisUtils.Obj.get(key);
                long ttl = RedisUtils.ttl(key);
                boolean bl = b = ttl != -2L;
                if (key.startsWith("au:userRoles:") || key.startsWith("au:permissionsByRole:")) {
                    ttl = Integer.MAX_VALUE;
                }
                if (o != null) {
                    return new Cache.CacheItem<Object>(ttl, o);
                }
                if (b) {
                    return new Cache.CacheItem<Object>(ttl, null);
                }
                return null;
            }

            public @NonNull Map<@NonNull String, @NonNull Cache.CacheItem> loadAll(@NonNull Iterable<? extends @NonNull String> keys) {
                ArrayList<String> list = new ArrayList<String>();
                keys.forEach(list::add);
                List objects = RedisUtils.Obj.get(list);
                HashMap<String, Cache.CacheItem> map = new HashMap<String, Cache.CacheItem>();
                Iterator<? extends @NonNull String> iterator = keys.iterator();
                for (Object o : objects) {
                    boolean b;
                    String key = iterator.next();
                    long ttl = RedisUtils.ttl(key);
                    boolean bl = b = ttl != -2L;
                    if (key.startsWith("au:userRoles:") || key.startsWith("au:permissionsByRole:")) {
                        ttl = Integer.MAX_VALUE;
                    }
                    if (o != null) {
                        map.put(key, new Cache.CacheItem(ttl, o));
                        continue;
                    }
                    if (!b) continue;
                    map.put(key, new Cache.CacheItem<Object>(ttl, null));
                }
                return map;
            }
        });
    }

    @Override
    public @NonNull Set<String> keys(String pattern) {
        Cache.CacheItem cacheItem = (Cache.CacheItem)this.cache.asMap().get(pattern);
        if (cacheItem != null) {
            return (Set)cacheItem.value;
        }
        Set<String> scan = RedisUtils.scan(pattern);
        RedisUtils.publish("AU_CACHE_DATA_UPDATE", CacheMessage.write(pattern, scan));
        if (!scan.isEmpty()) {
            this.cache.put((Object)pattern, new Cache.CacheItem<Set<String>>(scan));
        }
        return scan;
    }

    @Override
    public @NonNull Set<String> keysAndLoad(String pattern) {
        Set<String> keys = this.keys(pattern);
        this.cache.getAll(keys);
        return keys;
    }

    @Override
    public boolean notKey(String key) {
        return key == null || this.cache.get((Object)key) == null;
    }

    @Override
    public long ttl(String key) {
        return RedisUtils.ttl(key);
    }

    @Override
    public @Nullable Object get(String key) {
        Cache.CacheItem item = (Cache.CacheItem)this.cache.get((Object)key);
        return item != null ? item.value : null;
    }

    @Override
    public @NonNull Map<String, Object> get(Set<String> keys) {
        return new HashMap<String, Object>(this.cache.getAll(keys));
    }

    @Override
    public <T> @NonNull Map<String, T> get(Set<String> keys, Class<T> requiredType) {
        Map items = this.cache.getAll(keys);
        HashMap map = new HashMap();
        for (Map.Entry entry : items.entrySet()) {
            map.put(entry.getKey(), Utils.castValue(entry.getValue(), requiredType));
        }
        return map;
    }

    @Override
    public <E> E set(String key, E element, long ttl) {
        E e = this.setSneaky(key, element, ttl);
        RedisUtils.publish("AU_CACHE_DATA_UPDATE", CacheMessage.write(key));
        return e;
    }

    @Override
    public <E> void setSneaky(String key, E element, long number, TimeUnit unit) {
        this.setSneaky(key, element, unit.toSeconds(number));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E setSneaky(String key, E element, long ttl) {
        if (ttl == 0L) {
            return element;
        }
        try {
            if (ttl == -1L) {
                RedisUtils.Obj.update(key, element);
            } else if (ttl == Integer.MAX_VALUE) {
                RedisUtils.Obj.set(key, element);
            } else {
                RedisUtils.Obj.set(key, element, ttl);
            }
        }
        catch (Exception e) {
            LogUtils.logError("{}", e.getMessage());
        }
        finally {
            this.cache.put((Object)key, new Cache.CacheItem<E>(ttl, element));
        }
        return element;
    }

    @Override
    public void del(String key) {
        this.cache.invalidate((Object)key);
        Async.run(() -> {
            RedisUtils.Obj.del(key);
            RedisUtils.publish("AU_CACHE_DATA_UPDATE", CacheMessage.delete(key));
        });
    }

    @Override
    public void del(Set<String> keys) {
        this.cache.invalidateAll(keys);
        Async.run(() -> {
            RedisUtils.Obj.del(keys);
            RedisUtils.publish("AU_CACHE_DATA_UPDATE", CacheMessage.delete(keys));
        });
    }

    @Override
    public void receive(CacheMessage message) {
        if (CacheMessage.Type.WRITE.equals((Object)message.getType())) {
            this.setSync(message);
        } else {
            this.delSync(message.getKeys());
        }
    }

    private void setSync(CacheMessage message) {
        Set<String> keys = message.getKeys();
        String pattern = message.getPattern();
        if (pattern != null) {
            this.cache.put((Object)pattern, new Cache.CacheItem<Set<String>>(keys));
        } else {
            String key = CollectionUtils.resolveSingletonSet(keys);
            Object o = RedisUtils.Obj.get(key);
            long ttl = RedisUtils.ttl(key);
            if (ttl != -2L) {
                this.cache.put((Object)key, new Cache.CacheItem<Object>(ttl, o));
            } else {
                this.cache.invalidate((Object)key);
            }
        }
    }

    private void delSync(Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        this.cache.invalidateAll(keys);
    }

    @Override
    public void reload() {
        ConcurrentMap map = this.cache.asMap();
        for (Map.Entry next : map.entrySet()) {
            String key = (String)next.getKey();
            Cache.CacheItem<Object> item = new Cache.CacheItem<Object>(RedisUtils.ttl((String)next.getKey()), RedisUtils.Obj.get((String)next.getKey()));
            map.remove(key);
            map.put(key, item);
        }
    }

    @Override
    public Map<String, Cache.CacheItem> asMap() {
        return new UnmodifiableObservableMap((ObservableMap)new ObservableMapWrapper((Map)this.cache.asMap()));
    }
}

