/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache;

import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.commons.util.Utils;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultCache
implements Cache {
    com.github.benmanes.caffeine.cache.Cache<String, Cache.CacheItem> cache;

    public DefaultCache(Long maximumSize, String time) {
        this.cache = maximumSize == null ? Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry(TimeUtils.parseTimeValue((String)time), TimeUnit.MILLISECONDS)).build() : Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry(TimeUtils.parseTimeValue((String)time), TimeUnit.MILLISECONDS)).maximumSize(maximumSize.longValue()).build();
    }

    public DefaultCache() {
        this.cache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry()).build();
    }

    @Override
    public @NonNull Set<String> keys(String pattern) {
        if (pattern == null || pattern.equals("")) {
            return new HashSet<String>();
        }
        if (pattern.equals("*")) {
            return this.cache.asMap().keySet();
        }
        return this.cache.asMap().keySet().stream().filter(key -> Utils.stringMatch((String)pattern, (String)key, (boolean)true)).collect(Collectors.toSet());
    }

    @Override
    public boolean notKey(String key) {
        return this.cache.getIfPresent((Object)key) == null;
    }

    @Override
    public long ttl(String key) {
        Cache.CacheItem item = (Cache.CacheItem)this.cache.getIfPresent((Object)key);
        if (item == null) {
            return -2L;
        }
        return item.ttl();
    }

    @Override
    public <E> E set(String key, E element, long ttl) {
        this.cache.put((Object)key, new Cache.CacheItem<E>(ttl, element));
        return element;
    }

    @Override
    public Object get(String key) {
        Cache.CacheItem item = (Cache.CacheItem)this.cache.getIfPresent((Object)key);
        return item == null ? null : item.value;
    }

    @Override
    public @NonNull Map<String, Object> get(Set<String> keys) {
        return new HashMap<String, Object>(this.cache.getAllPresent(keys));
    }

    @Override
    public <T> @NonNull Map<String, T> get(Set<String> keys, Class<T> requiredType) {
        Map items = this.cache.getAllPresent(keys);
        HashMap map = new HashMap();
        for (Map.Entry entry : items.entrySet()) {
            map.put(entry.getKey(), Utils.castValue(entry.getValue(), requiredType));
        }
        return map;
    }

    @Override
    public void del(String key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void del(Set<String> keys) {
        this.cache.invalidateAll(keys);
    }
}

