/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Rule {
    private List<Rule> rules;
    private String field;
    private Op op;
    private String value;
    private static final Pattern compile = Pattern.compile("(.*?)(=|!=|<=|<|>=|>|[nN][oO][tT] *?[iI][nN]|[iI][nN]|[nN][oO][tT] *?[lL][iL][kK][eE]|[lL][iI][kK][eE])(.*)");

    public String getOp() {
        if (this.op == null) {
            return null;
        }
        return this.op.keyword;
    }

    public Rule setOp(String op) {
        if (op == null) {
            return this;
        }
        if (op.equals("")) {
            return this;
        }
        String s = op.trim().toUpperCase(Locale.ROOT);
        try {
            this.op = Op.valueOf(s);
        }
        catch (Exception e) {
            for (Op v : Op.values()) {
                if (!v.keyword.equals(s)) continue;
                this.op = v;
                break;
            }
        }
        return this;
    }

    public static Rule of(String info) {
        Matcher matcher = compile.matcher(info);
        if (matcher.find()) {
            return new Rule().setField(matcher.group(1)).setOp(matcher.group(2)).setValue(matcher.group(3));
        }
        return null;
    }

    public static Rule or(Rule rule1, Rule rule2) {
        return new Rule().setOp("or").setRules(Arrays.asList(rule1, rule2));
    }

    public static Rule and(Rule ... rules) {
        return new Rule().setOp("and").setRules(Arrays.asList(rules));
    }

    public Rule setRules(List<Rule> rules) {
        this.rules = rules;
        return this;
    }

    public Rule setField(String field) {
        if (field != null) {
            field = field.trim();
        }
        this.field = field;
        return this;
    }

    public Rule setValue(String value) {
        if (value != null) {
            value = value.trim();
        }
        this.value = value;
        return this;
    }

    public String valueShow() {
        return this.field + " " + this.op.keyword + " " + this.value;
    }

    public String toString() {
        return "Rule(rules=" + this.getRules() + ", field=" + this.getField() + ", op=" + this.getOp() + ", value=" + this.getValue() + ")";
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    static enum Op {
        AND("AND"),
        OR("OR"),
        NOT_LIKE("NOT IN"),
        IN("IN"),
        NOT_IN("NOT LIKE"),
        LIKE("LIKE"),
        EQ("="),
        NE("!="),
        LE("<="),
        LT("<"),
        GE(">="),
        GT(">");

        private final String keyword;

        private Op(String keyword) {
            this.keyword = keyword;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

