/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.auth.rpd.DataPermMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.init.AuInit;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.authz.core.util.LogUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Objects;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.collections.UnmodifiableObservableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.ObservableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionDict {
    private static final Logger log = LoggerFactory.getLogger(PermissionDict.class);
    private static PermissionDict SELF;
    private static Map<String, Map<String, PermRolesMeta>> authzMetadata;
    private static Map<String, ArgsMeta> argsMetadata;
    private static Map<String, List<DataPermMeta>> dataPermMetadata;
    private static final Map<String, Map<String, Object>> authzResourcesNameAndTemplate;
    private static Map<String, Map<String, PermRolesMeta>> m1;
    private static Map<String, Map<String, Object>> m2;
    private static Map<String, List<DataPermMeta>> m3;
    private static Map<String, ArgsMeta> m4;
    private static String permSeparator;

    public static PermissionDict self() {
        return SELF;
    }

    public Map<String, Map<String, PermRolesMeta>> getAuthzMetadata() {
        return m1;
    }

    public Map<String, Map<String, Object>> getAuthzResourcesNameAndTemplate() {
        return m2;
    }

    public Map<String, List<DataPermMeta>> getDataPermMetadata() {
        return m3;
    }

    public Map<String, ArgsMeta> getArgsMetadata() {
        return m4;
    }

    public static void init(PermissionDict permissionDict) {
        if (SELF != null) {
            AuInit.log.error("permissionDict \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        SELF = permissionDict;
    }

    public static void initAuthzMetadata(Map<String, Map<String, PermRolesMeta>> authzMetadata) {
        if (PermissionDict.authzMetadata != null) {
            AuInit.log.error("authzMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.authzMetadata = authzMetadata;
        m1 = new UnmodifiableObservableMap((ObservableMap)new ObservableMapWrapper(authzMetadata));
    }

    public static void addAuthzResourcesNames(Set<String> authzResourcesNames) {
        if (authzResourcesNames == null) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (String authzResourcesName : authzResourcesNames) {
            try {
                Map fieldMap = authzResourcesNameAndTemplate.computeIfAbsent(authzResourcesName, r -> new HashMap());
                fieldMap.putAll(PermissionDict.parseTypeForTemplate(authzResourcesName));
                names.add(authzResourcesName);
            }
            catch (Exception exception) {}
        }
        m2 = new UnmodifiableObservableMap((ObservableMap)new ObservableMapWrapper(authzResourcesNameAndTemplate));
        AuInit.log.info("authz resources add success \u2b07: \n{}", names);
    }

    public static void initDataPerm(Map<String, List<DataPermMeta>> dataPermMetadata) {
        if (PermissionDict.dataPermMetadata != null) {
            AuInit.log.error("dataPermMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.dataPermMetadata = dataPermMetadata;
        m3 = new UnmodifiableObservableMap((ObservableMap)new ObservableMapWrapper(dataPermMetadata));
    }

    public static void initArgs(Map<String, ArgsMeta> argsMetadata) {
        if (PermissionDict.argsMetadata != null) {
            AuInit.log.error("authzMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.argsMetadata = argsMetadata;
        m4 = new UnmodifiableObservableMap((ObservableMap)new ObservableMapWrapper(argsMetadata));
    }

    public static void setPermSeparator(String permSeparator) {
        PermissionDict.permSeparator = permSeparator;
    }

    public static String getPermSeparator() {
        return permSeparator;
    }

    public static List<Class<?>> argType(String argsName) {
        ArgsMeta meta = argsMetadata.get(argsName);
        if (meta == null) {
            return null;
        }
        return meta.parameterList;
    }

    public static Object argsHandle(String argsName, Object ... otherArgs) {
        ArgsMeta meta = argsMetadata.get(argsName);
        if (meta == null) {
            LogUtils.logError("arg {} is null", argsName);
            return null;
        }
        try {
            Object bean = AUtils.getBean(meta.type);
            return meta.method.invoke(bean, otherArgs);
        }
        catch (Exception e) {
            try {
                if (Modifier.isStatic(meta.method.getModifiers())) {
                    return meta.method.invoke(null, otherArgs);
                }
                int modifiers = meta.type.getModifiers();
                if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
                    log.error("{} bean \u4e0d\u5b58\u5728 \u4e14\u4e0d\u80fd\u5b9e\u4f8b\u5316 \uff0c \u6216\u8005\u53c2\u6570\u4e2a\u6570\u3001\u7c7b\u578b\u4e0d\u6b63\u786e", (Object)meta.type);
                    return null;
                }
                return meta.method.invoke(meta.type.newInstance(), otherArgs);
            }
            catch (Exception ex) {
                log.error("{} \u6784\u9020\u51fd\u6570\u5f02\u5e38", (Object)meta.type);
                return null;
            }
        }
    }

    public static Map<String, Object> parseTypeForTemplate(String className) {
        HashMap<String, Object> typeTemplate = new HashMap<String, Object>();
        try {
            Class<?> clz = Class.forName(className);
            for (Method method : clz.getMethods()) {
                String name = method.getName();
                if (!name.startsWith("get") && !name.startsWith("is") || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || Modifier.isNative(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
                String field = name.startsWith("get") ? name.substring(3, 4).toLowerCase(Locale.ROOT) + name.substring(4) : name.substring(2, 3).toLowerCase(Locale.ROOT) + name.substring(3);
                typeTemplate.put(field, method.getReturnType().getTypeName());
            }
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
        return typeTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PermRolesMeta modify(PermRolesMeta.Vo permRolesMetaVo) {
        boolean change = false;
        try {
            Map<String, PermRolesMeta> target = authzMetadata.get(permRolesMetaVo.getMethod());
            PermRolesMeta meta = target.get(permRolesMetaVo.getApi());
            switch (permRolesMetaVo.getOperate()) {
                case ADD: 
                case OVERRIDE: {
                    change = true;
                    if (meta != null) {
                        PermRolesMeta permRolesMeta = meta.overrideApi(permRolesMetaVo.build());
                        return permRolesMeta;
                    }
                    PermRolesMeta permRolesMeta = target.put(permRolesMetaVo.getApi(), permRolesMetaVo.build());
                    return permRolesMeta;
                }
                case MODIFY: 
                case UPDATE: {
                    change = true;
                    PermRolesMeta permRolesMeta = meta.merge(permRolesMetaVo.build());
                    return permRolesMeta;
                }
                case DELETE: 
                case DEL: {
                    if (meta != null) {
                        PermRolesMeta permRolesMeta = meta.removeApi();
                        return permRolesMeta;
                    }
                    PermRolesMeta permRolesMeta = null;
                    return permRolesMeta;
                }
                case GET: 
                case READ: {
                    PermRolesMeta permRolesMeta = meta;
                    return permRolesMeta;
                }
            }
            PermRolesMeta permRolesMeta = null;
            return permRolesMeta;
        }
        catch (Exception e) {
            PermRolesMeta permRolesMeta = null;
            return permRolesMeta;
        }
        finally {
            if (change) {
                Map<String, PermRolesMeta> metaMap;
                PermRolesMeta meta = authzMetadata.get(permRolesMetaVo.getMethod()).get(permRolesMetaVo.getApi());
                if (meta == null || meta.nonAll()) {
                    authzMetadata.get(permRolesMetaVo.getMethod()).remove(permRolesMetaVo.getApi());
                }
                if ((metaMap = authzMetadata.get(permRolesMetaVo.getMethod())).size() == 0) {
                    authzMetadata.remove(permRolesMetaVo.getMethod());
                }
            }
            m1 = new UnmodifiableObservableMap((ObservableMap)new ObservableMapWrapper(authzMetadata));
        }
    }

    static {
        authzResourcesNameAndTemplate = new HashMap<String, Map<String, Object>>();
        permSeparator = ",";
    }

    public static class ArgsMeta {
        private final Class<?> type;
        private final Method method;
        private final List<Class<?>> parameterList;
        private final Class<?> returnType;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final Map<String, Object> returnTypeTemplate;

        private ArgsMeta(Class<?> type, Method method) {
            this.type = type;
            this.method = method;
            this.returnType = method.getReturnType();
            this.parameterList = Arrays.stream(method.getParameterTypes()).collect(Collectors.toList());
            this.returnTypeTemplate = PermissionDict.parseTypeForTemplate(this.returnType.getTypeName());
        }

        public String getMethod() {
            return this.method.getName();
        }

        public static ArgsMeta of(Class<?> type, Method method) {
            return new ArgsMeta(type, method);
        }

        public static ArgsMeta of(Class<?> type, String methodName, Class<?> ... args) {
            try {
                return new ArgsMeta(type, type.getMethod(methodName, args));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static ArgsMeta of(Object type, String methodName, Class<?> ... args) {
            return ArgsMeta.of(type.getClass(), methodName, args);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArgsMeta)) {
                return false;
            }
            ArgsMeta meta = (ArgsMeta)o;
            return Objects.equal((Object)this.method, (Object)meta.method) && Objects.equal(this.type, meta.type);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method, this.type});
        }

        public Class<?> getType() {
            return this.type;
        }

        public List<Class<?>> getParameterList() {
            return this.parameterList;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public Map<String, Object> getReturnTypeTemplate() {
            return this.returnTypeTemplate;
        }
    }
}

