/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.commons.util.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PermRolesMeta {
    private Meta role;
    private Meta permissions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<ParamMetadata.ParamType, Map<String, ParamMetadata>> paramPermissionsMetadata;

    public Map<ParamMetadata.ParamType, Map<String, ParamMetadata>> getParamPermissionsMetadata() {
        return this.paramPermissionsMetadata;
    }

    public void put(ParamMetadata.ParamType paramType, String name, ParamMetadata paramMetadata) {
        if (this.paramPermissionsMetadata == null) {
            this.paramPermissionsMetadata = new HashMap<ParamMetadata.ParamType, Map<String, ParamMetadata>>();
        }
        this.paramPermissionsMetadata.computeIfAbsent(paramType, r -> new HashMap()).put(name, paramMetadata);
    }

    public boolean non() {
        return !(this.role != null && !this.role.non() || this.permissions != null && !this.permissions.non());
    }

    public boolean nonAll() {
        return !(this.role != null && !this.role.non() || this.permissions != null && !this.permissions.non() || this.paramPermissionsMetadata != null && this.paramPermissionsMetadata.size() != 0 && !this.paramPermissionsMetadata.values().stream().noneMatch(Objects::nonNull));
    }

    public PermRolesMeta overrideApi(PermRolesMeta permRolesMeta) {
        this.setRequireRoles(permRolesMeta.getRequireRoles());
        this.setExcludeRoles(permRolesMeta.getExcludeRoles());
        this.setRequirePermissions(permRolesMeta.getRequirePermissions());
        this.setExcludePermissions(permRolesMeta.getExcludePermissions());
        return this;
    }

    public PermRolesMeta removeApi() {
        this.role = null;
        this.permissions = null;
        return this;
    }

    public Set<Set<String>> getRequireRoles() {
        if (this.role != null) {
            return this.role.require;
        }
        return null;
    }

    public void setRequireRoles(Set<Set<String>> requireRoles) {
        if (requireRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.require = requireRoles;
    }

    public Set<Set<String>> getExcludeRoles() {
        if (this.role != null) {
            return this.role.exclude;
        }
        return null;
    }

    public void setExcludeRoles(Set<Set<String>> excludeRoles) {
        if (excludeRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.exclude = excludeRoles;
    }

    public Set<Set<String>> getRequirePermissions() {
        if (this.permissions != null) {
            return this.permissions.require;
        }
        return null;
    }

    public void setRequirePermissions(Set<Set<String>> requirePermissions) {
        if (requirePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.require = requirePermissions;
    }

    public Set<Set<String>> getExcludePermissions() {
        if (this.permissions != null) {
            return this.permissions.exclude;
        }
        return null;
    }

    public void setExcludePermissions(Set<Set<String>> excludePermissions) {
        if (excludePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.exclude = excludePermissions;
    }

    public void setRequireRoles(Collection<String> requireRoles) {
        if (requireRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.require = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])requireRoles.toArray(new String[0]));
    }

    public void setExcludeRoles(Collection<String> excludeRoles) {
        if (excludeRoles == null) {
            return;
        }
        if (this.role == null) {
            this.role = new Meta();
        }
        this.role.exclude = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])excludeRoles.toArray(new String[0]));
    }

    public void setRequirePermissions(Collection<String> requirePermissions) {
        if (requirePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.require = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])requirePermissions.toArray(new String[0]));
    }

    public void setExcludePermissions(Collection<String> excludePermissions) {
        if (excludePermissions == null) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new Meta();
        }
        this.permissions.exclude = CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])excludePermissions.toArray(new String[0]));
    }

    public PermRolesMeta merge(PermRolesMeta other) {
        this.setExcludePermissions(other.getExcludePermissions());
        this.setRequirePermissions(other.getRequirePermissions());
        this.setRequireRoles(other.getRequireRoles());
        this.setExcludeRoles(other.getExcludeRoles());
        return this;
    }

    public String toString() {
        return (this.role != null ? "( role> " + this.role + " )" : "") + (this.permissions != null ? "\t, ( permissions> " + this.permissions + " )" : "");
    }

    public static class Vo {
        Operate operate;
        String method;
        String api;
        Collection<String> requireRoles;
        Collection<String> excludeRoles;
        Collection<String> requirePermissions;
        Collection<String> excludePermissions;

        public Vo setOperate(Operate operate) {
            this.operate = operate;
            return this;
        }

        public Vo setOperate(String operate) {
            try {
                this.operate = Operate.valueOf(operate.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.operate = Operate.EMPTY;
            }
            return this;
        }

        public Vo setMethod(String method) {
            this.method = method != null ? method.toUpperCase(Locale.ROOT) : null;
            return this;
        }

        public PermRolesMeta build() {
            PermRolesMeta permRolesMeta = new PermRolesMeta();
            permRolesMeta.setRequireRoles(this.requireRoles);
            permRolesMeta.setExcludeRoles(this.excludeRoles);
            permRolesMeta.setRequirePermissions(this.requirePermissions);
            permRolesMeta.setExcludePermissions(this.excludePermissions);
            return permRolesMeta;
        }

        public static PermRolesMeta build(Collection<String> requireRoles, Collection<String> excludeRoles, Collection<String> requirePermissions, Collection<String> excludePermissions) {
            PermRolesMeta permRolesMeta = new PermRolesMeta();
            permRolesMeta.setRequireRoles(requireRoles);
            permRolesMeta.setExcludeRoles(excludeRoles);
            permRolesMeta.setRequirePermissions(requirePermissions);
            permRolesMeta.setExcludePermissions(excludePermissions);
            return permRolesMeta;
        }

        public Operate getOperate() {
            return this.operate;
        }

        public String getMethod() {
            return this.method;
        }

        public String getApi() {
            return this.api;
        }

        public Collection<String> getRequireRoles() {
            return this.requireRoles;
        }

        public Collection<String> getExcludeRoles() {
            return this.excludeRoles;
        }

        public Collection<String> getRequirePermissions() {
            return this.requirePermissions;
        }

        public Collection<String> getExcludePermissions() {
            return this.excludePermissions;
        }

        public Vo setApi(String api) {
            this.api = api;
            return this;
        }

        public Vo setRequireRoles(Collection<String> requireRoles) {
            this.requireRoles = requireRoles;
            return this;
        }

        public Vo setExcludeRoles(Collection<String> excludeRoles) {
            this.excludeRoles = excludeRoles;
            return this;
        }

        public Vo setRequirePermissions(Collection<String> requirePermissions) {
            this.requirePermissions = requirePermissions;
            return this;
        }

        public Vo setExcludePermissions(Collection<String> excludePermissions) {
            this.excludePermissions = excludePermissions;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vo)) {
                return false;
            }
            Vo other = (Vo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Operate this$operate = this.getOperate();
            Operate other$operate = other.getOperate();
            if (this$operate == null ? other$operate != null : !((Object)((Object)this$operate)).equals((Object)other$operate)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$api = this.getApi();
            String other$api = other.getApi();
            if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
                return false;
            }
            Collection<String> this$requireRoles = this.getRequireRoles();
            Collection<String> other$requireRoles = other.getRequireRoles();
            if (this$requireRoles == null ? other$requireRoles != null : !((Object)this$requireRoles).equals(other$requireRoles)) {
                return false;
            }
            Collection<String> this$excludeRoles = this.getExcludeRoles();
            Collection<String> other$excludeRoles = other.getExcludeRoles();
            if (this$excludeRoles == null ? other$excludeRoles != null : !((Object)this$excludeRoles).equals(other$excludeRoles)) {
                return false;
            }
            Collection<String> this$requirePermissions = this.getRequirePermissions();
            Collection<String> other$requirePermissions = other.getRequirePermissions();
            if (this$requirePermissions == null ? other$requirePermissions != null : !((Object)this$requirePermissions).equals(other$requirePermissions)) {
                return false;
            }
            Collection<String> this$excludePermissions = this.getExcludePermissions();
            Collection<String> other$excludePermissions = other.getExcludePermissions();
            return !(this$excludePermissions == null ? other$excludePermissions != null : !((Object)this$excludePermissions).equals(other$excludePermissions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Vo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Operate $operate = this.getOperate();
            result = result * 59 + ($operate == null ? 43 : ((Object)((Object)$operate)).hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $api = this.getApi();
            result = result * 59 + ($api == null ? 43 : $api.hashCode());
            Collection<String> $requireRoles = this.getRequireRoles();
            result = result * 59 + ($requireRoles == null ? 43 : ((Object)$requireRoles).hashCode());
            Collection<String> $excludeRoles = this.getExcludeRoles();
            result = result * 59 + ($excludeRoles == null ? 43 : ((Object)$excludeRoles).hashCode());
            Collection<String> $requirePermissions = this.getRequirePermissions();
            result = result * 59 + ($requirePermissions == null ? 43 : ((Object)$requirePermissions).hashCode());
            Collection<String> $excludePermissions = this.getExcludePermissions();
            result = result * 59 + ($excludePermissions == null ? 43 : ((Object)$excludePermissions).hashCode());
            return result;
        }

        public String toString() {
            return "PermRolesMeta.Vo(operate=" + (Object)((Object)this.getOperate()) + ", method=" + this.getMethod() + ", api=" + this.getApi() + ", requireRoles=" + this.getRequireRoles() + ", excludeRoles=" + this.getExcludeRoles() + ", requirePermissions=" + this.getRequirePermissions() + ", excludePermissions=" + this.getExcludePermissions() + ")";
        }

        public static enum Operate {
            ADD,
            OVERRIDE,
            DELETE,
            DEL,
            MODIFY,
            UPDATE,
            GET,
            READ,
            EMPTY,
            NON;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Meta {
        private Set<Set<String>> require;
        private Set<Set<String>> exclude;
        private Set<String> resources;

        public boolean non() {
            return !(this.require != null && this.require.size() != 0 || this.exclude != null && this.exclude.size() != 0);
        }

        public String toString() {
            return (this.require != null ? "require: " + this.require : "") + (this.exclude != null ? "\t, exclude: " + this.exclude : "");
        }

        public Set<Set<String>> getRequire() {
            return this.require;
        }

        public Set<Set<String>> getExclude() {
            return this.exclude;
        }

        public Set<String> getResources() {
            return this.resources;
        }

        public Meta setRequire(Set<Set<String>> require) {
            this.require = require;
            return this;
        }

        public Meta setExclude(Set<Set<String>> exclude) {
            this.exclude = exclude;
            return this;
        }

        public Meta setResources(Set<String> resources) {
            this.resources = resources;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta other = (Meta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Set<String>> this$require = this.getRequire();
            Set<Set<String>> other$require = other.getRequire();
            if (this$require == null ? other$require != null : !((Object)this$require).equals(other$require)) {
                return false;
            }
            Set<Set<String>> this$exclude = this.getExclude();
            Set<Set<String>> other$exclude = other.getExclude();
            if (this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude)) {
                return false;
            }
            Set<String> this$resources = this.getResources();
            Set<String> other$resources = other.getResources();
            return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Meta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Set<String>> $require = this.getRequire();
            result = result * 59 + ($require == null ? 43 : ((Object)$require).hashCode());
            Set<Set<String>> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            Set<String> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            return result;
        }
    }
}

