/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.Rule;
import cn.omisheep.authz.core.util.RuleParser;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataPermMeta {
    private PermRolesMeta.Meta roles;
    private PermRolesMeta.Meta permissions;
    private String condition;
    private Rule rule;
    private Map<String, List<String>> argsMap;

    public static DataPermMeta of(String condition) {
        DataPermMeta dataPermMeta = new DataPermMeta();
        dataPermMeta.setRule(RuleParser.parseStringToRule(condition));
        dataPermMeta.setCondition(condition);
        return dataPermMeta;
    }

    public static DataPermMeta of(Rule rule) {
        DataPermMeta dataPermMeta = new DataPermMeta();
        dataPermMeta.setCondition(RuleParser.parseRuleToString(rule));
        dataPermMeta.setRule(rule);
        return dataPermMeta;
    }

    public DataPermMeta addArg(String source, List<String> args) {
        if (this.argsMap == null) {
            this.argsMap = new HashMap<String, List<String>>();
        }
        this.argsMap.put(source, args);
        return this;
    }

    public DataPermMeta addArg(String source, String ... args) {
        if (this.argsMap == null) {
            this.argsMap = new HashMap<String, List<String>>();
        }
        if (args != null) {
            this.argsMap.put(source, Arrays.stream(args).collect(Collectors.toList()));
        }
        return this;
    }

    public PermRolesMeta.Meta getRoles() {
        return this.roles;
    }

    public PermRolesMeta.Meta getPermissions() {
        return this.permissions;
    }

    public String getCondition() {
        return this.condition;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Map<String, List<String>> getArgsMap() {
        return this.argsMap;
    }

    public DataPermMeta setRoles(PermRolesMeta.Meta roles) {
        this.roles = roles;
        return this;
    }

    public DataPermMeta setPermissions(PermRolesMeta.Meta permissions) {
        this.permissions = permissions;
        return this;
    }

    public DataPermMeta setCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public DataPermMeta setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public DataPermMeta setArgsMap(Map<String, List<String>> argsMap) {
        this.argsMap = argsMap;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPermMeta)) {
            return false;
        }
        DataPermMeta other = (DataPermMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PermRolesMeta.Meta this$roles = this.getRoles();
        PermRolesMeta.Meta other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        PermRolesMeta.Meta this$permissions = this.getPermissions();
        PermRolesMeta.Meta other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        Map<String, List<String>> this$argsMap = this.getArgsMap();
        Map<String, List<String>> other$argsMap = other.getArgsMap();
        return !(this$argsMap == null ? other$argsMap != null : !((Object)this$argsMap).equals(other$argsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPermMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PermRolesMeta.Meta $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        PermRolesMeta.Meta $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        Map<String, List<String>> $argsMap = this.getArgsMap();
        result = result * 59 + ($argsMap == null ? 43 : ((Object)$argsMap).hashCode());
        return result;
    }

    public String toString() {
        return "DataPermMeta(roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ", condition=" + this.getCondition() + ", rule=" + this.getRule() + ", argsMap=" + this.getArgsMap() + ")";
    }
}

