/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenHelper;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.web.utils.HttpUtils;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public class AuthzDefender {
    private final UserDevicesDict userDevicesDict;
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;

    public AuthzDefender(UserDevicesDict userDevicesDict, PermissionDict permissionDict, PermLibrary permLibrary) {
        this.userDevicesDict = userDevicesDict;
        this.permissionDict = permissionDict;
        this.permLibrary = permLibrary;
    }

    public TokenPair grant(Object userId, String deviceType, String deviceId) {
        TokenPair tokenPair = TokenHelper.createTokenPair(userId, deviceType, deviceId);
        HttpServletResponse response = HttpUtils.getCurrentResponse();
        HttpMeta httpMeta = (HttpMeta)HttpUtils.getCurrentRequest().getAttribute("AU_HTTP_META");
        if (response != null) {
            response.addCookie(TokenHelper.generateCookie(tokenPair.getAccessToken()));
        }
        try {
            if (this.userDevicesDict.addUser(userId, tokenPair, deviceType, deviceId, httpMeta)) {
                return tokenPair;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public TokenPair refreshToken(String refreshToken) {
        try {
            TokenPair tokenPair = TokenHelper.refreshToken(refreshToken);
            if (this.userDevicesDict.refreshUser(tokenPair)) {
                HttpServletResponse response = HttpUtils.getCurrentResponse();
                if (response != null) {
                    response.addCookie(TokenHelper.generateCookie(tokenPair.getAccessToken()));
                }
                return tokenPair;
            }
            return null;
        }
        catch (ExpiredJwtException e) {
            return null;
        }
    }

    public ExceptionStatus verify(HttpMeta httpMeta) {
        PermRolesMeta permRolesMeta = this.permissionDict.getAuthzMetadata().get(httpMeta.getMethod()).get(httpMeta.getApi());
        Token accessToken = httpMeta.getToken();
        Set<String> roles = null;
        boolean e1 = CollectionUtils.isEmpty(permRolesMeta.getRequireRoles());
        boolean e2 = CollectionUtils.isEmpty(permRolesMeta.getExcludeRoles());
        if (!e1 || !e2) {
            long nowTime = TimeUtils.nowTime();
            roles = this.permLibrary.getRolesByUserId(accessToken.getUserId());
            LogUtils.logDebug("permLibrary.getRolesByUserId({})  {}", accessToken.getUserId(), TimeUtils.diff((long)nowTime));
            if (!e1 && !CollectionUtils.containsSub(permRolesMeta.getRequireRoles(), roles) || !e2 && CollectionUtils.containsSub(permRolesMeta.getExcludeRoles(), roles)) {
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                return ExceptionStatus.PERM_EXCEPTION;
            }
        }
        boolean e3 = CollectionUtils.isEmpty(permRolesMeta.getRequirePermissions());
        boolean e4 = CollectionUtils.isEmpty(permRolesMeta.getExcludePermissions());
        if (!e3 || !e4) {
            if (e1 && e2) {
                long nowTime = TimeUtils.nowTime();
                roles = this.permLibrary.getRolesByUserId(accessToken.getUserId());
                LogUtils.logDebug("e1 && e2 permLibrary.getRolesByUserId({})  {}", accessToken.getUserId(), TimeUtils.diff((long)nowTime));
            }
            HashSet<String> perms = new HashSet<String>();
            for (String role : (Set)Optional.of(roles).orElse(new HashSet())) {
                long nowTime = TimeUtils.nowTime();
                Set<String> permissionsByRole = this.permLibrary.getPermissionsByRole(role);
                LogUtils.logDebug("permLibrary.getPermissionsByRole({}) {}", role, TimeUtils.diff((long)nowTime));
                if (permissionsByRole != null) {
                    perms.addAll(permissionsByRole);
                }
                if (e4 || !CollectionUtils.containsSub(permRolesMeta.getExcludePermissions(), permissionsByRole)) continue;
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                return ExceptionStatus.PERM_EXCEPTION;
            }
            if (!e3 && !CollectionUtils.containsSub(permRolesMeta.getRequirePermissions(), perms)) {
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                return ExceptionStatus.PERM_EXCEPTION;
            }
        }
        AuthzDefender.logs("Success", httpMeta, permRolesMeta);
        return null;
    }

    public static void logs(String status, HttpMeta httpMeta, PermRolesMeta meta) {
        Token token = httpMeta.getToken();
        if (token == null) {
            LogUtils.pushLogToRequest("\u300c{}\u300d\t{}", status, meta);
        } else {
            LogUtils.pushLogToRequest("\u300c{}\u300d\t\t{}\t, userId: [{}]\t, deviceType&deviceId [ {} , {} ]", status, meta, token.getUserId(), token.getDeviceType(), token.getDeviceId());
        }
    }
}

