/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.commons.util.TimeUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RequestMeta {
    private final String ip;
    private boolean ban;
    private int punishmentLevel;
    private long reliveTime;
    private long lastRequestTime;
    private long sinceLastTime;
    private final LinkedList<Long> requestTimeList = new LinkedList();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Date getReliveTime() {
        return this.ban ? new Date(this.reliveTime) : null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Date> getRequestTimeList() {
        return this.requestTimeList.stream().map(Date::new).collect(Collectors.toList());
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.sinceLastTime = lastRequestTime - this.lastRequestTime;
        this.lastRequestTime = lastRequestTime;
    }

    public Date getLastRequestTime() {
        return new Date(this.lastRequestTime);
    }

    public RequestMeta(long now, String ip) {
        this.ip = ip;
        this.request(now, 1, 0L, 0L);
    }

    public boolean enableRelive(long now) {
        return this.reliveTime <= now;
    }

    public void relive() {
        if (this.ban) {
            this.ban = false;
        }
    }

    public RequestMeta forbidden(List<Long> punishmentTime) {
        long nowTime = TimeUtils.nowTime();
        ++this.punishmentLevel;
        this.reliveTime = this.punishmentLevel <= punishmentTime.size() ? punishmentTime.get(this.punishmentLevel - 1) + nowTime : punishmentTime.get(punishmentTime.size() - 1) + nowTime;
        this.requestTimeList.clear();
        this.ban = true;
        return this;
    }

    public boolean pushRequest(long now, int maxRequests, long window, long minInterval) {
        if (this.requestTimeList.isEmpty() || this.requestTimeList.getLast() < now) {
            return this.request(now, maxRequests, window, minInterval);
        }
        for (int i = 0; i < this.requestTimeList.size(); ++i) {
            if (this.requestTimeList.get(i) < now) continue;
            this.requestTimeList.add(i, now);
            break;
        }
        int size = this.requestTimeList.size();
        if (minInterval > 0L && size >= 2 && this.requestTimeList.get(size - 1) - this.requestTimeList.get(size - 2) > minInterval) {
            return false;
        }
        if (size > maxRequests) {
            Long first = this.requestTimeList.getFirst();
            return this.requestTimeList.getLast() - first >= window;
        }
        return true;
    }

    public boolean pushRequest(long now, LimitMeta limitMeta) {
        return this.pushRequest(now, limitMeta.getMaxRequests(), limitMeta.getWindow(), limitMeta.getMinInterval());
    }

    public boolean request(long now, int maxRequests, long window, long minInterval) {
        if (now - this.reliveTime > window) {
            this.punishmentLevel = 0;
        }
        Long lastSecond = null;
        if (!this.requestTimeList.isEmpty()) {
            lastSecond = this.requestTimeList.getLast();
            this.sinceLastTime = now - lastSecond;
        }
        this.lastRequestTime = now;
        this.requestTimeList.removeIf(time -> now - time > window);
        this.requestTimeList.offer(now);
        Long lastFirst = this.requestTimeList.getLast();
        if (minInterval > 0L && lastSecond != null && lastFirst - lastSecond < minInterval) {
            return false;
        }
        while (this.requestTimeList.size() - 1 > maxRequests) {
            this.requestTimeList.pollFirst();
        }
        if (this.requestTimeList.size() > maxRequests) {
            Long first = this.requestTimeList.getFirst();
            return lastFirst - first >= window;
        }
        return true;
    }

    public String sinceLastTime() {
        return TimeUtils.parseTime((long)this.sinceLastTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestMeta ipMeta = (RequestMeta)o;
        return this.ip.equals(ipMeta.ip) && ipMeta.reliveTime < this.reliveTime;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.ip).toHashCode();
    }

    public String getIp() {
        return this.ip;
    }

    public boolean isBan() {
        return this.ban;
    }
}

