/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.ipf.RequestMeta;
import cn.omisheep.authz.core.msg.RequestMessage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import orestes.bloomfilter.CountingBloomFilter;
import orestes.bloomfilter.FilterBuilder;
import org.springframework.util.AntPathMatcher;

public class Httpd {
    public static final AntPathMatcher antPathMatcher = new AntPathMatcher("/");
    private final RequestPools requestPools = new RequestPools();
    private final Map<String, Map<String, LimitMeta>> rateLimitMetadata = new HashMap<String, Map<String, LimitMeta>>();
    @JsonIgnore
    private final HashMap<LimitMeta, List<RequestPool>> associatedIpPoolsCache = new HashMap();
    private final HashSet<RequestMeta> ipBlacklist = new HashSet();
    @JsonIgnore
    private final CountingBloomFilter<String> ipBlacklistBloomFilter = new FilterBuilder(1000, 0.001).countingBits(8).buildCountingBloomFilter();

    public void receive(RequestMessage requestMessage) {
        String api = requestMessage.getApi();
        String method = requestMessage.getMethod();
        String ip = requestMessage.getIp();
        long now = requestMessage.getNow();
        try {
            RequestPool requestPool = (RequestPool)((ConcurrentHashMap)this.requestPools.get(method)).get(api);
            RequestMeta requestMeta = (RequestMeta)requestPool.get(ip);
            if (requestMeta == null) {
                requestPool.put(ip, new RequestMeta(now, ip));
            } else {
                LimitMeta limitMeta = this.rateLimitMetadata.get(method).get(ip);
                if (!requestMeta.pushRequest(now, limitMeta)) {
                    this.forbid(now, requestMeta, limitMeta);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<RequestPool> associatedIpPools(LimitMeta limitMeta) {
        List<RequestPool> requestPools = this.getAssociatedIpPoolsCache().get(limitMeta);
        if (requestPools != null) {
            return requestPools;
        }
        List<LimitMeta.AssociatedPattern> associatedPatterns = limitMeta.getAssociatedPatterns();
        ArrayList<RequestPool> oIpPools = new ArrayList<RequestPool>();
        if (associatedPatterns != null) {
            associatedPatterns.forEach(associatedPattern -> associatedPattern.getMethods().forEach(meth -> {
                ConcurrentHashMap map = (ConcurrentHashMap)this.getRequestPools().get(meth);
                if (map != null) {
                    map.keySet().stream().filter(path -> antPathMatcher.match(associatedPattern.getPattern(), path)).forEach(path -> oIpPools.add((RequestPool)map.get(path)));
                }
            }));
        }
        this.getAssociatedIpPoolsCache().put(limitMeta, oIpPools);
        return oIpPools;
    }

    public void forbid(long now, RequestMeta requestMeta, LimitMeta limitMeta) {
        requestMeta.forbidden(limitMeta.getPunishmentTime());
        String ip = requestMeta.getIp();
        for (RequestPool ipPool : this.associatedIpPools(limitMeta)) {
            if (!ipPool.containsKey(ip)) {
                ipPool.put(ip, new RequestMeta(now, ip).forbidden(limitMeta.getPunishmentTime()));
                continue;
            }
            ((RequestMeta)ipPool.get(ip)).forbidden(limitMeta.getPunishmentTime());
        }
    }

    public void relive(RequestMeta requestMeta, LimitMeta limitMeta) {
        requestMeta.relive();
        String ip = requestMeta.getIp();
        this.associatedIpPools(limitMeta).forEach(ipPool -> {
            if (ipPool.containsKey(ip)) {
                ((RequestMeta)ipPool.get(ip)).relive();
            }
        });
    }

    public RequestPools getRequestPools() {
        return this.requestPools;
    }

    public Map<String, Map<String, LimitMeta>> getRateLimitMetadata() {
        return this.rateLimitMetadata;
    }

    public HashMap<LimitMeta, List<RequestPool>> getAssociatedIpPoolsCache() {
        return this.associatedIpPoolsCache;
    }

    public HashSet<RequestMeta> getIpBlacklist() {
        return this.ipBlacklist;
    }

    public CountingBloomFilter<String> getIpBlacklistBloomFilter() {
        return this.ipBlacklistBloomFilter;
    }

    public static class RequestPool
    extends ConcurrentHashMap<String, RequestMeta> {
        private static final long serialVersionUID = -284927742264879191L;
    }

    public static class RequestPools
    extends HashMap<String, ConcurrentHashMap<String, RequestPool>> {
        private static final long serialVersionUID = -1838299980303412207L;
    }
}

