/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.core.AuthzException;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.web.utils.HttpUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class HttpMeta {
    @JsonIgnore
    private final HttpServletRequest request;
    private final String ip;
    private final String uri;
    private final String api;
    private final String method;
    private final String userAgent;
    private final String refer;
    private String body;
    private final Date date;
    private Token token;
    private Object userId;
    private TokenException tokenException;
    private boolean hasToken;
    private AuthzException authzException;
    private Set<String> roles;
    private Set<String> permissions;

    public HttpMeta setRoles(Set<String> roles) {
        if (roles == null) {
            return this;
        }
        this.roles = roles;
        return this;
    }

    public HttpMeta setPermissions(Set<String> permissions) {
        if (permissions == null) {
            return this;
        }
        this.permissions = permissions;
        return this;
    }

    public static Token currentToken() {
        try {
            return ((HttpMeta)HttpUtils.getCurrentRequest().getAttribute((String)"AU_HTTP_META")).token;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object currentUserId() {
        try {
            return HttpMeta.currentToken().getUserId();
        }
        catch (Exception e) {
            return null;
        }
    }

    public HttpMeta error(AuthzException authzException) {
        this.authzException = authzException;
        return this;
    }

    public HttpMeta error(ExceptionStatus exceptionStatus) {
        return this.error(new AuthzException(null, exceptionStatus));
    }

    public HttpMeta error(ExceptionStatus exceptionStatus, Throwable e) {
        return this.error(new AuthzException(e, exceptionStatus));
    }

    public boolean setHasToken(boolean hasToken) {
        this.hasToken = hasToken;
        return hasToken;
    }

    public String getBody() {
        if (!"POST".equals(this.method)) {
            return null;
        }
        if (this.body == null) {
            try {
                this.body = new BufferedReader(new InputStreamReader((InputStream)this.request.getInputStream())).lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (IOException e) {
                LogUtils.logError("read body error", new Object[0]);
                return null;
            }
        }
        return this.body;
    }

    public void setToken(Token token) {
        if (this.token == null) {
            this.token = token;
            this.userId = token.getUserId();
        }
    }

    public HttpMeta(HttpServletRequest request, String ip, String uri, String api, String method, Date date) {
        this.request = request;
        this.refer = request.getHeader("Referer");
        this.ip = ip;
        this.uri = uri;
        this.api = api;
        this.method = method.toUpperCase();
        this.userAgent = request.getHeader("user-agent");
        this.date = date;
    }

    public boolean isMethod(String method) {
        if (method != null) {
            return this.method.equals(method.toUpperCase());
        }
        return false;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUri() {
        return this.uri;
    }

    public String getApi() {
        return this.api;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRefer() {
        return this.refer;
    }

    public Date getDate() {
        return this.date;
    }

    public Token getToken() {
        return this.token;
    }

    public Object getUserId() {
        return this.userId;
    }

    public TokenException getTokenException() {
        return this.tokenException;
    }

    public boolean isHasToken() {
        return this.hasToken;
    }

    public AuthzException getAuthzException() {
        return this.authzException;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setUserId(Object userId) {
        this.userId = userId;
    }

    public void setTokenException(TokenException tokenException) {
        this.tokenException = tokenException;
    }

    public void setAuthzException(AuthzException authzException) {
        this.authzException = authzException;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMeta)) {
            return false;
        }
        HttpMeta other = (HttpMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasToken() != other.isHasToken()) {
            return false;
        }
        HttpServletRequest this$request = this.getRequest();
        HttpServletRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$refer = this.getRefer();
        String other$refer = other.getRefer();
        if (this$refer == null ? other$refer != null : !this$refer.equals(other$refer)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Token this$token = this.getToken();
        Token other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Object this$userId = this.getUserId();
        Object other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        TokenException this$tokenException = this.getTokenException();
        TokenException other$tokenException = other.getTokenException();
        if (this$tokenException == null ? other$tokenException != null : !((Object)((Object)this$tokenException)).equals((Object)other$tokenException)) {
            return false;
        }
        AuthzException this$authzException = this.getAuthzException();
        AuthzException other$authzException = other.getAuthzException();
        if (this$authzException == null ? other$authzException != null : !this$authzException.equals(other$authzException)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Set<String> this$permissions = this.getPermissions();
        Set<String> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasToken() ? 79 : 97);
        HttpServletRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $refer = this.getRefer();
        result = result * 59 + ($refer == null ? 43 : $refer.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Token $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Object $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        TokenException $tokenException = this.getTokenException();
        result = result * 59 + ($tokenException == null ? 43 : ((Object)((Object)$tokenException)).hashCode());
        AuthzException $authzException = this.getAuthzException();
        result = result * 59 + ($authzException == null ? 43 : $authzException.hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Set<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    public String toString() {
        return "HttpMeta(request=" + this.getRequest() + ", ip=" + this.getIp() + ", uri=" + this.getUri() + ", api=" + this.getApi() + ", method=" + this.getMethod() + ", userAgent=" + this.getUserAgent() + ", refer=" + this.getRefer() + ", body=" + this.getBody() + ", date=" + this.getDate() + ", token=" + this.getToken() + ", userId=" + this.getUserId() + ", tokenException=" + (Object)((Object)this.getTokenException()) + ", hasToken=" + this.isHasToken() + ", authzException=" + this.getAuthzException() + ", roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ")";
    }

    public static enum TokenException {
        ExpiredJwtException,
        MalformedJwtException,
        SignatureException;

    }
}

