/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.annotation.BannedType;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.ipf.RequestMeta;
import cn.omisheep.authz.core.msg.RequestMessage;
import cn.omisheep.authz.core.util.ExceptionUtils;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Async;
import cn.omisheep.web.utils.BufferedServletRequestWrapper;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import orestes.bloomfilter.CountingBloomFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthzHttpFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthzHttpFilter.class);
    private final Httpd httpd;
    private static final String UNKNOWN = "unknown";
    private static final String X_FORWARDED_FOR = "x-forwarded-for";
    private static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    private static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
    private static final String HTTP_CLIENT_IP = "HTTP_CLIENT_IP";
    private static final String HTTP_X_FORWARDED_FOR = "HTTP_X_FORWARDED_FOR";
    private static final String X_REAL_IP = "X-Real-IP";

    public AuthzHttpFilter(Httpd httpd) {
        this.httpd = httpd;
    }

    public void doFilterInternal(HttpServletRequest rrequest, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        BufferedServletRequestWrapper request = new BufferedServletRequestWrapper(rrequest);
        String ip = this.getIp((HttpServletRequest)request);
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String api = this.execLimit(ip, uri, method);
        HttpMeta httpMeta = new HttpMeta((HttpServletRequest)request, ip, uri, api, method, new Date()).error(ExceptionUtils.clear((HttpServletRequest)request));
        request.setAttribute("AU_HTTP_META", (Object)httpMeta);
        Async.run(() -> RedisUtils.publish(RequestMessage.CHANNEL, new RequestMessage()));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String execLimit(String ip, String uri, String method) throws IOException {
        RequestMeta orElse;
        HashSet<RequestMeta> ipBlacklist = this.httpd.getIpBlacklist();
        CountingBloomFilter<String> ipBlacklistBloomFilter = this.httpd.getIpBlacklistBloomFilter();
        long now = new Date().getTime();
        if (ipBlacklistBloomFilter.contains((Object)ip) && (orElse = (RequestMeta)ipBlacklist.stream().filter(_ipMeta -> _ipMeta.getIp().equals(ip)).findFirst().orElse(null)) != null && orElse.isBan()) {
            if (!orElse.enableRelive(now)) {
                LogUtils.pushLogToRequest("\u300c\u8bf7\u6c42\u9891\u7e41ip\u5c01\u9501(\u62d2\u7edd)\u300d \t\u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , uri: [{}]  ", orElse.sinceLastTime(), method, ip, uri);
                ExceptionUtils.error(ExceptionStatus.REQUEST_REPEAT);
                return null;
            }
            LogUtils.pushLogToRequest("\u300c\u89e3\u9664ip\u5c01\u7981(\u89e3\u5c01)\u300d", new Object[0]);
            ipBlacklistBloomFilter.remove((Object)ip);
            ipBlacklist.remove(orElse);
            orElse.relive();
        }
        for (Map.Entry entry : ((ConcurrentHashMap)this.httpd.getRequestPools().get(method)).entrySet()) {
            if (!Httpd.antPathMatcher.match((String)entry.getKey(), uri)) continue;
            LimitMeta limitMeta = null;
            try {
                limitMeta = this.httpd.getRateLimitMetadata().get(method).get(entry.getKey());
            }
            catch (NullPointerException e) {
                LogUtils.pushLogToRequest("\u300c\u666e\u901a\u8bbf\u95ee\u300d \tmethod: [{}] , ip : [{}] , uri: [{}]   ", method, ip, uri);
                return (String)entry.getKey();
            }
            if (limitMeta == null) {
                LogUtils.pushLogToRequest("\u300c\u666e\u901a\u8bbf\u95ee\u300d \tmethod: [{}] , ip : [{}] , uri: [{}]   ", method, ip, uri);
                return (String)entry.getKey();
            }
            RequestMeta ipMeta = (RequestMeta)((Httpd.RequestPool)entry.getValue()).get(ip);
            if (ipMeta == null) {
                ((Httpd.RequestPool)entry.getValue()).put(ip, new RequestMeta(now, ip));
                LogUtils.pushLogToRequest("\u300c\u666e\u901a\u8bbf\u95ee(\u9996\u6b21)\u300d \tmethod: [{}] , ip : [{}] , uri: [{}]  ", method, ip, uri);
            } else {
                if (ipMeta.isBan()) {
                    if (!ipMeta.enableRelive(now)) {
                        LogUtils.pushLogToRequest(LogLevel.WARN, "\u300c\u8bf7\u6c42\u9891\u7e41(\u62d2\u7edd)\u300d \t\u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , uri: [{}]  ", ipMeta.sinceLastTime(), method, ip, uri);
                        ExceptionUtils.error(ExceptionStatus.REQUEST_REPEAT);
                        ipMeta.setLastRequestTime(now);
                        return null;
                    }
                    LogUtils.pushLogToRequest("\u300c\u89e3\u9664\u5c01\u7981(\u89e3\u5c01)\u300d  \tmethod: [{}] , ip : [{}] , uri: [{}]  ", method, ip, uri);
                    this.httpd.relive(ipMeta, limitMeta);
                }
                if (ipMeta.request(now, limitMeta.getMaxRequests(), limitMeta.getWindow(), limitMeta.getMinInterval())) {
                    LogUtils.pushLogToRequest("\u300c\u666e\u901a\u8bbf\u95ee(\u6b63\u5e38)\u300d\t\u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , uri: [{}]  ", ipMeta.sinceLastTime(), method, ip, uri);
                } else {
                    this.httpd.forbid(now, ipMeta, limitMeta);
                    LogUtils.pushLogToRequest(LogLevel.WARN, "\u300c\u8bf7\u6c42\u9891\u7e41(\u5c01\u7981)\u300d \t\u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , uri: [{}]  ", ipMeta.sinceLastTime(), method, ip, uri);
                    ExceptionUtils.error(ExceptionStatus.REQUEST_REPEAT);
                    if (BannedType.IP.equals((Object)limitMeta.getBannedType())) {
                        ipBlacklist.add(ipMeta);
                        ipBlacklistBloomFilter.add((Object)ip);
                    }
                    return null;
                }
            }
            return (String)entry.getKey();
        }
        LogUtils.pushLogToRequest("\u300c\u666e\u901a\u8bbf\u95ee(uri\u4e0d\u5b58\u5728)\u300d \tmethod: [{}] , ip : [{}] , uri: [{}]   ", method, ip, uri);
        ExceptionUtils.error(ExceptionStatus.MISMATCHED_URL);
        return null;
    }

    private String getIp(HttpServletRequest request) {
        String ip;
        block8: {
            block7: {
                ip = request.getHeader(X_FORWARDED_FOR);
                if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) break block7;
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(PROXY_CLIENT_IP);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(WL_PROXY_CLIENT_IP);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(HTTP_CLIENT_IP);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(HTTP_X_FORWARDED_FOR);
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader(X_REAL_IP);
                }
                if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) break block8;
                ip = request.getRemoteAddr();
                break block8;
            }
            if (ip.length() > 15) {
                String[] ips;
                for (String strIp : ips = ip.split(",")) {
                    if (UNKNOWN.equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }
}

