/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.deviced;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.deviced.AccessInfo;
import cn.omisheep.authz.core.auth.deviced.DefaultDevice;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.DeviceConfig;
import cn.omisheep.authz.core.auth.deviced.RefreshInfo;
import cn.omisheep.authz.core.auth.deviced.RequestInfo;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDevicesDictByCache
implements UserDevicesDict {
    private static final Logger log = LoggerFactory.getLogger(UserDevicesDictByCache.class);
    private final AuthzProperties properties;
    private final Cache cache;

    public UserDevicesDictByCache(AuthzProperties properties, Cache cache) {
        this.properties = properties;
        this.cache = cache;
    }

    @Override
    public int userStatus(Object userId, String deviceType, String deviceId, String accessTokenId) {
        CompletableFuture acSupply = Async.supply(() -> this.cache.keysAndLoad(this.acKey(userId, "*")));
        Set<String> refreshInfoKeys = this.cache.keysAndLoad(this.rfKey(userId, "*"));
        boolean hasTargetDeviceInfo = false;
        if (!refreshInfoKeys.isEmpty()) {
            hasTargetDeviceInfo = refreshInfoKeys.stream().anyMatch(rfKey -> {
                Device deviceInfo = (Device)this.cache.get((String)rfKey);
                return this.equalsDeviceByTypeAndId(deviceInfo, deviceType, deviceId);
            });
        }
        if (!hasTargetDeviceInfo) {
            return 2;
        }
        Set accessInfoKeys = (Set)acSupply.join();
        if (accessInfoKeys.isEmpty()) {
            if (refreshInfoKeys.isEmpty()) {
                return 2;
            }
            return 1;
        }
        String acKey = accessInfoKeys.stream().filter(key -> {
            AccessInfo accessInfo = (AccessInfo)this.cache.get((String)key);
            if (accessInfo == null) {
                return true;
            }
            return this.equalsDeviceByTypeAndId((Device)this.cache.get(this.rfKey(userId, accessInfo.getRefreshTokenId())), deviceType, deviceId);
        }).findFirst().orElse(null);
        if (acKey == null) {
            if (!DeviceConfig.isSupportMultiDevice) {
                return 3;
            }
            return 1;
        }
        if (!StringUtils.equals((String)acKey, (String)this.acKey(userId, accessTokenId))) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean addUser(Object userId, TokenPair tokenPair, String deviceType, String deviceId, HttpMeta httpMeta) {
        HashSet<String> accessInfoKeys = new HashSet<String>();
        HashSet<String> refreshInfoKeys = new HashSet<String>();
        DefaultDevice device = new DefaultDevice();
        device.setType(deviceType).setId(deviceId);
        Async.combine(() -> accessInfoKeys.addAll(this.cache.keysAndLoad(this.acKey(userId, "*"))), () -> refreshInfoKeys.addAll(this.cache.keysAndLoad(this.rfKey(userId, "*")))).join();
        HashSet<String> delKeys = new HashSet<String>();
        if (!DeviceConfig.isSupportMultiDevice) {
            delKeys.addAll(accessInfoKeys);
            delKeys.addAll(refreshInfoKeys);
        } else if (!DeviceConfig.isSupportMultiUserForSameDeviceType) {
            accessInfoKeys.removeIf(key -> {
                AccessInfo accessInfo = (AccessInfo)this.cache.get((String)key);
                if (accessInfo == null) {
                    return true;
                }
                String rtid = accessInfo.getRefreshTokenId();
                if (rtid == null) {
                    return false;
                }
                String rfKey = this.rfKey(userId, rtid);
                Device deviceInfo = (Device)this.cache.get(rfKey);
                if (deviceInfo != null && !this.equalsDeviceByTypeOrId(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(rfKey);
                refreshInfoKeys.remove(rfKey);
                return true;
            });
            refreshInfoKeys.removeIf(key -> {
                Device deviceInfo = (Device)this.cache.get((String)key);
                if (deviceInfo != null && !this.equalsDeviceByTypeOrId(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(this.requestKey(userId, (String)key));
                return true;
            });
        } else {
            accessInfoKeys.removeIf(key -> {
                AccessInfo accessInfo = (AccessInfo)this.cache.get((String)key);
                if (accessInfo == null) {
                    return true;
                }
                String rtid = accessInfo.getRefreshTokenId();
                if (rtid == null) {
                    return false;
                }
                String rfKey = this.rfKey(userId, rtid);
                Device deviceInfo = (Device)this.cache.get(rfKey);
                if (deviceInfo != null && !this.equalsDeviceById(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(rfKey);
                refreshInfoKeys.remove(rfKey);
                return true;
            });
            refreshInfoKeys.removeIf(key -> {
                Device deviceInfo = (Device)this.cache.get((String)key);
                if (deviceInfo != null && !this.equalsDeviceById(deviceInfo, device)) {
                    return false;
                }
                delKeys.add((String)key);
                delKeys.add(this.requestKey(userId, (String)key));
                return true;
            });
        }
        if (!delKeys.isEmpty()) {
            Async.run(() -> this.cache.del(delKeys));
        }
        AccessInfo accessInfo = new AccessInfo().setRefreshTokenId(tokenPair.getRefreshToken().getTokenId());
        RefreshInfo refreshInfo = new RefreshInfo().setDevice(device);
        long rfLiveTime = TimeUtils.parseTimeValueTotal((String[])new String[]{this.properties.getToken().getLiveTime(), this.properties.getToken().getRefreshTime(), "10s"});
        Async.run(() -> {
            this.cache.setSneaky(this.requestKeyByTokenId(userId, tokenPair.getRefreshToken().getTokenId()), RequestInfo.of(httpMeta), rfLiveTime, TimeUnit.MILLISECONDS);
            this.cache.del(this.acKey(userId, "*"));
            this.cache.del(this.rfKey(userId, "*"));
        });
        return Async.joinAndCheck((CompletableFuture)Async.combine(() -> this.cache.set(this.acKey(userId, tokenPair), accessInfo, this.properties.getToken().getLiveTime()), () -> this.cache.set(this.rfKey(userId, tokenPair), refreshInfo, rfLiveTime, TimeUnit.MILLISECONDS)));
    }

    @Override
    public boolean refreshUser(TokenPair tokenPair) {
        if (tokenPair == null) {
            return false;
        }
        Token accessToken = tokenPair.getAccessToken();
        Object userId = accessToken.getUserId();
        String rfKey = this.rfKey(userId, tokenPair);
        if (this.cache.notKey(rfKey)) {
            return false;
        }
        String k = null;
        for (String key : this.cache.keysAndLoad(this.acKey(userId, "*"))) {
            Device deviceInfo = this.getDeviceOe(userId, key);
            if (deviceInfo == null || !StringUtils.equals((String)accessToken.getDeviceType(), (String)deviceInfo.getType()) || !StringUtils.equals((String)accessToken.getDeviceId(), (String)deviceInfo.getId())) continue;
            k = key;
            break;
        }
        if (k != null) {
            this.cache.del(k);
        }
        AccessInfo accessInfo = new AccessInfo().setRefreshTokenId(tokenPair.getRefreshToken().getTokenId());
        Async.run(() -> {
            this.cache.del(this.acKey(userId, "*"));
            this.cache.del(this.rfKey(userId, "*"));
        });
        this.cache.set(this.acKey(userId, tokenPair), accessInfo, this.properties.getToken().getLiveTime());
        return true;
    }

    @Override
    public void removeAllDeviceByUserId(Object userId) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.cache.keys(this.acKey(userId, "*")));
        keys.addAll(this.cache.keys(this.rfKey(userId, "*")));
        keys.add(this.acKey(userId, "*"));
        keys.add(this.rfKey(userId, "*"));
        this.cache.del(keys);
    }

    @Override
    public void removeAllDeviceByCurrentUser() {
        try {
            this.removeAllDeviceByUserId(AUtils.getCurrentHttpMeta().getToken().getUserId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeDeviceByUserIdAndAccessTokenId(Object userId, String accessTokenId) {
        this.cache.del(this.acKey(userId, accessTokenId), this.acKey(userId, "*"));
    }

    @Override
    public void removeDeviceByCurrentUserAndAccessTokenId(String accessTokenId) {
        try {
            this.removeDeviceByUserIdAndAccessTokenId(AUtils.getCurrentHttpMeta().getToken().getUserId(), accessTokenId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeUser(Object userId, String deviceId, String deviceType) {
        Set<String> acKeys = this.cache.keysAndLoad(this.acKey(userId, "*"));
        Set<String> rfKeys = this.cache.keysAndLoad(this.rfKey(userId, "*"));
        HashSet<String> keys = new HashSet<String>();
        keys.add(this.acKey(userId, "*"));
        keys.add(this.rfKey(userId, "*"));
        if (deviceId != null) {
            acKeys.removeIf(acKey -> {
                Device deviceOe = this.getDeviceOe(userId, (String)acKey);
                if (deviceOe != null) {
                    if (this.equalsDeviceById(deviceOe, deviceId)) {
                        keys.add((String)acKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
            rfKeys.removeIf(rfKey -> {
                Device device = (Device)this.cache.get((String)rfKey);
                if (!device.isEmpty()) {
                    if (this.equalsDeviceById(device, deviceId)) {
                        keys.add((String)rfKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
        }
        if (deviceType != null) {
            acKeys.removeIf(acKey -> {
                Device deviceOe = this.getDeviceOe(userId, (String)acKey);
                if (deviceOe != null) {
                    if (this.equalsDeviceByType(deviceOe, deviceType)) {
                        keys.add((String)acKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
            rfKeys.removeIf(rfKey -> {
                Device device = (Device)this.cache.get((String)rfKey);
                if (!device.isEmpty()) {
                    if (this.equalsDeviceByType(device, deviceType)) {
                        keys.add((String)rfKey);
                        return true;
                    }
                    return false;
                }
                return true;
            });
        }
        this.cache.del(keys);
    }

    private Device getDeviceOe(Object userId, String acKey) {
        AccessInfo accessInfo = (AccessInfo)this.cache.get(acKey);
        String rtid = accessInfo.getRefreshTokenId();
        if (rtid != null) {
            String rfKey = this.rfKey(userId, rtid);
            return (Device)this.cache.get(rfKey);
        }
        return null;
    }

    @Override
    public void removeDeviceByUserIdAndDeviceType(Object userId, String deviceType) {
        this.removeUser(userId, null, deviceType);
    }

    @Override
    public void removeDeviceByCurrentUserAndDeviceType(String deviceType) {
        try {
            this.removeDeviceByUserIdAndDeviceType(AUtils.getCurrentHttpMeta().getToken().getUserId(), deviceType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeDeviceByUserIdAndDeviceId(Object userId, String deviceId) {
        this.removeUser(userId, deviceId, null);
    }

    @Override
    public void removeDeviceByCurrentUserAndDeviceId(String deviceId) {
        try {
            this.removeDeviceByUserIdAndDeviceId(AUtils.getCurrentHttpMeta().getToken().getUserId(), deviceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Device getDevice(Object userId, String deviceType, String deviceId) {
        Set<String> acKeys = this.cache.keysAndLoad(this.acKey(userId, "*"));
        if (CollectionUtils.isNotEmpty(acKeys)) {
            for (String acKey : acKeys) {
                Device deviceOe = this.getDeviceOe(userId, acKey);
                if (deviceOe == null || !this.equalsDeviceByTypeAndId(deviceOe, deviceType, deviceId)) continue;
                return deviceOe;
            }
        }
        return null;
    }

    @Override
    public Object[] listUserId() {
        Set<String> keys = this.cache.keys(this.acKey((Object)"*", "*"));
        return keys.stream().map(key -> key.split(":")[2]).distinct().toArray();
    }

    @Override
    public Device[] listDevicesByUserId(Object userId) {
        Set<String> keys = this.cache.keysAndLoad(this.acKey(userId, "*"));
        return (Device[])keys.stream().map(key -> this.getDeviceOe(userId, (String)key)).toArray(Device[]::new);
    }

    @Override
    public Device[] listDevicesForCurrentUser() {
        try {
            return this.listDevicesByUserId(AUtils.getCurrentHttpMeta().getToken().getUserId());
        }
        catch (Exception ignored) {
            return new Device[0];
        }
    }

    @Override
    public Object[] listActiveUsers(long ms) {
        long now = TimeUtils.nowTime();
        Set<String> rfKeys = this.cache.keysAndLoad(this.rfKey((Object)"*", "*"));
        return rfKeys.stream().filter(rfKey -> {
            Device device = (Device)this.cache.get((String)rfKey);
            if (device != null) {
                return now - device.getLastRequestTime().getTime() < ms;
            }
            return false;
        }).map(key -> key.split(":")[2]).distinct().toArray();
    }

    @Override
    public Device[] listActiveUserDevices(Object userId, long ms) {
        long now = TimeUtils.nowTime();
        Set<String> rfKeys = this.cache.keysAndLoad(this.rfKey(userId, "*"));
        return (Device[])rfKeys.stream().map(rfKey -> (Device)this.cache.get((String)rfKey)).filter(device -> now - device.getLastRequestTime().getTime() < ms).toArray(Device[]::new);
    }

    @Override
    public void request() {
        try {
            HttpMeta currentHttpMeta = AUtils.getCurrentHttpMeta();
            Token token = currentHttpMeta.getToken();
            String acKey = this.acKey(token.getUserId(), token.getTokenId());
            Object o = this.cache.get(acKey);
            if (o == null) {
                return;
            }
            String rtid = ((AccessInfo)o).getRefreshTokenId();
            if (rtid != null) {
                this.cache.setSneaky(this.requestKeyByTokenId(token.getUserId(), rtid), RequestInfo.of(currentHttpMeta), -1L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String requestKey(Object userId, String rfKey) {
        return "au:requestInfo:" + userId + ":" + rfKey.split(":")[3];
    }

    private String requestKeyByTokenId(Object userId, String tokenId) {
        return "au:requestInfo:" + userId + ":" + tokenId;
    }

    private String acKey(Object userId, String tokenId) {
        return "au:usersAccessInfo:" + userId + ":" + tokenId;
    }

    private String rfKey(Object userId, String tokenId) {
        return "au:usersRefreshInfo:" + userId + ":" + tokenId;
    }

    private String acKey(Object userId, TokenPair tokenPair) {
        return this.acKey(userId, tokenPair.getAccessToken().getTokenId());
    }

    private String rfKey(Object userId, TokenPair tokenPair) {
        return this.rfKey(userId, tokenPair.getRefreshToken().getTokenId());
    }

    private boolean equalsDeviceByTypeOrId(Device device, Device otherDevice) {
        if (device == null) {
            return false;
        }
        return StringUtils.equals((String)device.getType(), (String)otherDevice.getType()) || device.getId() != null && StringUtils.equals((String)device.getId(), (String)otherDevice.getId());
    }

    private boolean equalsDeviceByTypeAndId(Device device, String deviceType, String deviceId) {
        if (device == null) {
            return false;
        }
        return StringUtils.equals((String)device.getType(), (String)deviceType) && StringUtils.equals((String)device.getId(), (String)deviceId);
    }

    private boolean equalsDeviceById(Device device, Device otherDevice) {
        if (device == null) {
            return false;
        }
        return this.equalsDeviceById(device, otherDevice.getId());
    }

    private boolean equalsDeviceById(Device device, String deviceId) {
        if (device == null) {
            return false;
        }
        return device.getId() != null && StringUtils.equals((String)device.getId(), (String)deviceId);
    }

    private boolean equalsDeviceByType(Device device, String deviceType) {
        if (device == null) {
            return false;
        }
        return StringUtils.equals((String)device.getType(), (String)deviceType);
    }
}

