/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.aggregate;

import cn.omisheep.authz.core.aggregate.Summable;
import cn.omisheep.commons.util.CapacityRestrictedQueue;
import cn.omisheep.commons.util.TimeUtils;
import java.io.Serializable;
import java.util.Arrays;
import org.springframework.util.Assert;

public class LatestMonths
implements Summable,
Serializable {
    private static final long serialVersionUID = -8475095254772414060L;
    private long[] list;
    private long total;
    private final CapacityRestrictedQueue<Month> months;

    public LatestMonths() {
        this(12);
    }

    public LatestMonths(int maxCapacity) {
        this.months = new CapacityRestrictedQueue(maxCapacity);
    }

    private void createMonth(int ... yearAndMonth) {
        this.months.offerFirst((Object)new Month(yearAndMonth[0], yearAndMonth[1]));
    }

    public void update(int dayInMonth, int num) {
        if (this.months.size() == 0) {
            this.createMonth(TimeUtils.yesterdayYearAndMonth());
            ((Month)this.months.getFirst()).set(dayInMonth, num);
        } else {
            Month first = (Month)this.months.getFirst();
            first.set(dayInMonth, num);
            if (first.getMonth() != TimeUtils.currentMonth()) {
                this.createMonth(TimeUtils.currentMonth());
            }
        }
        this.list = this.months.stream().mapToLong(Summable::getTotal).toArray();
        this.total = Arrays.stream(this.list).sum();
    }

    public void update(int num) {
        this.update(TimeUtils.nowMinus((String)"1d").getDayOfMonth(), num);
    }

    public long[] getList() {
        return this.list;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    public CapacityRestrictedQueue<Month> getMonths() {
        return this.months;
    }

    public void setList(long[] list) {
        this.list = list;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatestMonths)) {
            return false;
        }
        LatestMonths other = (LatestMonths)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (!Arrays.equals(this.getList(), other.getList())) {
            return false;
        }
        CapacityRestrictedQueue<Month> this$months = this.getMonths();
        CapacityRestrictedQueue<Month> other$months = other.getMonths();
        return !(this$months == null ? other$months != null : !this$months.equals(other$months));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LatestMonths;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + Arrays.hashCode(this.getList());
        CapacityRestrictedQueue<Month> $months = this.getMonths();
        result = result * 59 + ($months == null ? 43 : $months.hashCode());
        return result;
    }

    public String toString() {
        return "LatestMonths(list=" + Arrays.toString(this.getList()) + ", total=" + this.getTotal() + ", months=" + this.getMonths() + ")";
    }

    public static class Month
    implements Summable,
    Serializable {
        private static final long serialVersionUID = -8166291528042324667L;
        private long[] days;
        private long total = 0L;
        private final String date = TimeUtils.nowString((String)"y-M");
        private final int month = TimeUtils.currentMonth();

        public Month() {
        }

        public Month(int year, int month) {
            this.days = new long[TimeUtils.maxDaysInMonth((int)year, (int)month)];
        }

        public void set(int dayInMonth, int num) {
            Assert.isTrue((num > 0 ? 1 : 0) != 0, (String)"ensure num > 0");
            Assert.isTrue((dayInMonth >= 0 && dayInMonth <= 31 ? 1 : 0) != 0, (String)"ensure dayInMonth from 1 to 31");
            this.total += (long)num - this.days[dayInMonth - 1];
            this.days[dayInMonth - 1] = num;
        }

        public long[] getDays() {
            return this.days;
        }

        @Override
        public long getTotal() {
            return this.total;
        }

        public String getDate() {
            return this.date;
        }

        public int getMonth() {
            return this.month;
        }

        public void setDays(long[] days) {
            this.days = days;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Month)) {
                return false;
            }
            Month other = (Month)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            if (this.getMonth() != other.getMonth()) {
                return false;
            }
            if (!Arrays.equals(this.getDays(), other.getDays())) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Month;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            result = result * 59 + this.getMonth();
            result = result * 59 + Arrays.hashCode(this.getDays());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }

        public String toString() {
            return "LatestMonths.Month(days=" + Arrays.toString(this.getDays()) + ", total=" + this.getTotal() + ", date=" + this.getDate() + ", month=" + this.getMonth() + ")";
        }
    }
}

