/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.aggregate;

import cn.omisheep.authz.core.aggregate.Summable;
import cn.omisheep.commons.util.CapacityRestrictedQueue;
import cn.omisheep.commons.util.TimeUtils;
import java.io.Serializable;
import java.util.Arrays;
import org.springframework.util.Assert;

public class LatestHours
implements Summable,
Serializable {
    private static final long serialVersionUID = -3679258668123086765L;
    private long[] list;
    private long total;
    private final CapacityRestrictedQueue<Hour> hours;

    public LatestHours() {
        this(24);
    }

    public LatestHours(int maxCapacity) {
        this.hours = new CapacityRestrictedQueue(maxCapacity);
    }

    public void update(int minute, int num) {
        if (this.hours.size() == 0) {
            this.hours.offerFirst((Object)new Hour());
            ((Hour)this.hours.getFirst()).setMinute(minute, num);
        } else {
            Hour first = (Hour)this.hours.getFirst();
            first.setMinute(minute, num);
            if (first.getHour() != TimeUtils.currentHour()) {
                this.hours.offerFirst((Object)new Hour());
            }
        }
        this.list = this.hours.stream().mapToLong(Summable::getTotal).toArray();
        this.total = Arrays.stream(this.list).sum();
    }

    public void update(int num) {
        this.update((TimeUtils.currentMinute() - 1 + 60) % 60, num);
    }

    public long[] getList() {
        return this.list;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    public CapacityRestrictedQueue<Hour> getHours() {
        return this.hours;
    }

    public void setList(long[] list) {
        this.list = list;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatestHours)) {
            return false;
        }
        LatestHours other = (LatestHours)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (!Arrays.equals(this.getList(), other.getList())) {
            return false;
        }
        CapacityRestrictedQueue<Hour> this$hours = this.getHours();
        CapacityRestrictedQueue<Hour> other$hours = other.getHours();
        return !(this$hours == null ? other$hours != null : !this$hours.equals(other$hours));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LatestHours;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + Arrays.hashCode(this.getList());
        CapacityRestrictedQueue<Hour> $hours = this.getHours();
        result = result * 59 + ($hours == null ? 43 : $hours.hashCode());
        return result;
    }

    public String toString() {
        return "LatestHours(list=" + Arrays.toString(this.getList()) + ", total=" + this.getTotal() + ", hours=" + this.getHours() + ")";
    }

    public static class Hour
    implements Summable,
    Serializable {
        private static final long serialVersionUID = -64338996914080622L;
        private long[] minutes = new long[60];
        private long total = 0L;
        private final String date = TimeUtils.nowString((String)"y-M-d_h");
        private final int hour = TimeUtils.currentHour();

        public void setMinute(int minute, long num) {
            Assert.isTrue((num >= 0L ? 1 : 0) != 0, (String)"ensure num > 0");
            Assert.isTrue((minute >= 0 && minute <= 59 ? 1 : 0) != 0, (String)"ensure minute from 0 to 59");
            this.total += num - this.minutes[minute];
            this.minutes[minute] = num;
        }

        public long[] getMinutes() {
            return this.minutes;
        }

        @Override
        public long getTotal() {
            return this.total;
        }

        public String getDate() {
            return this.date;
        }

        public int getHour() {
            return this.hour;
        }

        public void setMinutes(long[] minutes) {
            this.minutes = minutes;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hour)) {
                return false;
            }
            Hour other = (Hour)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            if (this.getHour() != other.getHour()) {
                return false;
            }
            if (!Arrays.equals(this.getMinutes(), other.getMinutes())) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Hour;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            result = result * 59 + this.getHour();
            result = result * 59 + Arrays.hashCode(this.getMinutes());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }

        public String toString() {
            return "LatestHours.Hour(minutes=" + Arrays.toString(this.getMinutes()) + ", total=" + this.getTotal() + ", date=" + this.getDate() + ", hour=" + this.getHour() + ")";
        }
    }
}

