/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.aggregate;

import cn.omisheep.authz.annotation.Aggregate;
import cn.omisheep.authz.annotation.StatisticalType;
import cn.omisheep.authz.core.aggregate.Details;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.authz.core.util.AUtils;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class AggregateManager {
    private static final Logger log = LoggerFactory.getLogger(AggregateManager.class);
    private final Details details = new Details();
    private static final HashMap<StatisticalType, ConcurrentHashMap<String, Object>> cmp = new HashMap();

    @Pointcut(value="@annotation(cn.omisheep.authz.annotation.Aggregate)")
    public void hasAggregate() {
    }

    @Before(value="hasAggregate()")
    public void Before(JoinPoint joinPoint) {
        String scope;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Aggregate a1 = (Aggregate)AnnotationUtils.getAnnotation((Method)methodSignature.getMethod(), Aggregate.class);
        Aggregate a2 = (Aggregate)AnnotationUtils.getAnnotation((AnnotatedElement)joinPoint.getSignature().getDeclaringType(), Aggregate.class);
        StatisticalType[] types = (StatisticalType[])Stream.concat(Arrays.stream(a1 != null ? a1.statisticalType() : new StatisticalType[]{}), Arrays.stream(a2 != null ? a2.statisticalType() : new StatisticalType[]{})).distinct().toArray(StatisticalType[]::new);
        HttpMeta currentHttpMeta = AUtils.getCurrentHttpMeta();
        if (currentHttpMeta == null) {
            return;
        }
        String string = scope = a1 != null ? a1.scope() : "";
        if (a2 != null && !a2.scope().equals("")) {
            scope = a2.scope();
        }
        block5: for (StatisticalType type : types) {
            switch (type) {
                case PV: {
                    this.pv(currentHttpMeta, scope);
                    continue block5;
                }
                case UV: {
                    this.uv(currentHttpMeta, scope);
                    continue block5;
                }
                case IP: {
                    this.ip(currentHttpMeta, scope);
                }
            }
        }
    }

    public void uv(HttpMeta httpMeta, String scope) {
        Token token = httpMeta.getToken();
        if (token != null) {
            HyperLogLog hyperLogLog = (HyperLogLog)cmp.get((Object)StatisticalType.UV).computeIfAbsent(scope, k -> new HyperLogLog(1.0E-4));
            hyperLogLog.offer(token.getUserId());
        }
    }

    public void ip(HttpMeta httpMeta, String scope) {
        String ip = httpMeta.getIp();
        HyperLogLog hyperLogLog = (HyperLogLog)cmp.get((Object)StatisticalType.IP).computeIfAbsent(scope, k -> new HyperLogLog(1.0E-4));
        hyperLogLog.offer((Object)ip);
    }

    public void pv(HttpMeta httpMeta, String scope) {
        long d = (Long)cmp.get((Object)StatisticalType.PV).computeIfAbsent(scope, k -> 0L);
        System.out.println(++d);
    }

    public Details getDetails() {
        return this.details;
    }

    public static HashMap<StatisticalType, ConcurrentHashMap<String, Object>> getCmp() {
        return cmp;
    }

    static {
        Arrays.stream(StatisticalType.values()).forEach(type -> cmp.put((StatisticalType)((Object)type), new ConcurrentHashMap()));
    }
}

