/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import org.springframework.http.HttpStatus;

public enum ExceptionStatus {
    UNKNOWN(100, "unknown", HttpStatus.INTERNAL_SERVER_ERROR),
    MISMATCHED_URL(200, "URL matching failed", HttpStatus.NOT_FOUND),
    ACCESS_TOKEN_OVERDUE(300, "AccessToken overdue", HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    REQUIRE_LOGIN(301, "Require login", HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    PERM_EXCEPTION(302, "Insufficient permissions", HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    TOKEN_EXCEPTION(400, "Token exception", HttpStatus.FORBIDDEN),
    REQUEST_REPEAT(401, "Request repeat error", HttpStatus.TOO_MANY_REQUESTS),
    LOGIN_EXCEPTION(402, "You are offline, or you may have logged in elsewhere", HttpStatus.FORBIDDEN),
    CONTENT_TYPE_ERROR(500, "Content type not supported, must be json", HttpStatus.INTERNAL_SERVER_ERROR),
    PAGE_NOT_SUPPORT(501, "Page not support, check database type, only mysql and oracle", HttpStatus.INTERNAL_SERVER_ERROR);

    private final int code;
    private final String message;
    private final HttpStatus httpStatus;

    private ExceptionStatus(int code, String message, HttpStatus httpStatus) {
        this.code = code;
        this.message = message;
        this.httpStatus = httpStatus;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }
}

