/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogLevel;

@ConfigurationProperties(prefix="authz")
public class AuthzProperties {
    private TokenConfig token = new TokenConfig();
    private UserConfig user = new UserConfig();
    private CacheConfig cache = new CacheConfig();
    private MybatisConfig mybatis = new MybatisConfig();
    private boolean dataFilter = true;
    private String rsaKeyRefreshWithPeriod = "7d";
    private String userBufferRefreshWithPeriod = "10s";
    private String gcPeriod;
    private LogLevel log = LogLevel.INFO;

    public TokenConfig getToken() {
        return this.token;
    }

    public UserConfig getUser() {
        return this.user;
    }

    public CacheConfig getCache() {
        return this.cache;
    }

    public MybatisConfig getMybatis() {
        return this.mybatis;
    }

    public boolean isDataFilter() {
        return this.dataFilter;
    }

    public String getRsaKeyRefreshWithPeriod() {
        return this.rsaKeyRefreshWithPeriod;
    }

    public String getUserBufferRefreshWithPeriod() {
        return this.userBufferRefreshWithPeriod;
    }

    public String getGcPeriod() {
        return this.gcPeriod;
    }

    public LogLevel getLog() {
        return this.log;
    }

    public void setToken(TokenConfig token) {
        this.token = token;
    }

    public void setUser(UserConfig user) {
        this.user = user;
    }

    public void setCache(CacheConfig cache) {
        this.cache = cache;
    }

    public void setMybatis(MybatisConfig mybatis) {
        this.mybatis = mybatis;
    }

    public void setDataFilter(boolean dataFilter) {
        this.dataFilter = dataFilter;
    }

    public void setRsaKeyRefreshWithPeriod(String rsaKeyRefreshWithPeriod) {
        this.rsaKeyRefreshWithPeriod = rsaKeyRefreshWithPeriod;
    }

    public void setUserBufferRefreshWithPeriod(String userBufferRefreshWithPeriod) {
        this.userBufferRefreshWithPeriod = userBufferRefreshWithPeriod;
    }

    public void setGcPeriod(String gcPeriod) {
        this.gcPeriod = gcPeriod;
    }

    public void setLog(LogLevel log) {
        this.log = log;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthzProperties)) {
            return false;
        }
        AuthzProperties other = (AuthzProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDataFilter() != other.isDataFilter()) {
            return false;
        }
        TokenConfig this$token = this.getToken();
        TokenConfig other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        UserConfig this$user = this.getUser();
        UserConfig other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        CacheConfig this$cache = this.getCache();
        CacheConfig other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        MybatisConfig this$mybatis = this.getMybatis();
        MybatisConfig other$mybatis = other.getMybatis();
        if (this$mybatis == null ? other$mybatis != null : !((Object)this$mybatis).equals(other$mybatis)) {
            return false;
        }
        String this$rsaKeyRefreshWithPeriod = this.getRsaKeyRefreshWithPeriod();
        String other$rsaKeyRefreshWithPeriod = other.getRsaKeyRefreshWithPeriod();
        if (this$rsaKeyRefreshWithPeriod == null ? other$rsaKeyRefreshWithPeriod != null : !this$rsaKeyRefreshWithPeriod.equals(other$rsaKeyRefreshWithPeriod)) {
            return false;
        }
        String this$userBufferRefreshWithPeriod = this.getUserBufferRefreshWithPeriod();
        String other$userBufferRefreshWithPeriod = other.getUserBufferRefreshWithPeriod();
        if (this$userBufferRefreshWithPeriod == null ? other$userBufferRefreshWithPeriod != null : !this$userBufferRefreshWithPeriod.equals(other$userBufferRefreshWithPeriod)) {
            return false;
        }
        String this$gcPeriod = this.getGcPeriod();
        String other$gcPeriod = other.getGcPeriod();
        if (this$gcPeriod == null ? other$gcPeriod != null : !this$gcPeriod.equals(other$gcPeriod)) {
            return false;
        }
        LogLevel this$log = this.getLog();
        LogLevel other$log = other.getLog();
        return !(this$log == null ? other$log != null : !this$log.equals(other$log));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthzProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDataFilter() ? 79 : 97);
        TokenConfig $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        UserConfig $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        CacheConfig $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        MybatisConfig $mybatis = this.getMybatis();
        result = result * 59 + ($mybatis == null ? 43 : ((Object)$mybatis).hashCode());
        String $rsaKeyRefreshWithPeriod = this.getRsaKeyRefreshWithPeriod();
        result = result * 59 + ($rsaKeyRefreshWithPeriod == null ? 43 : $rsaKeyRefreshWithPeriod.hashCode());
        String $userBufferRefreshWithPeriod = this.getUserBufferRefreshWithPeriod();
        result = result * 59 + ($userBufferRefreshWithPeriod == null ? 43 : $userBufferRefreshWithPeriod.hashCode());
        String $gcPeriod = this.getGcPeriod();
        result = result * 59 + ($gcPeriod == null ? 43 : $gcPeriod.hashCode());
        LogLevel $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        return result;
    }

    public String toString() {
        return "AuthzProperties(token=" + this.getToken() + ", user=" + this.getUser() + ", cache=" + this.getCache() + ", mybatis=" + this.getMybatis() + ", dataFilter=" + this.isDataFilter() + ", rsaKeyRefreshWithPeriod=" + this.getRsaKeyRefreshWithPeriod() + ", userBufferRefreshWithPeriod=" + this.getUserBufferRefreshWithPeriod() + ", gcPeriod=" + this.getGcPeriod() + ", log=" + this.getLog() + ")";
    }

    public static class MybatisConfig {
        private Version version = Version.V_3_4_0_up;

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MybatisConfig)) {
                return false;
            }
            MybatisConfig other = (MybatisConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MybatisConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.MybatisConfig(version=" + (Object)((Object)this.getVersion()) + ")";
        }

        static enum Version {
            V_3_4_0_up("3.4.0+"),
            V_3_4_0_low("3.4.0-");

            private final String version;

            private Version(String version) {
                this.version = version;
            }

            public String getVersion() {
                return this.version;
            }
        }
    }

    public static class UserConfig {
        private boolean supportMultiDevice = true;
        private boolean supportMultiUserForSameDeviceType = false;

        public boolean isSupportMultiDevice() {
            return this.supportMultiDevice;
        }

        public boolean isSupportMultiUserForSameDeviceType() {
            return this.supportMultiUserForSameDeviceType;
        }

        public void setSupportMultiDevice(boolean supportMultiDevice) {
            this.supportMultiDevice = supportMultiDevice;
        }

        public void setSupportMultiUserForSameDeviceType(boolean supportMultiUserForSameDeviceType) {
            this.supportMultiUserForSameDeviceType = supportMultiUserForSameDeviceType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserConfig)) {
                return false;
            }
            UserConfig other = (UserConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSupportMultiDevice() != other.isSupportMultiDevice()) {
                return false;
            }
            return this.isSupportMultiUserForSameDeviceType() == other.isSupportMultiUserForSameDeviceType();
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSupportMultiDevice() ? 79 : 97);
            result = result * 59 + (this.isSupportMultiUserForSameDeviceType() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AuthzProperties.UserConfig(supportMultiDevice=" + this.isSupportMultiDevice() + ", supportMultiUserForSameDeviceType=" + this.isSupportMultiUserForSameDeviceType() + ")";
        }
    }

    public static class TokenConfig {
        private String key;
        private String cookieName = "atkn";
        private String headerName = "Authorization";
        private String headerPrefix = "Bearer";
        private String liveTime = "7d";
        private String refreshTime = "30d";
        private String issuer = "au";

        public String getKey() {
            return this.key;
        }

        public String getCookieName() {
            return this.cookieName;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public String getHeaderPrefix() {
            return this.headerPrefix;
        }

        public String getLiveTime() {
            return this.liveTime;
        }

        public String getRefreshTime() {
            return this.refreshTime;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public void setHeaderPrefix(String headerPrefix) {
            this.headerPrefix = headerPrefix;
        }

        public void setLiveTime(String liveTime) {
            this.liveTime = liveTime;
        }

        public void setRefreshTime(String refreshTime) {
            this.refreshTime = refreshTime;
        }

        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenConfig)) {
                return false;
            }
            TokenConfig other = (TokenConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$cookieName = this.getCookieName();
            String other$cookieName = other.getCookieName();
            if (this$cookieName == null ? other$cookieName != null : !this$cookieName.equals(other$cookieName)) {
                return false;
            }
            String this$headerName = this.getHeaderName();
            String other$headerName = other.getHeaderName();
            if (this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName)) {
                return false;
            }
            String this$headerPrefix = this.getHeaderPrefix();
            String other$headerPrefix = other.getHeaderPrefix();
            if (this$headerPrefix == null ? other$headerPrefix != null : !this$headerPrefix.equals(other$headerPrefix)) {
                return false;
            }
            String this$liveTime = this.getLiveTime();
            String other$liveTime = other.getLiveTime();
            if (this$liveTime == null ? other$liveTime != null : !this$liveTime.equals(other$liveTime)) {
                return false;
            }
            String this$refreshTime = this.getRefreshTime();
            String other$refreshTime = other.getRefreshTime();
            if (this$refreshTime == null ? other$refreshTime != null : !this$refreshTime.equals(other$refreshTime)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            return !(this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $cookieName = this.getCookieName();
            result = result * 59 + ($cookieName == null ? 43 : $cookieName.hashCode());
            String $headerName = this.getHeaderName();
            result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
            String $headerPrefix = this.getHeaderPrefix();
            result = result * 59 + ($headerPrefix == null ? 43 : $headerPrefix.hashCode());
            String $liveTime = this.getLiveTime();
            result = result * 59 + ($liveTime == null ? 43 : $liveTime.hashCode());
            String $refreshTime = this.getRefreshTime();
            result = result * 59 + ($refreshTime == null ? 43 : $refreshTime.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.TokenConfig(key=" + this.getKey() + ", cookieName=" + this.getCookieName() + ", headerName=" + this.getHeaderName() + ", headerPrefix=" + this.getHeaderPrefix() + ", liveTime=" + this.getLiveTime() + ", refreshTime=" + this.getRefreshTime() + ", issuer=" + this.getIssuer() + ")";
        }
    }

    public static class CacheConfig {
        private boolean enableRedis = false;
        private boolean enableRedisActuator = false;
        private int redisScanCount = 10000;
        private Long cacheMaximumSize;
        private String expireAfterReadOrUpdateTime = "10m";

        public boolean isEnableRedis() {
            return this.enableRedis;
        }

        public boolean isEnableRedisActuator() {
            return this.enableRedisActuator;
        }

        public int getRedisScanCount() {
            return this.redisScanCount;
        }

        public Long getCacheMaximumSize() {
            return this.cacheMaximumSize;
        }

        public String getExpireAfterReadOrUpdateTime() {
            return this.expireAfterReadOrUpdateTime;
        }

        public void setEnableRedis(boolean enableRedis) {
            this.enableRedis = enableRedis;
        }

        public void setEnableRedisActuator(boolean enableRedisActuator) {
            this.enableRedisActuator = enableRedisActuator;
        }

        public void setRedisScanCount(int redisScanCount) {
            this.redisScanCount = redisScanCount;
        }

        public void setCacheMaximumSize(Long cacheMaximumSize) {
            this.cacheMaximumSize = cacheMaximumSize;
        }

        public void setExpireAfterReadOrUpdateTime(String expireAfterReadOrUpdateTime) {
            this.expireAfterReadOrUpdateTime = expireAfterReadOrUpdateTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheConfig)) {
                return false;
            }
            CacheConfig other = (CacheConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnableRedis() != other.isEnableRedis()) {
                return false;
            }
            if (this.isEnableRedisActuator() != other.isEnableRedisActuator()) {
                return false;
            }
            if (this.getRedisScanCount() != other.getRedisScanCount()) {
                return false;
            }
            Long this$cacheMaximumSize = this.getCacheMaximumSize();
            Long other$cacheMaximumSize = other.getCacheMaximumSize();
            if (this$cacheMaximumSize == null ? other$cacheMaximumSize != null : !((Object)this$cacheMaximumSize).equals(other$cacheMaximumSize)) {
                return false;
            }
            String this$expireAfterReadOrUpdateTime = this.getExpireAfterReadOrUpdateTime();
            String other$expireAfterReadOrUpdateTime = other.getExpireAfterReadOrUpdateTime();
            return !(this$expireAfterReadOrUpdateTime == null ? other$expireAfterReadOrUpdateTime != null : !this$expireAfterReadOrUpdateTime.equals(other$expireAfterReadOrUpdateTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableRedis() ? 79 : 97);
            result = result * 59 + (this.isEnableRedisActuator() ? 79 : 97);
            result = result * 59 + this.getRedisScanCount();
            Long $cacheMaximumSize = this.getCacheMaximumSize();
            result = result * 59 + ($cacheMaximumSize == null ? 43 : ((Object)$cacheMaximumSize).hashCode());
            String $expireAfterReadOrUpdateTime = this.getExpireAfterReadOrUpdateTime();
            result = result * 59 + ($expireAfterReadOrUpdateTime == null ? 43 : $expireAfterReadOrUpdateTime.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzProperties.CacheConfig(enableRedis=" + this.isEnableRedis() + ", enableRedisActuator=" + this.isEnableRedisActuator() + ", redisScanCount=" + this.getRedisScanCount() + ", cacheMaximumSize=" + this.getCacheMaximumSize() + ", expireAfterReadOrUpdateTime=" + this.getExpireAfterReadOrUpdateTime() + ")";
        }
    }
}

