/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.annotation;

import cn.omisheep.authz.annotation.BannedType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RateLimit {
    public String window() default "1s";

    public int maxRequests() default 5;

    public String[] punishmentTime() default {"5m", "10m", "30m", "1h"};

    public String minInterval() default "0ms";

    public BannedType bannedType() default BannedType.API;

    public CheckType[] checkType() default {CheckType.IP};

    public String[] associatedPatterns() default {};

    public static enum CheckType {
        IP("ip"),
        USER_ID("USER_ID", "user_id", "userId", "id");

        private final String[] names;

        private CheckType(String ... names) {
            this.names = names;
        }

        public static CheckType of(String name) {
            for (CheckType value : CheckType.values()) {
                if (!Arrays.asList(value.names).contains(name)) continue;
                return value;
            }
            return null;
        }
    }
}

