/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.aggregate.AggregateManager;
import cn.omisheep.authz.core.auth.DefaultPermLibrary;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDictByCache;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDictByHashMap;
import cn.omisheep.authz.core.auth.ipf.AuthzHttpFilter;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.cache.DefaultCache;
import cn.omisheep.authz.core.cache.L2Cache;
import cn.omisheep.authz.core.cache.PermLibraryCache;
import cn.omisheep.authz.core.init.AuCoreInitialization;
import cn.omisheep.authz.core.init.AuInit;
import cn.omisheep.authz.core.interceptor.AuthzExceptionHandler;
import cn.omisheep.authz.core.interceptor.AuthzFeignRequestInterceptor;
import cn.omisheep.authz.core.interceptor.AuthzHandlerRegister;
import cn.omisheep.authz.core.interceptor.AuthzRestTemplateInterceptor;
import cn.omisheep.authz.core.interceptor.DataFinderSecurityInterceptor;
import cn.omisheep.authz.core.interceptor.DecryptRequestBodyAdvice;
import cn.omisheep.authz.core.interceptor.DefaultAuthzExceptionHandler;
import cn.omisheep.authz.core.interceptor.DefaultDataSecurityInterceptor;
import cn.omisheep.authz.core.interceptor.mybatis.DataSecurityInterceptorForMybatis;
import cn.omisheep.authz.core.msg.MessageReceive;
import cn.omisheep.authz.core.msg.RequestMessage;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={AuthzProperties.class})
@ConditionalOnClass(value={AuInit.class})
@Import(value={AuInit.class})
public class AuthzAutoConfiguration {
    @Bean
    public DecryptRequestBodyAdvice auDecryptRequestBodyAdvice() {
        return new DecryptRequestBodyAdvice();
    }

    @Bean
    public AggregateManager aggregateManager() {
        return new AggregateManager();
    }

    @Bean
    public PermLibraryCache permLibraryCache(Cache cache) {
        return new PermLibraryCache(cache);
    }

    @Bean
    public UserDevicesDict userDevicesDict(AuthzProperties properties, Cache cache) {
        if (properties.getCache().isEnableRedis()) {
            return new UserDevicesDictByCache(properties, cache);
        }
        return new UserDevicesDictByHashMap(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public PermLibrary permLibrary() {
        return new DefaultPermLibrary();
    }

    @Bean
    public AuthzDefender auDefender(UserDevicesDict userDevicesDict, PermissionDict permissionDict, PermLibrary permLibrary) {
        return new AuthzDefender(userDevicesDict, permissionDict, permLibrary);
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthzExceptionHandler authzExceptionHandler() {
        return new DefaultAuthzExceptionHandler();
    }

    @Bean
    public AuthzHandlerRegister authzHandlerRegister(AuthzExceptionHandler authzExceptionHandler) {
        return new AuthzHandlerRegister(authzExceptionHandler);
    }

    @Bean(value={"AuthzHttpFilter"})
    public FilterRegistrationBean<AuthzHttpFilter> filterRegistrationBean(Httpd httpd) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new AuthzHttpFilter(httpd));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("authzFilter");
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public AuCoreInitialization auCoreInitialization(AuthzProperties properties, Httpd httpd, UserDevicesDict userDevicesDict, PermissionDict permissionDict, PermLibrary permLibrary, Cache cache) {
        return new AuCoreInitialization(properties, httpd, userDevicesDict, permissionDict, permLibrary, cache);
    }

    @Configuration
    @ConditionalOnProperty(name={"authz.data-interceptor"}, havingValue="true", matchIfMissing=true)
    public static class DataFilterAutoConfiguration {
        @Bean
        @ConditionalOnProperty(name={"authz.mybatis.version"}, havingValue="v_3_4_0_up")
        @ConditionalOnMissingBean
        public DataSecurityInterceptorForMybatis dataSecurityInterceptorForMybatis(PermissionDict permissionDict, PermLibrary permLibrary, DataFinderSecurityInterceptor dataFinderSecurityInterceptor) {
            return new DataSecurityInterceptorForMybatis(permissionDict, permLibrary, dataFinderSecurityInterceptor);
        }

        @Bean
        @ConditionalOnMissingBean
        public DataFinderSecurityInterceptor dataFinderSecurityInterceptor() {
            return new DefaultDataSecurityInterceptor();
        }
    }

    @Configuration
    public static class AuthzCloudAutoConfiguration {
        @Bean
        @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignContext"})
        public AuthzFeignRequestInterceptor authzFeignRequestInterceptor() {
            return new AuthzFeignRequestInterceptor();
        }

        @Autowired(required=false)
        @ConditionalOnBean(value={RestTemplate.class})
        public void authzRestTemplateInterceptor(RestTemplate restTemplate) {
            restTemplate.getInterceptors().add(new AuthzRestTemplateInterceptor());
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={RedisProperties.class})
    public static class CacheAutoConfiguration {
        public static Jackson2JsonRedisSerializer jackson2JsonRedisSerializer;
        public static StringRedisSerializer stringRedisSerializer;

        @Bean(name={"redisHealthIndicator"})
        @ConditionalOnProperty(name={"authz.cache.enable-redis-actuator"}, havingValue="false", matchIfMissing=true)
        public Object nonRedisActuator() {
            return new Object();
        }

        @Bean(value={"authzRedisTemplate"})
        @ConditionalOnMissingBean(name={"authzRedisTemplate"})
        @ConditionalOnProperty(prefix="authz.cache", name={"enable-redis"}, havingValue="true")
        public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            template.setKeySerializer((RedisSerializer)stringRedisSerializer);
            template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
            template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
            template.setHashKeySerializer((RedisSerializer)jackson2JsonRedisSerializer);
            template.afterPropertiesSet();
            return template;
        }

        @Bean(value={"authzCache"})
        public Cache cache(AuthzProperties properties) {
            if (properties.getCache().isEnableRedis()) {
                return new L2Cache(properties);
            }
            return new DefaultCache(properties.getCache().getCacheMaximumSize(), properties.getCache().getExpireAfterReadOrUpdateTime());
        }

        @Bean(value={"authzCacheMessageReceive"})
        @ConditionalOnProperty(prefix="authz.cache", name={"enable-redis"}, havingValue="true")
        public MessageReceive messageReceive(Cache cache, Httpd httpd) {
            return new MessageReceive(cache, httpd);
        }

        @Bean(value={"authzCacheMessageListenerAdapter"})
        @ConditionalOnBean(value={MessageReceive.class}, name={"authzCacheMessageReceive"})
        public MessageListenerAdapter authzCacheMessageListenerAdapter(@Qualifier(value="authzCacheMessageReceive") MessageReceive receiver) {
            return new MessageListenerAdapter((Object)receiver);
        }

        @Bean(value={"authzRequestCacheMessageListenerAdapter"})
        @ConditionalOnBean(value={MessageReceive.class}, name={"authzCacheMessageReceive"})
        public MessageListenerAdapter authzRequestCacheMessageListenerAdapter(@Qualifier(value="authzCacheMessageReceive") MessageReceive receiver) {
            return new MessageListenerAdapter((Object)receiver);
        }

        @Autowired
        private void getApplicationId(ConfigurableEnvironment environment) {
            String name = environment.getProperty("spring.application.name");
            RequestMessage.c.accept(StringUtils.hasText((String)name) ? name : "application");
        }

        @Bean(value={"auCacheRedisMessageListenerContainer"})
        @ConditionalOnBean(value={MessageReceive.class}, name={"authzCacheMessageReceive"})
        public RedisMessageListenerContainer container(@Qualifier(value="authzRedisTemplate") RedisTemplate redisTemplate, RedisConnectionFactory connectionFactory, @Qualifier(value="authzCacheMessageListenerAdapter") MessageListenerAdapter listenerAdapter1, @Qualifier(value="authzRequestCacheMessageListenerAdapter") MessageListenerAdapter listenerAdapter2) {
            try {
                redisTemplate.execute(RedisConnectionCommands::ping);
            }
            catch (Exception e) {
                throw new IllegalStateException("redis\u5f02\u5e38\uff0c\u68c0\u67e5redis\u914d\u7f6e\u662f\u5426\u6709\u6548");
            }
            RedisMessageListenerContainer container = new RedisMessageListenerContainer();
            container.setConnectionFactory(connectionFactory);
            container.addMessageListener((MessageListener)listenerAdapter1, (Topic)new PatternTopic("AU_CACHE_DATA_UPDATE"));
            container.addMessageListener((MessageListener)listenerAdapter2, (Topic)new PatternTopic(RequestMessage.CHANNEL));
            container.setTopicSerializer((RedisSerializer)jackson2JsonRedisSerializer);
            return container;
        }

        static {
            stringRedisSerializer = new StringRedisSerializer();
            jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
            jackson2JsonRedisSerializer.setObjectMapper(new ObjectMapper().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY).activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL));
        }
    }
}

